/*
 * Decompiled with CFR 0.152.
 */
package cloud.unum.usearch;

import cloud.unum.usearch.NativeUtils;
import java.io.IOException;

public class Index {
    private long c_ptr = 0L;

    public Index(String metric, String quantization, long dimensions, long capacity, long connectivity, long expansion_add, long expansion_search) {
        this.c_ptr = Index.c_create(metric, quantization, dimensions, capacity, connectivity, expansion_add, expansion_search);
    }

    public long size() {
        return Index.c_size(this.c_ptr);
    }

    public long connectivity() {
        return Index.c_connectivity(this.c_ptr);
    }

    public long dimensions() {
        return Index.c_dimensions(this.c_ptr);
    }

    public long capacity() {
        return Index.c_capacity(this.c_ptr);
    }

    public void reserve(long capacity) {
        Index.c_reserve(this.c_ptr, capacity);
    }

    public void add(int key, float[] vector) {
        Index.c_add(this.c_ptr, key, vector);
    }

    public int[] search(float[] vector, long count) {
        return Index.c_search(this.c_ptr, vector, count);
    }

    public void save(String path) {
        Index.c_save(this.c_ptr, path);
    }

    public void load(String path) {
        Index.c_load(this.c_ptr, path);
    }

    public void view(String path) {
        Index.c_view(this.c_ptr, path);
    }

    public boolean remove(int key) {
        return Index.c_remove(this.c_ptr, key);
    }

    public boolean rename(int from, int to) {
        return Index.c_rename(this.c_ptr, from, to);
    }

    public static void main(String[] args) {
        Index index = new Config().metric("cos").dimensions(100L).build();
        index.size();
        System.out.println("Java tests passed!");
    }

    private static native long c_create(String var0, String var1, long var2, long var4, long var6, long var8, long var10);

    private static native void c_destroy(long var0);

    private static native long c_size(long var0);

    private static native long c_connectivity(long var0);

    private static native long c_dimensions(long var0);

    private static native long c_capacity(long var0);

    private static native void c_reserve(long var0, long var2);

    private static native void c_add(long var0, int var2, float[] var3);

    private static native int[] c_search(long var0, float[] var2, long var3);

    private static native void c_save(long var0, String var2);

    private static native void c_load(long var0, String var2);

    private static native void c_view(long var0, String var2);

    private static native boolean c_remove(long var0, int var2);

    private static native boolean c_rename(long var0, int var2, int var3);

    static {
        try {
            System.loadLibrary("usearch");
        }
        catch (UnsatisfiedLinkError e) {
            try {
                NativeUtils.loadLibraryFromJar("/usearch/libusearch.so");
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static class Config {
        private String _metric = "ip";
        private String _quantization = "f32";
        private long _dimensions = 0L;
        private long _capacity = 0L;
        private long _connectivity = 0L;
        private long _expansion_add = 0L;
        private long _expansion_search = 0L;

        public Index build() {
            return new Index(this._metric, this._quantization, this._dimensions, this._capacity, this._connectivity, this._expansion_add, this._expansion_search);
        }

        public Config metric(String _metric) {
            this._metric = _metric;
            return this;
        }

        public Config quantization(String _quantization) {
            this._quantization = _quantization;
            return this;
        }

        public Config dimensions(long _dimensions) {
            this._dimensions = _dimensions;
            return this;
        }

        public Config capacity(long _capacity) {
            this._capacity = _capacity;
            return this;
        }

        public Config connectivity(long _connectivity) {
            this._connectivity = _connectivity;
            return this;
        }

        public Config expansion_add(long _expansion_add) {
            this._expansion_add = _expansion_add;
            return this;
        }

        public Config expansion_search(long _expansion_search) {
            this._expansion_search = _expansion_search;
            return this;
        }
    }
}

