/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline;

import asset.pipeline.AssetPipelineConfigHolder;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class AssetPipelineResponseBuilder
implements GroovyObject {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public String uri;
    public String ifNoneMatchHeader;
    public String ifModifiedSinceHeader;
    public Integer statusCode;
    private Date lastModifiedDate;
    public Map<String, String> headers;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader, String ifModifiedSinceHeader, Date lastModifiedDate) {
        Date date;
        String string;
        String string2;
        String string3;
        MetaClass metaClass;
        Map map;
        int n = 200;
        this.statusCode = n;
        this.headers = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.uri = string3 = uri;
        this.ifNoneMatchHeader = string2 = ifNoneMatchHeader;
        this.ifModifiedSinceHeader = string = ifModifiedSinceHeader;
        this.lastModifiedDate = date = lastModifiedDate;
        boolean digestVersion = this.isDigestVersion();
        Boolean bl = this.checkDateChanged();
        if (!(bl == null ? false : bl)) {
            int n2 = 304;
            this.statusCode = n2;
        } else {
            Boolean bl2 = this.checkETag();
            if (bl2 == null ? false : bl2) {
                String string4 = "Accept-Encoding";
                ScriptBytecodeAdapter.invokeMethodN(AssetPipelineResponseBuilder.class, this.headers, (String)"putAt", (Object[])new Object[]{"Vary", string4});
                if (digestVersion && !uri.endsWith(".html")) {
                    String string5 = "public, max-age=31536000";
                    ScriptBytecodeAdapter.invokeMethodN(AssetPipelineResponseBuilder.class, this.headers, (String)"putAt", (Object[])new Object[]{"Cache-Control", string5});
                } else {
                    String string6 = "no-cache";
                    ScriptBytecodeAdapter.invokeMethodN(AssetPipelineResponseBuilder.class, this.headers, (String)"putAt", (Object[])new Object[]{"Cache-Control", string6});
                }
            }
        }
    }

    @Generated
    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader, String ifModifiedSinceHeader) {
        CallSite[] callSiteArray = AssetPipelineResponseBuilder.$getCallSiteArray();
        this(uri, ifNoneMatchHeader, ifModifiedSinceHeader, null);
    }

    @Generated
    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader) {
        CallSite[] callSiteArray = AssetPipelineResponseBuilder.$getCallSiteArray();
        this(uri, ifNoneMatchHeader, null, null);
    }

    @Generated
    public AssetPipelineResponseBuilder(String uri) {
        CallSite[] callSiteArray = AssetPipelineResponseBuilder.$getCallSiteArray();
        this(uri, null, null, null);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getCurrentETag() {
        String manifestPath = this.uri;
        if (this.uri.startsWith("/")) {
            manifestPath = this.uri.substring(1);
        }
        Properties manifest = AssetPipelineConfigHolder.getManifest();
        Properties properties = manifest;
        String string = properties != null ? properties.getProperty(manifestPath) : null;
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\"", (CharSequence)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : manifestPath)), (CharSequence)"\"");
    }

    public boolean isDigestVersion() {
        String manifestPath = this.uri;
        if (this.uri.startsWith("/")) {
            manifestPath = this.uri.substring(1);
        }
        Properties manifest = AssetPipelineConfigHolder.getManifest();
        Properties properties = manifest;
        return !DefaultTypeTransformation.booleanUnbox(properties != null ? properties.getProperty(manifestPath, null) : null);
    }

    public Boolean checkETag() {
        String etagName = this.getCurrentETag();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.ifNoneMatchHeader) && ScriptBytecodeAdapter.compareEqual((Object)this.ifNoneMatchHeader, (Object)etagName)) {
            int n = 304;
            this.statusCode = n;
            return false;
        }
        String string = etagName;
        ScriptBytecodeAdapter.invokeMethodN(AssetPipelineResponseBuilder.class, this.headers, (String)"putAt", (Object[])new Object[]{"ETag", string});
        return true;
    }

    public Boolean checkDateChanged() {
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        boolean hasNotChanged = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.lastModifiedDate)) {
            String string = this.getLastModifiedDate(this.lastModifiedDate);
            ScriptBytecodeAdapter.invokeMethodN(AssetPipelineResponseBuilder.class, this.headers, (String)"putAt", (Object[])new Object[]{"Last-Modified", string});
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.ifModifiedSinceHeader) && DefaultTypeTransformation.booleanUnbox((Object)this.lastModifiedDate)) {
            try {
                hasNotChanged = ScriptBytecodeAdapter.compareLessThanEqual((Object)this.lastModifiedDate, (Object)sdf.parse(this.ifModifiedSinceHeader));
            }
            catch (Exception e) {
            }
        }
        return !hasNotChanged;
    }

    private String getLastModifiedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String lastModifiedDateTimeString = sdf.format(new Date());
        try {
            lastModifiedDateTimeString = sdf.format(date);
        }
        catch (Exception e) {
        }
        return lastModifiedDateTimeString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AssetPipelineResponseBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AssetPipelineResponseBuilder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AssetPipelineResponseBuilder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

