/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.processors;

import asset.pipeline.AbstractProcessor;
import asset.pipeline.AssetCompiler;
import asset.pipeline.AssetFile;
import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.JsAssetFile;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BabelJsProcessor
extends AbstractProcessor {
    private static Boolean SWC_SUPPORTED;
    private static Boolean BABEL_NATIVE_SUPPORTED;
    private ClassLoader classLoader;
    private static Context context;
    private static Value bindings;
    private static final Object $LOCK;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public BabelJsProcessor(AssetCompiler precompiler) {
        super(precompiler);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected void loadBabelJs() {
        if (!(context != null)) {
            Object object = $LOCK;
            synchronized (object) {
                if (!(context != null)) {
                    Value value;
                    Context context;
                    URL babelJsResource = this.classLoader.getResource("asset/pipeline/babel.min.js");
                    BabelJsProcessor.context = context = Context.newBuilder((String[])new String[0]).allowExperimentalOptions(true).allowHostAccess(HostAccess.newBuilder().allowListAccess(true).allowMapAccess(true).allowArrayAccess(true).build()).build();
                    BabelJsProcessor.context.eval("js", (CharSequence)ResourceGroovyMethods.getText((URL)babelJsResource, (String)"UTF-8"));
                    String presets = "{ \"presets\": [\"es2015\",[\"stage-2\",{\"decoratorsLegacy\": true}],\"react\"], \"compact\": false }";
                    String options = this.getOptions();
                    if (DefaultTypeTransformation.booleanUnbox((Object)options)) {
                        presets = options;
                    }
                    bindings = value = BabelJsProcessor.context.getBindings("js");
                    bindings.putMember("optionsJson", (Object)presets);
                    BabelJsProcessor.context.eval("js", (CharSequence)"var options = JSON.parse(optionsJson);");
                }
            }
        }
    }

    @Override
    public String process(String input, AssetFile assetFile) {
        String result;
        Boolean processed;
        block38: {
            block37: {
                if (!DefaultTypeTransformation.booleanUnbox((Object)input)) {
                    return input;
                }
                Boolean newEcmascriptKeywordsFound = false;
                if (input.contains("export default")) {
                    newEcmascriptKeywordsFound = true;
                }
                if (assetFile instanceof JsAssetFile) {
                    Boolean bl = newEcmascriptKeywordsFound;
                    if (!(bl == null ? false : bl) && !DefaultTypeTransformation.booleanUnbox(AssetPipelineConfigHolder.getConfig() == null ? null : AssetPipelineConfigHolder.getConfig().get("enableES6")) && !DefaultTypeTransformation.booleanUnbox(AssetPipelineConfigHolder.getConfig() == null ? null : AssetPipelineConfigHolder.getConfig().get("enable-es6")) || DefaultTypeTransformation.booleanUnbox((Object)newEcmascriptKeywordsFound) && (ScriptBytecodeAdapter.compareEqual(AssetPipelineConfigHolder.getConfig() == null ? null : AssetPipelineConfigHolder.getConfig().get("enableES6"), (Object)false) || ScriptBytecodeAdapter.compareEqual(AssetPipelineConfigHolder.getConfig() == null ? null : AssetPipelineConfigHolder.getConfig().get("enable-es6"), (Object)false))) {
                        return input;
                    }
                }
                processed = false;
                result = null;
                Boolean bl = this.isSwcSupported();
                if (bl == null ? false : bl) {
                    try {
                        result = ShortTypeHandling.castToString((Object)this.processWithSwcBinary(input, assetFile));
                        processed = true;
                    }
                    catch (Exception ex) {
                        Object v2;
                        if (log.isErrorEnabled()) {
                            public final class _process_closure1
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _process_closure1(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return null;
                                }

                                @Generated
                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Generated
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    CallSite[] callSiteArray = _process_closure1.$getCallSiteArray();
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _process_closure1.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[]{};
                                    return new CallSiteArray(_process_closure1.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _process_closure1.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            log.error("Error Processing from SWC...continuing with fallback option ", (Object)new _process_closure1(this, this));
                            v2 = null;
                            break block37;
                        }
                        v2 = null;
                    }
                }
            }
            Boolean bl = processed;
            if (!(bl == null ? false : bl) && DefaultTypeTransformation.booleanUnbox((Object)this.isBabelSupported())) {
                try {
                    result = ShortTypeHandling.castToString((Object)this.processWithBabelBinary(input, assetFile));
                    processed = true;
                }
                catch (Exception ex) {
                    Object v4;
                    if (log.isErrorEnabled()) {
                        public final class _process_closure2
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _process_closure2(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return null;
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _process_closure2.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _process_closure2.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_process_closure2.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _process_closure2.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        log.error("Error Processing from SWC...continuing with fallback option ", (Object)new _process_closure2(this, this));
                        v4 = null;
                        break block38;
                    }
                    v4 = null;
                }
            }
        }
        Boolean bl = processed;
        if (!(bl == null ? false : bl)) {
            try {
                try {
                    ClassLoader classLoader;
                    this.classLoader = classLoader = this.getClass().getClassLoader();
                    this.loadBabelJs();
                }
                catch (Exception e) {
                    throw (Throwable)new Exception("BabelJs Engine initialization failed.", e);
                }
            }
            finally {
                try {
                }
                catch (IllegalStateException e) {
                }
            }
            try {
                Object object = $LOCK;
                synchronized (object) {
                    bindings.putMember("input", (Object)input);
                    result = (String)ScriptBytecodeAdapter.asType((Object)context.eval("js", (CharSequence)"Babel.transform(input, options).code"), String.class);
                }
            }
            catch (Exception e) {
                throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e}, new String[]{"BabelJs Engine compilation of javascript failed.\n\t\t\t\t", "\n\t\t\t\t"})), e);
            }
        }
        return result;
    }

    protected String getOptions() {
        Map babelOptions = (Map)ScriptBytecodeAdapter.asType(AssetPipelineConfigHolder.getConfig() == null ? null : AssetPipelineConfigHolder.getConfig().get("babel"), Map.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)babelOptions)) {
            return (String)ScriptBytecodeAdapter.asType(babelOptions.get("options"), String.class);
        }
        return ShortTypeHandling.castToString(null);
    }

    public Object processWithBabelBinary(String input, AssetFile assetFile) {
        Process nodeProcess = null;
        StringBuilder output = new StringBuilder();
        StringBuilder err = new StringBuilder();
        GStringImpl globalLocation = AssetPipelineConfigHolder.getConfig() == null ? null : (GStringImpl)AssetPipelineConfigHolder.getConfig().get("globalModules");
        if (!DefaultTypeTransformation.booleanUnbox(globalLocation)) {
            Object object = $LOCK;
            synchronized (object) {
                if (!DefaultTypeTransformation.booleanUnbox(globalLocation)) {
                    Process npmProc = null;
                    StringBuilder globalLibLoc = new StringBuilder();
                    Object[] objectArray = new Object[1];
                    Boolean bl = this.isWindows();
                    objectArray[0] = (bl == null ? false : bl) ? "cmd /c " : "";
                    GStringImpl npmCmd = new GStringImpl(objectArray, new String[]{"", "npm get prefix"});
                    npmProc = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)npmCmd));
                    ProcessGroovyMethods.waitForProcessOutput((Process)npmProc, (Appendable)globalLibLoc, (Appendable)err);
                    globalLocation = new GStringImpl(new Object[]{globalLibLoc.toString().trim()}, new String[]{"", "/lib/node_modules/"});
                }
            }
        }
        GStringImpl presets = new GStringImpl(new Object[]{globalLocation}, new String[]{"--presets=", "@babel/preset-env"});
        Object[] objectArray = new Object[2];
        Boolean bl = this.isWindows();
        objectArray[0] = (bl == null ? false : bl) ? "cmd /c " : "";
        objectArray[1] = presets;
        GStringImpl command = new GStringImpl(objectArray, new String[]{"", "babel --no-babelrc ", ""});
        nodeProcess = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)command));
        nodeProcess.getOutputStream().write(input.getBytes());
        nodeProcess.getOutputStream().flush();
        nodeProcess.getOutputStream().close();
        ProcessGroovyMethods.waitForProcessOutput((Process)nodeProcess, (Appendable)output, (Appendable)err);
        if (DefaultTypeTransformation.booleanUnbox((Object)err)) {
            throw (Throwable)new Exception(err.toString());
        }
        String string = output.toString();
        try {
            return string;
        }
        catch (Exception e) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{assetFile.getName(), e}, new String[]{"\n\t\t\tBabel Engine compilation of es6 to es5 failed for ", ".\n\t\t\t", "\n\t\t\t"})));
        }
    }

    public Object processWithSwcBinary(String input, AssetFile assetFile) {
        Process nodeProcess = null;
        StringBuilder output = new StringBuilder();
        StringBuilder err = new StringBuilder();
        Object swcrcLocation = AssetPipelineConfigHolder.getConfig() == null ? null : AssetPipelineConfigHolder.getConfig().get("swcrc");
        String config = "-C module.type=commonjs -C module.strict=true -C module.noInterop=true --env-name='production'";
        if (DefaultTypeTransformation.booleanUnbox(swcrcLocation)) {
            config = StringGroovyMethods.plus((String)config, (CharSequence)new GStringImpl(new Object[]{swcrcLocation}, new String[]{" --config-file ", ""}));
        }
        Object[] objectArray = new Object[2];
        Boolean bl = this.isWindows();
        objectArray[0] = (bl == null ? false : bl) ? "cmd /c " : "";
        objectArray[1] = config;
        GStringImpl command = new GStringImpl(objectArray, new String[]{"", "swc --no-swcrc ", ""});
        nodeProcess = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)command));
        nodeProcess.getOutputStream().write(input.getBytes());
        nodeProcess.getOutputStream().flush();
        nodeProcess.getOutputStream().close();
        ProcessGroovyMethods.waitForProcessOutput((Process)nodeProcess, (Appendable)output, (Appendable)err);
        if (DefaultTypeTransformation.booleanUnbox((Object)err)) {
            throw (Throwable)new Exception(err.toString());
        }
        String string = output.toString();
        try {
            return string;
        }
        catch (Exception e) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{assetFile.getName(), e}, new String[]{"\n\t\t\tSWC Engine compilation of es6 to es5 failed for ", ".\n\t\t\t", "\n\t\t\t"})));
        }
    }

    public Boolean isSwcSupported() {
        block6: {
            if (SWC_SUPPORTED == null) {
                Process nodeProcess = null;
                StringBuilder output = new StringBuilder();
                StringBuilder err = new StringBuilder();
                try {
                    Object[] objectArray = new Object[1];
                    Boolean bl = this.isWindows();
                    objectArray[0] = (bl == null ? false : bl) ? "cmd /c " : "";
                    GStringImpl command = new GStringImpl(objectArray, new String[]{"", "swc -V"});
                    nodeProcess = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)command));
                    ProcessGroovyMethods.waitForProcessOutput((Process)nodeProcess, (Appendable)output, (Appendable)err);
                    if (DefaultTypeTransformation.booleanUnbox((Object)err)) {
                        boolean bl2 = false;
                        SWC_SUPPORTED = bl2;
                        break block6;
                    }
                    boolean bl3 = true;
                    SWC_SUPPORTED = bl3;
                }
                catch (Exception e) {
                    boolean bl = false;
                    SWC_SUPPORTED = bl;
                }
            }
        }
        return SWC_SUPPORTED;
    }

    public Boolean isBabelSupported() {
        block6: {
            if (BABEL_NATIVE_SUPPORTED == null) {
                Process nodeProcess = null;
                StringBuilder output = new StringBuilder();
                StringBuilder err = new StringBuilder();
                try {
                    Object[] objectArray = new Object[1];
                    Boolean bl = this.isWindows();
                    objectArray[0] = (bl == null ? false : bl) ? "cmd /c " : "";
                    GStringImpl command = new GStringImpl(objectArray, new String[]{"", "babel -V"});
                    nodeProcess = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)command));
                    ProcessGroovyMethods.waitForProcessOutput((Process)nodeProcess, (Appendable)output, (Appendable)err);
                    if (DefaultTypeTransformation.booleanUnbox((Object)err)) {
                        boolean bl2 = false;
                        BABEL_NATIVE_SUPPORTED = bl2;
                        break block6;
                    }
                    boolean bl3 = true;
                    BABEL_NATIVE_SUPPORTED = bl3;
                }
                catch (Exception e) {
                    boolean bl = false;
                    BABEL_NATIVE_SUPPORTED = bl;
                }
            }
        }
        return BABEL_NATIVE_SUPPORTED;
    }

    public Boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.contains("Windows");
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BabelJsProcessor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        Object[] objectArray;
        $LOCK = objectArray = new Object[0];
        log = logger = LoggerFactory.getLogger((String)"asset.pipeline.processors.BabelJsProcessor");
    }

    @Generated
    public static Boolean getSWC_SUPPORTED() {
        return SWC_SUPPORTED;
    }

    @Generated
    public static Boolean isSWC_SUPPORTED() {
        return SWC_SUPPORTED;
    }

    @Generated
    public static void setSWC_SUPPORTED(Boolean bl) {
        SWC_SUPPORTED = bl;
    }

    @Generated
    public static Boolean getBABEL_NATIVE_SUPPORTED() {
        return BABEL_NATIVE_SUPPORTED;
    }

    @Generated
    public static Boolean isBABEL_NATIVE_SUPPORTED() {
        return BABEL_NATIVE_SUPPORTED;
    }

    @Generated
    public static void setBABEL_NATIVE_SUPPORTED(Boolean bl) {
        BABEL_NATIVE_SUPPORTED = bl;
    }

    @Generated
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Generated
    public static Context getContext() {
        return context;
    }

    @Generated
    public static void setContext(Context context) {
        BabelJsProcessor.context = context;
    }

    @Generated
    public static Value getBindings() {
        return bindings;
    }

    @Generated
    public static void setBindings(Value value) {
        bindings = value;
    }
}

