/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.utils.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Urls {
    private static final Map<String, Integer> DEFAULT_PORT_BY_SCHEME = new ConcurrentHashMap<String, Integer>();
    public static final String URL_SCHEME_SANS_COLON_REGEX = "\\p{L}[\\p{L}\\d+-.]*+";
    public static final Pattern ABSOLUTE_URL_PATTERN = Pattern.compile("^(?:\\p{L}[\\p{L}\\d+-.]*+:)?/");
    public static final Pattern HAS_AUTHORITY_URL_PATTERN = Pattern.compile("^(?:\\p{L}[\\p{L}\\d+-.]*+:)?//");
    public static final Pattern URL_SCHEME_WITH_COLON_PATTERN = Pattern.compile("^\\p{L}[\\p{L}\\d+-.]*+:");
    public static final Pattern URL_SCHEME_SANS_COLON_PATTERN = Pattern.compile("^\\p{L}[\\p{L}\\d+-.]*+(?=:)");
    public static final String URL_COMPONENT_SCHEME = "scheme";
    public static final String URL_COMPONENT_USER = "user";
    public static final String URL_COMPONENT_PASSWORD = "password";
    public static final String URL_COMPONENT_HOST = "host";
    public static final String URL_COMPONENT_PORT = "port";
    public static final String URL_COMPONENT_PATH = "path";
    public static final String URL_COMPONENT_QUERY = "query";
    public static final String URL_COMPONENT_FRAGMENT = "fragment";
    public static final Pattern URL_COMPONENT_PATTERN = Pattern.compile("^(?:(?<scheme>\\p{L}[\\p{L}\\d+-.]*+):)?(?://(?:(?<user>[^#?/@:]*+)(?::(?<password>[^#?/@]*+))?@)?(?<host>[^#?/:]*+)(?::(?<port>\\d*+))?)?(?<path>[^#?]*+)(?:\\?(?<query>[^#]*+))?(?:#(?<fragment>.*+))?");

    public static StringBuilder concatenateUrl(String scheme, String user, String password, String host, String port, String path, String query, String fragment) {
        return Urls.concatenateUrl(scheme, user, password, host, port, path, query, fragment, 0);
    }

    public static StringBuilder concatenateUrl(String scheme, String user, String password, String host, String port, String path, String query, String fragment, int extraLength) {
        StringBuilder urlSb = new StringBuilder(Urls.length(scheme, 1) + Urls.length(user, 3) + Urls.length(password, 4) + Urls.length(host, 2) + Urls.length(port, 3) + Urls.length(path, 1) + Urls.length(query, 1) + Urls.length(fragment, 1) + extraLength);
        if (scheme != null) {
            urlSb.append(scheme).append(":");
        }
        if (user != null || password != null || host != null || port != null) {
            urlSb.append("//");
            if (user != null || password != null) {
                Urls.append(urlSb, user);
                Urls.append(urlSb, ':', password);
                urlSb.append('@');
            }
            Urls.append(urlSb, host);
            Urls.append(urlSb, ':', port);
            if (path != null) {
                if (path.charAt(0) != '/') {
                    urlSb.append('/');
                }
                urlSb.append(path);
            }
        } else {
            Urls.append(urlSb, path);
        }
        Urls.append(urlSb, '?', query);
        Urls.append(urlSb, '#', fragment);
        return urlSb;
    }

    private static int length(CharSequence cs, int extraLength) {
        return cs == null ? 0 : cs.length() + extraLength;
    }

    private static StringBuilder append(StringBuilder sb, String s) {
        return s == null ? sb : sb.append(s);
    }

    private static StringBuilder append(StringBuilder sb, char prefix, String s) {
        return s == null ? sb : sb.append(prefix).append(s);
    }

    public static int getDefaultPort(String scheme) {
        Integer port = DEFAULT_PORT_BY_SCHEME.get(scheme);
        if (port == null) {
            try {
                port = new URL(scheme, "localhost", "").getDefaultPort();
                DEFAULT_PORT_BY_SCHEME.put(scheme, port);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(scheme + " is an unknown scheme", ex);
            }
        }
        return port;
    }

    public static boolean isAbsolute(String url) {
        return ABSOLUTE_URL_PATTERN.matcher(url).find();
    }

    public static boolean isRelative(String url) {
        return !Urls.isAbsolute(url);
    }

    public static boolean hasAuthority(String url) {
        return HAS_AUTHORITY_URL_PATTERN.matcher(url).find();
    }

    public static String getSchemeWithColon(String url) {
        return Urls.getSchemeWithColon(url, null);
    }

    public static String getSchemeWithColon(String url, String defaultScheme) {
        Matcher m = URL_SCHEME_WITH_COLON_PATTERN.matcher(url);
        return m.find() ? m.group() : defaultScheme;
    }

    public static String getUrlSansScheme(String url) {
        return URL_SCHEME_WITH_COLON_PATTERN.matcher(url).replaceFirst("");
    }

    public static String withScheme(String url, Object o) {
        return o == null ? url : (o instanceof Boolean ? Urls.withScheme(url, (Boolean)o) : Urls.withScheme(url, o.toString()));
    }

    public static String withScheme(String url, boolean retainScheme) {
        return retainScheme ? url : Urls.getUrlSansScheme(url);
    }

    public static String withScheme(String url, String scheme) {
        return scheme + ":" + Urls.getUrlSansScheme(url);
    }

    private Urls() {
    }
}

