/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.gradle;

import asset.pipeline.AssetCompiler;
import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.AssetSpecLoader;
import asset.pipeline.fs.AssetResolver;
import asset.pipeline.fs.FileSystemAssetResolver;
import asset.pipeline.fs.JarAssetResolver;
import asset.pipeline.gradle.AssetPipelineExtension;
import asset.pipeline.gradle.AssetPipelinePlugin;
import asset.pipeline.gradle.GradleEventListener;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class AssetCompile
extends DefaultTask
implements GroovyObject {
    @Nested
    private final abstract AssetPipelineExtension config;
    @Input
    private final abstract Property<Boolean> flattenResolvers;
    @OutputDirectory
    private final abstract DirectoryProperty destinationDirectory;
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    private final abstract ConfigurableFileCollection assetConfigurationFiles;
    @Classpath
    @Optional
    private final abstract ConfigurableFileCollection classpath;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Inject
    public AssetCompile(ObjectFactory objects, Project project) {
        ConfigurableFileCollection configurableFileCollection;
        DirectoryProperty directoryProperty;
        ConfigurableFileCollection configurableFileCollection2;
        Property property;
        MetaClass metaClass;
        Reference project2 = new Reference((Object)project);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = ((Project)project2.get()).getExtensions().findByType(AssetPipelineExtension.class);
        this.config = (AssetPipelineExtension)ScriptBytecodeAdapter.castToType((Object)object, AssetPipelineExtension.class);
        this.flattenResolvers = property = objects.property(Boolean.class).convention((Object)false);
        this.assetConfigurationFiles = configurableFileCollection2 = objects.fileCollection().convention(new Object[]{((Project)project2.get()).getConfigurations().named(AssetPipelinePlugin.getASSET_CONFIGURATION_NAME())});
        this.destinationDirectory = directoryProperty = objects.directoryProperty().convention(((Project)project2.get()).getLayout().getBuildDirectory().dir("assets"));
        this.classpath = configurableFileCollection = objects.fileCollection().from(new Object[]{((Project)project2.get()).provider((Callable)((Object)new _closure1((Object)this, (Object)this, project2)))});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        Reference src = new Reference((Object)this.getProject().files(new Object[]{this.config.getAssetsPath()}).getAsFileTree());
        public final class _getSource_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference src;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSource_closure2(Object _outerInstance, Object _thisObject, Reference src) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.src = reference = src;
            }

            public FileTree doCall(File resolverFile) {
                if (resolverFile.exists() && resolverFile.isDirectory()) {
                    FileTree fileTree = ((FileTree)ScriptBytecodeAdapter.castToType((Object)this.src.get(), FileTree.class)).plus(((AssetCompile)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject().files(new Object[]{resolverFile}).getAsFileTree());
                    this.src.set((Object)fileTree);
                    return fileTree;
                }
                return (FileTree)ScriptBytecodeAdapter.castToType(null, FileTree.class);
            }

            @Generated
            public FileTree call(File resolverFile) {
                return this.doCall(resolverFile);
            }

            @Generated
            public FileTree getSrc() {
                return (FileTree)ScriptBytecodeAdapter.castToType((Object)this.src.get(), FileTree.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSource_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)this.config.getResolvers().getFiles(), (Closure)new _getSource_closure2((Object)this, (Object)this, src));
        return (FileTree)src.get();
    }

    @TaskAction
    public void compile() {
        CallSite[] callSiteArray = AssetCompile.$getCallSiteArray();
        Object object = callSiteArray[1].callGetProperty(AssetPipelineConfigHolder.class);
        Object object2 = callSiteArray[0].call(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]), callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this.config)));
        ScriptBytecodeAdapter.setProperty((Object)object2, null, AssetPipelineConfigHolder.class, (String)"config");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, AssetPipelineConfigHolder.class, (String)"resolvers");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[4].callCurrent((GroovyObject)this);
        } else {
            this.registerResolvers();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[5].callCurrent((GroovyObject)this);
        } else {
            this.loadAssetSpecifications();
        }
        Object listener = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this.config))) ? callSiteArray[8].callConstructor(GradleEventListener.class) : null;
        Map compilerArgs = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"compileDir", callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(callSiteArray[11].call((Object)this.destinationDirectory))), "enableDigests", callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this.config)), "enableGzip", callSiteArray[14].call(callSiteArray[15].callGroovyObjectGetProperty((Object)this.config)), "enableSourceMaps", callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this.config)), "excludesGzip", callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this.config), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])), "maxThreads", callSiteArray[20].callGetProperty(callSiteArray[21].callGroovyObjectGetProperty((Object)this.config)), "minifyCss", callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)this.config)), "minifyJs", callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this.config)), "minifyOptions", callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty((Object)this.config)), "skipNonDigests", callSiteArray[28].call(callSiteArray[29].callGroovyObjectGetProperty((Object)this.config))});
        Object assetCompiler = callSiteArray[30].callConstructor(AssetCompiler.class, (Object)compilerArgs, listener);
        Object object3 = callSiteArray[31].call(callSiteArray[32].callGroovyObjectGetProperty((Object)this.config));
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[33].callGetProperty(assetCompiler), (String)"default");
        Object object4 = callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this.config));
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[36].callGetProperty(assetCompiler), (String)"default");
        callSiteArray[37].call(assetCompiler);
    }

    public void registerResolvers() {
        FileSystemAssetResolver mainFileResolver = new FileSystemAssetResolver("application", ((Directory)this.config.getAssetsPath().get()).getAsFile().getCanonicalPath());
        AssetPipelineConfigHolder.registerResolver((AssetResolver)mainFileResolver);
        public final class _registerResolvers_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _registerResolvers_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File resolverFile) {
                boolean isJarFile = resolverFile.exists() && resolverFile.isFile() && resolverFile.getName().endsWith(".jar");
                boolean isAssetFolder = resolverFile.exists() && resolverFile.isDirectory();
                if (isJarFile) {
                    ((AssetCompile)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AssetCompile.class))).registerJarResolvers(resolverFile);
                    return null;
                }
                if (isAssetFolder) {
                    FileSystemAssetResolver fileResolver = new FileSystemAssetResolver(((AssetCompile)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getPath(), resolverFile.getCanonicalPath(), DefaultTypeTransformation.booleanUnbox((Object)((AssetCompile)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AssetCompile.class))).getFlattenResolvers().get()));
                    return AssetPipelineConfigHolder.registerResolver((AssetResolver)fileResolver);
                }
                return null;
            }

            @Generated
            public Object call(File resolverFile) {
                return this.doCall(resolverFile);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _registerResolvers_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)this.config.getResolvers().getFiles(), (Closure)new _registerResolvers_closure3((Object)this, (Object)this));
        ConfigurableFileCollection configurableFileCollection = this.classpath;
        Set set = configurableFileCollection != null ? configurableFileCollection.getFiles() : null;
        public final class _registerResolvers_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _registerResolvers_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                ((AssetCompile)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AssetCompile.class))).registerJarResolvers((File)ScriptBytecodeAdapter.castToType((Object)it, File.class));
                return null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _registerResolvers_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _registerResolvers_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_registerResolvers_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _registerResolvers_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Set set2 = set != null ? DefaultGroovyMethods.each((Set)set, (Closure)new _registerResolvers_closure4((Object)this, (Object)this)) : null;
    }

    public void registerJarResolvers(File jarFile) {
        boolean isJarFile = jarFile.getName().endsWith(".jar") || jarFile.getName().endsWith(".zip");
        if (jarFile.exists() && isJarFile) {
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/assets"));
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/static"));
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/resources"));
        }
    }

    public void loadAssetSpecifications() {
        Set processorFiles = this.assetConfigurationFiles.getFiles();
        if (DefaultTypeTransformation.booleanUnbox((Object)processorFiles)) {
            public final class _loadAssetSpecifications_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _loadAssetSpecifications_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public URL doCall(Object it) {
                    return ((File)it).toURI().toURL();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public URL doCall() {
                    CallSite[] callSiteArray = _loadAssetSpecifications_closure5.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadAssetSpecifications_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_loadAssetSpecifications_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadAssetSpecifications_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            URL[] urls = (URL[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.collect((Iterable)processorFiles, (Closure)new _loadAssetSpecifications_closure5((Object)this, (Object)this)).toArray(new URL[0]), URL[].class);
            URLClassLoader classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
            AssetSpecLoader.loadSpecifications((ClassLoader)classLoader);
        } else {
            AssetSpecLoader.loadSpecifications();
        }
    }

    public static /* synthetic */ Property<Boolean> pfaccess$0(AssetCompile $that) {
        return $that.flattenResolvers;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AssetCompile.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final AssetPipelineExtension getConfig() {
        return this.config;
    }

    @Generated
    public final Property<Boolean> getFlattenResolvers() {
        return this.flattenResolvers;
    }

    @Generated
    public final DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @Generated
    public final ConfigurableFileCollection getAssetConfigurationFiles() {
        return this.assetConfigurationFiles;
    }

    @Generated
    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "plus";
        stringArray[1] = "config";
        stringArray[2] = "get";
        stringArray[3] = "configOptions";
        stringArray[4] = "registerResolvers";
        stringArray[5] = "loadAssetSpecifications";
        stringArray[6] = "get";
        stringArray[7] = "verbose";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "absolutePath";
        stringArray[10] = "asFile";
        stringArray[11] = "get";
        stringArray[12] = "get";
        stringArray[13] = "enableDigests";
        stringArray[14] = "get";
        stringArray[15] = "enableGzip";
        stringArray[16] = "get";
        stringArray[17] = "enableSourceMaps";
        stringArray[18] = "getOrElse";
        stringArray[19] = "excludesGzip";
        stringArray[20] = "orNull";
        stringArray[21] = "maxThreads";
        stringArray[22] = "get";
        stringArray[23] = "minifyCss";
        stringArray[24] = "get";
        stringArray[25] = "minifyJs";
        stringArray[26] = "get";
        stringArray[27] = "minifyOptions";
        stringArray[28] = "get";
        stringArray[29] = "skipNonDigests";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "get";
        stringArray[32] = "excludes";
        stringArray[33] = "excludeRules";
        stringArray[34] = "get";
        stringArray[35] = "includes";
        stringArray[36] = "includeRules";
        stringArray[37] = "compile";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[38];
        AssetCompile.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AssetCompile.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AssetCompile.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private /* synthetic */ Reference project;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject, Reference project) {
            super(_outerInstance, _thisObject);
            Reference reference;
            this.project = reference = project;
        }

        public ConfigurableFileCollection doCall(Object it) {
            public final class _closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _closure6(Object _outerInstance, Object _thisObject, Reference project) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.project = reference = project;
                }

                public NamedDomainObjectProvider<Configuration> doCall(Object it) {
                    return (NamedDomainObjectProvider)ScriptBytecodeAdapter.castToType(((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class)).getConfigurations().getNames().contains(it) ? ((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class)).getConfigurations().named(ShortTypeHandling.castToString((Object)it)) : null, NamedDomainObjectProvider.class);
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public NamedDomainObjectProvider<Configuration> doCall() {
                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Collection existingConfigurations = DefaultGroovyMethods.findResults((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{"assets", "provided", "runtimeClasspath"}), (Closure)new _closure6((Object)this, this.getThisObject(), this.project));
            ConfigurableFileCollection configurableFileCollection = ((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class)).files(new Object[]{existingConfigurations});
            try {
                return configurableFileCollection;
            }
            catch (Exception ignored) {
                ConfigurableFileCollection configurableFileCollection2 = (ConfigurableFileCollection)ScriptBytecodeAdapter.castToType(null, ConfigurableFileCollection.class);
                return configurableFileCollection2;
            }
        }

        @Generated
        public Project getProject() {
            return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public ConfigurableFileCollection doCall() {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

