package cn.callmee.springboot.pulsar.starter.client.annotations;

import cn.callmee.springboot.pulsar.starter.client.enums.Serialization;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface PulsarProducer {

    String[] value() default {};

    String name() default "";

    String topic() default "";

    boolean async() default false;

    Serialization serialization() default Serialization.JSON;

    /**
     * Set the namespace, which is set in the configuration file by default.
     * After the setting here, it shall prevail. It is mainly used for multiple namespaces in one project.
     */
    String namespace() default "default";
}
