package cn.callmee.springboot.pulsar.starter.client.holder;


import cn.callmee.springboot.pulsar.starter.client.annotations.PulsarConsumer;
import cn.callmee.springboot.pulsar.starter.client.interceptors.DefaultConsumerInterceptor;
import cn.callmee.springboot.pulsar.starter.client.message.PulsarMessage;
import lombok.Getter;
import lombok.Setter;
import org.apache.pulsar.client.api.ConsumerInterceptor;

import java.lang.reflect.Method;

@Getter
public class ConsumerHolder {

    private PulsarConsumer annotation;
    private Method handler;
    private Object bean;
    private Class<?> type;

    @Setter
    @Getter
    private Class<? extends ConsumerInterceptor> interceptor = DefaultConsumerInterceptor.class;

    public ConsumerHolder(PulsarConsumer annotation, Method handler, Object bean, Class<?> type) {
        this.annotation = annotation;
        this.handler = handler;
        this.bean = bean;
        this.type = type;
    }

    public boolean isWrapped() {
        return type.isAssignableFrom(PulsarMessage.class);
    }
}
