package cn.callmee.springboot.pulsar.starter.client.holder;


import cn.callmee.springboot.pulsar.starter.client.enums.Serialization;
import cn.callmee.springboot.pulsar.starter.client.interceptors.DefaultProducerInterceptor;
import lombok.Getter;
import lombok.Setter;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.springframework.util.StringUtils;

import java.util.Optional;

@Getter
public class ProducerHolder {

    private String topic;
    private Class<?> clazz;
    private Serialization serialization;
    private String namespace;

    @Setter
    @Getter
    private Class<? extends ProducerInterceptor> interceptor = DefaultProducerInterceptor.class;

    public ProducerHolder(String topic, Class<?> clazz, Serialization serialization) {
        this.topic = topic;
        this.clazz = clazz;
        this.serialization = serialization;
    }

    public ProducerHolder(String topic, Class<?> clazz, Serialization serialization, String namespace) {
        this(topic, clazz, serialization);
        if (StringUtils.hasText(namespace)) {
            this.namespace = namespace;
        }
    }

    public Optional<String> getNamespace() {
        return Optional.ofNullable(namespace);
    }
}
