package cn.callmee.springboot.pulsar.starter.client.interceptors;

import lombok.extern.slf4j.Slf4j;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerInterceptor;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

import java.util.Set;

@Slf4j
public class DefaultConsumerInterceptor<T extends Object> implements ConsumerInterceptor<T> {

    @Override
    public void close() {
        log.debug("DefaultConsumerInterceptor closed");
    }

    @Override
    public Message<T> beforeConsume(Consumer<T> consumer, Message<T> message) {
        log.debug("[Pulsar consumer log:BeforeConsume] ProducerName[{}], ConsumerName:[{}], Topic:[{}], msgID:[{}]," +
                " MessageKey:[{}], PublishTime:[{}], RedeliveryCount:[{}], GetReplicatedFrom:[{}]",
            message.getProducerName(), consumer.getConsumerName(), message.getTopicName(), message.getMessageId(),
            message.getKey(), message.getPublishTime(), message.getRedeliveryCount(), message.getReplicatedFrom());

        return message;
    }

    @Override
    public void onAcknowledge(Consumer<T> consumer, MessageId messageId, Throwable exception) {
        if (exception != null) {
            log.debug("[Pulsar consumer log:OnAcknowledge] ConsumerName:[{}], msgID:[{}], exception:[{}]", consumer.getConsumerName(), messageId, exception);
            return;
        }
        log.debug("[Pulsar consumer log:OnAcknowledge] ConsumerName:[{}], msgID:[{}]", consumer.getConsumerName(), messageId);
    }

    @Override
    public void onAcknowledgeCumulative(Consumer<T> consumer, MessageId messageId, Throwable exception) {
        if (exception != null) {
            log.debug("[Pulsar consumer log:OnAcknowledgeCumulative] ConsumerName:[{}], msgID:[{}], exception:[{}]", consumer.getConsumerName(), messageId, exception);
            return;
        }
        log.debug("[Pulsar consumer log:OnAcknowledgeCumulative] ConsumerName:[{}], msgID:[{}]", consumer.getConsumerName(), messageId);
    }

    @Override
    public void onNegativeAcksSend(Consumer<T> consumer, Set<MessageId> messageIds) {
        log.debug("[Pulsar consumer log:OnNegativeAcksSend] ConsumerName:[{}], msgID:[{}]", consumer.getConsumerName(), messageIds);
    }

    @Override
    public void onAckTimeoutSend(Consumer<T> consumer, Set<MessageId> messageIds) {
        log.debug("[Pulsar consumer log:OnAckTimeoutSend] ConsumerName:[{}], msgID:[{}]", consumer.getConsumerName(), messageIds);
    }

    @Override
    public void onPartitionsChange(String topicName, int partitions) {
        log.debug("[Pulsar consumer log:OnPartitionsChange] Topic:[{}], Partitions:[{}]", topicName, partitions);
    }
}
