package cn.callmee.springboot.pulsar.starter.client.interceptors;

import lombok.extern.slf4j.Slf4j;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;

@Slf4j
public class DefaultProducerInterceptor implements ProducerInterceptor {

    @Override
    public void close() {
        log.debug("DefaultProducerInterceptor closed");
    }

    @Override
    public boolean eligible(Message message) {
        return true;
    }

    @Override
    public Message beforeSend(Producer producer, Message message) {
        log.debug("[Pulsar producer log:BeforeSend] ProducerName:[{}], Topic:[{}]",
            producer.getProducerName(),
            producer.getTopic());
        return message;
    }

    @Override
    public void onSendAcknowledgement(Producer producer, Message message, MessageId msgId, Throwable exception) {
        if (exception != null) {
            log.error("[Pulsar producer log:OnSendAcknowledgement] Producer:[{}], Topic:[{}], Payload:[{}], msgID:[{}], exception:[{}]",
                producer.getProducerName(), producer.getTopic(), message.getValue().toString(), msgId.toString(), exception);
            return;
        }
        log.debug("[Pulsar producer log:OnSendAcknowledgement] Producer:[{}], Topic:[{}] msgID:[{}]",
            producer.getProducerName(), producer.getTopic(), msgId.toString());
    }

    @Override
    public void onPartitionsChange(String topicName, int partitions) {
        log.debug("[Pulsar producer log:OnPartitionsChange] Topic:[{}], Partitions:[{}]", topicName, partitions);
    }
}
