package cn.callmee.springboot.pulsar.starter.client.properties;

import lombok.Data;
import org.apache.pulsar.client.api.SubscriptionType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "pulsar.consumer")
public class PulsarConsumerProperties {
    private int deadLetterPolicyMaxRedeliverCount = -1;
    private int ackTimeoutMs = 0;
    private String consumerNameDelimiter = ".";
    private String consumerParameterDelimiter = ",";


    private String persistentPrefix = "persistent";
    private String nonPersistentPrefix = "non-persistent";
    private String defaultPersistence = persistentPrefix;
    private String consumerNamePrefix = "CONSUMER";
    private String subscriptionNamePrefix = "SUBSCRIPTION";
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
}
