package cn.callmee.springboot.pulsar.starter.client.properties;

import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "pulsar")
public class PulsarProperties {
    private String serviceUrl = "pulsar://localhost:6650";
    private Integer ioThreads = 10;
    private Integer listenerThreads = 10;
    private boolean enableTcpNoDelay = false;
    private Integer keepAliveIntervalSec = 20;
    private Integer connectionTimeoutSec = 10;
    private Integer operationTimeoutSec = 15;
    private Integer startingBackoffIntervalMs = 100;
    private Integer maxBackoffIntervalSec = 10;
    private String consumerNameDelimiter = "";
    private String namespace = "default";
    private String tenant = "public";

    private String tokenAuthValue = null;

    private boolean autoStart = true;
    private boolean allowInterceptor = false;
    private String listenerName = null;
    @Autowired
    private PulsarConsumerProperties consumer;
    @Autowired
    private PulsarTlsProperties tls;
    @Autowired
    private PulsarOauth2Properties oauth2;
}


