package cn.callmee.springboot.pulsar.starter.client.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.HashSet;
import java.util.Set;

@Data
@Configuration
@ConfigurationProperties(prefix = "pulsar.tls")
public class PulsarTlsProperties {
    private String trustCertsFilePath = null;
    private Set<String> ciphers = new HashSet<>();
    private Set<String> protocols = new HashSet<>();
    private String trustStorePassword = null;
    private String trustStorePath = null;
    private String trustStoreType = null;
    private boolean tlsUseKeyStore = false;
    private boolean allowInsecureConnection = false;
    private boolean enableHostnameVerification = false;
    private String authCertFilePath = null;
    private String authKeyFilePath = null;
}
