package com.told.sdk.data

import com.apollographql.apollo3.ApolloClient

internal class ApolloManager {

    private lateinit var apolloClient: ApolloClient

    fun initializeApolloClient(serverUrl: String) {
        apolloClient = ApolloClient.Builder()
            .serverUrl(serverUrl)
            .build()
    }

    fun setServerUrl(serverUrl: String) {
        if (::apolloClient.isInitialized) {
            // Si apolloClient est déjà initialisé, recréez-le avec la nouvelle serverUrl
            apolloClient = ApolloClient.Builder()
                .serverUrl(serverUrl)
                .build()
        } else {
            // Si apolloClient n'est pas encore initialisé, initialisez-le avec la serverUrl
            initializeApolloClient(serverUrl)
        }
    }

    fun getApolloClient(): ApolloClient {
        if (!::apolloClient.isInitialized) {
            // Gérer l'erreur ici si apolloClient n'est pas encore initialisé
            throw IllegalStateException("ApolloClient must be initialized before accessing it.")
        }
        return apolloClient
    }
}
