package com.told.sdk.data.db

import android.content.Context
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.told.sdk.utils.Constants
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map

private val Context.dataStore by preferencesDataStore(Constants.DATASTORE_NAME)

internal class LocalStoreManagerImpl(private val context: Context) : LocalStoreManager {
    private val gson = Gson()

    override suspend fun setSurveyList(
        key: String,
        surveyList: List<LocalStoreManager.Survey>
    ) {
        if (surveyList.isEmpty()) return
        context.dataStore.edit {
            it[stringPreferencesKey(key)] = gson.toJson(surveyList)
        }
    }

    override fun getSurveyList(key: String): Flow<List<LocalStoreManager.Survey>> {
        return context.dataStore.data.map { preferences ->
            val json = preferences[stringPreferencesKey(key)] ?: return@map emptyList()
            val type = object : TypeToken<List<LocalStoreManager.Survey>>() {}.type
            gson.fromJson(json, type)
        }
    }
}