package com.told.sdk.data.web

import com.apollographql.apollo3.api.Optional
import com.told.sdk.GetEverySurveyAvailableToBeTriggeredQuery
import com.told.sdk.data.ApolloManager
import com.told.sdk.type.SurveyReplied
import com.told.sdk.utils.ToldExceptions
import java.net.UnknownHostException

internal class SurveysDataStoreImpl(serverApi: String) : SurveysDataStore {

    private val apolloClient = ApolloManager().apply {
        initializeApolloClient(serverApi)
    }.getApolloClient()

    override suspend fun getEverySurveyAvailableToBeTriggered(
        sourceId: String,
        type: String,
        os: String,
        mobileApp: String,
        language: String,
        surveysReplied: List<SurveyReplied?>?,
        applicationVersion: String
    ): Result<GetEverySurveyAvailableToBeTriggeredQuery.Data> {

        return try {
            val data = apolloClient.query(
                GetEverySurveyAvailableToBeTriggeredQuery(
                    folderId = sourceId,
                    type = "IN_APP_MOBILE",
                    os = Optional.present(os),
                    mobileApp = Optional.present(mobileApp),
                    language = Optional.present(language),
                    listReplied = Optional.presentIfNotNull(surveysReplied),
                    version = Optional.present(applicationVersion)
                )
            ).execute()

            if (data.hasErrors() || data.data == null) {
                Result.failure(ToldExceptions.NoDataException(data.errors?.firstOrNull()))
            } else {
                Result.success(data.dataAssertNoErrors)
            }
        } catch (e: UnknownHostException) {
            Result.failure(ToldExceptions.NoInternetConnectionException)
        } catch (e: Exception) {
            Result.failure(e)
        }
    }
}
