package com.told.sdk.domain

import android.util.Log
import com.told.sdk.GetEverySurveyAvailableToBeTriggeredQuery
import com.told.sdk.data.db.LocalStoreManager
import com.told.sdk.utils.Constants
import com.told.sdk.utils.InteractorWithParams
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.firstOrNull

internal class GetTriggerToDisplayInteractor(
    private val localStoreManager: LocalStoreManager
) : InteractorWithParams<GetTriggerToDisplayInteractor.Params, GetEverySurveyAvailableToBeTriggeredQuery.GetEverySurveyAvailableToBeTriggered?>(Dispatchers.IO) {

    override suspend fun execute(params: Params): GetEverySurveyAvailableToBeTriggeredQuery.GetEverySurveyAvailableToBeTriggered? {
        if(params.surveys.isEmpty()) return null
        var surveyToDisplay: GetEverySurveyAvailableToBeTriggeredQuery.GetEverySurveyAvailableToBeTriggered? = null
        run loop@{
            params.surveys.forEach { survey ->
                if(checkWhenConditions(surveyId = survey?.survey, seeItOnlyOnce = survey?.whenData?.seeItOnlyOnce, replyOnlyOnce = survey?.whenData?.replyOnlyOnce)) {
                    if (survey?.kind == "SurveyTriggerScreen") {
                        if(params?.activityName?.let { checkScreenCondition(trigger = survey?.onSurveyTriggerScreen, activityName = it) } == true) {
                            surveyToDisplay = survey
                            return@loop
                        }
                    } else if (survey?.kind == "SurveyTriggerCustomEvent") {
                        if(params?.eventName?.let { eventName-> params?.eventProperties?.let { eventProperties -> checkCustomEvent(trigger = survey?.onSurveyTriggerCustomEvent, eventName = eventName, eventProperties = eventProperties) } } == true) {
                            surveyToDisplay = survey
                            return@loop
                        }
                    }
                }
            }
        }

        return surveyToDisplay
    }
    private suspend fun checkWhenConditions(
        surveyId: String?,
        seeItOnlyOnce: Boolean?,
        replyOnlyOnce: Boolean?
    ): Boolean {
        val surveyList =
            localStoreManager.getSurveyList(key = Constants.TOLD_STORE).firstOrNull()?.toList()
        val existingSurvey = surveyList?.find { it.surveyId == surveyId }

        if (existingSurvey == null) {
            return true
        }

        if (seeItOnlyOnce == true) {
            return false
        }

        if (existingSurvey?.reply == true && replyOnlyOnce == true) {
            return false
        }
        return true
    }

    private fun checkScreenCondition(
        trigger: GetEverySurveyAvailableToBeTriggeredQuery.OnSurveyTriggerScreen?,
        activityName: String
    ): Boolean {
        return if (trigger?.onAllScreen == true) {
            true
        } else {
            //TODO : trigger.condition.value -> Créer sealed interface pour éviter des check sur string
            when (trigger?.condition?.operator) {
                "isEqualTo" -> activityName == trigger.condition.value
                "contain" -> activityName.contains(trigger.condition.value)
                "isNotEqualTo" -> activityName != trigger.condition.value
                "doesNotContain" -> !activityName.contains(trigger.condition.value)
                else -> false
            }
        }
    }

    private fun checkCustomEvent(
        trigger: GetEverySurveyAvailableToBeTriggeredQuery.OnSurveyTriggerCustomEvent?,
        eventName: String,
        eventProperties:  List<Map<String, String>>
    ): Boolean {
        if (trigger?.eventName != eventName) return false
        if (trigger?.conditions?.isEmpty() == true) {
            return true
        }
        trigger.conditions?.forEach { condition ->
            when (condition?.operator) {
                "isEqualTo" -> {
                    val value = eventProperties.find { property -> property[condition.key] == condition.value}
                    if (value == null)
                        return false
                }
                "contain" -> {
                    val value = eventProperties.find { property -> property[condition.key]!!.contains(condition.value!!)}
                    if (value == null)
                        return false
                }
                "isNotEqualTo" -> {
                    val value = eventProperties.find { property -> property[condition.key] != condition.value}
                    if (value == null)
                        return false
                }
                "doesNotCotain" -> {
                    val value = eventProperties.find { property -> property[condition.key]!!.contains(condition.value!!)}
                    if (value == null)
                        return false
                }

            }
        }
        return true
    }

    data class Params(
        val surveys: List<GetEverySurveyAvailableToBeTriggeredQuery.GetEverySurveyAvailableToBeTriggered?>,
        val activityName: String?,
        val eventName: String?,
        val eventProperties: List<Map<String, String>>?
    )
}