package com.told.sdk.domain

import com.apollographql.apollo3.api.Optional
import com.told.sdk.GetEverySurveyAvailableToBeTriggeredQuery
import com.told.sdk.data.db.LocalStoreManager
import com.told.sdk.data.web.SurveysDataStore
import com.told.sdk.data.web.SurveysDataStoreImpl
import com.told.sdk.type.SurveyReplied
import com.told.sdk.utils.Constants
import com.told.sdk.utils.InteractorWithParams
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.firstOrNull
import java.util.Locale

internal class GetTriggerableSurveysInteractor(serverApi: String) :
    InteractorWithParams<GetTriggerableSurveysInteractor.Params, Result<GetEverySurveyAvailableToBeTriggeredQuery.Data>>(
        Dispatchers.IO
    ) {

    private val surveyDataStore: SurveysDataStore = SurveysDataStoreImpl(serverApi)

    override suspend fun execute(params: Params): Result<GetEverySurveyAvailableToBeTriggeredQuery.Data> {

        val existingSurveys =
            (params.localStorageManagerInstance.getSurveyList(key = params.sourceId).firstOrNull()
                ?.toList() ?: emptyList()).find { it.sourceId == params.sourceId }?.let {
                listOf(
                    SurveyReplied(
                        Optional.present(it.surveyId),
                        Optional.present(it.date),
                        Optional.present(it.reply)
                    )
                )
            } ?: emptyList()

        return with(params) {
            surveyDataStore.getEverySurveyAvailableToBeTriggered(
                sourceId = sourceId,
                type = "IN_APP_MOBILE",
                os = Constants.MOBILE_OS,
                mobileApp = applicationId,
                language = Locale.getDefault().language,
                surveysReplied = existingSurveys,
                applicationVersion = applicationVersion
            )
        }
    }

    data class Params(
        val sourceId: String,
        val applicationId: String,
        val applicationVersion: String,
        val localStorageManagerInstance: LocalStoreManager
    )
}