package com.told.sdk

import android.webkit.WebView
import android.webkit.WebViewClient

internal class ToldWebViewClient(
    private val webView: WebView,
) : WebViewClient() {
    override fun onPageFinished(view: WebView?, url: String?) {
        super.onPageFinished(view, url)
        webView.loadUrl(
            "javascript:(function() {" +
                "window.parent.addEventListener('message', function(event) {" +
                " Android.receiveMessage(JSON.stringify(event.data)); });" +
                "})()",
        )
        webView.loadUrl("javascript:window.postMessage({type: 'DEVICE_TYPE', value: 'phone'})")
    }
}
