/*
 * Decompiled with CFR 0.152.
 */
package com.told.sdk;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.util.Log;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.activity.ComponentActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import com.told.sdk.SurveyId;
import com.told.sdk.ToldWidgetEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/told/sdk/ToldWebViewInterface;", "", "surveyId", "Lcom/told/sdk/SurveyId;", "webView", "Landroid/webkit/WebView;", "activity", "Landroidx/activity/ComponentActivity;", "onWebViewReady", "Lkotlin/Function0;", "", "trackClose", "Lkotlin/Function1;", "<init>", "(Lcom/told/sdk/SurveyId;Landroid/webkit/WebView;Landroidx/activity/ComponentActivity;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "previousHeight", "", "receiveMessage", "message", "", "told-sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nToldWebViewInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToldWebViewInterface.kt\ncom/told/sdk/ToldWebViewInterface\n+ 2 Animator.kt\nandroidx/core/animation/AnimatorKt\n*L\n1#1,83:1\n29#2:84\n85#2,18:85\n*S KotlinDebug\n*F\n+ 1 ToldWebViewInterface.kt\ncom/told/sdk/ToldWebViewInterface\n*L\n52#1:84\n52#1:85,18\n*E\n"})
public final class ToldWebViewInterface {
    @Nullable
    private final SurveyId surveyId;
    @NotNull
    private final WebView webView;
    @NotNull
    private final ComponentActivity activity;
    @NotNull
    private final Function0<Unit> onWebViewReady;
    @NotNull
    private final Function1<Function0<Unit>, Unit> trackClose;
    private int previousHeight;
    public static final int $stable = 8;

    public ToldWebViewInterface(@Nullable SurveyId surveyId, @NotNull WebView webView, @NotNull ComponentActivity activity, @NotNull Function0<Unit> onWebViewReady, @NotNull Function1<? super Function0<Unit>, Unit> trackClose2) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(onWebViewReady, (String)"onWebViewReady");
        Intrinsics.checkNotNullParameter(trackClose2, (String)"trackClose");
        this.surveyId = surveyId;
        this.webView = webView;
        this.activity = activity;
        this.onWebViewReady = onWebViewReady;
        this.trackClose = trackClose2;
        this.previousHeight = 200;
    }

    @JavascriptInterface
    public final void receiveMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.activity.runOnUiThread(() -> ToldWebViewInterface.receiveMessage$lambda$5(message, this));
    }

    private static final void receiveMessage$lambda$5$lambda$1(ToldWebViewInterface this$0, ValueAnimator valueAnimator) {
        Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"valueAnimator");
        Object object = valueAnimator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int animatedValue = (Integer)object;
        ViewGroup.LayoutParams layoutParams = this$0.webView.getLayoutParams();
        float f = animatedValue;
        Resources resources = this$0.activity.getResources();
        Float f2 = resources != null && (resources = resources.getDisplayMetrics()) != null ? Float.valueOf(resources.density) : null;
        Intrinsics.checkNotNull(f2);
        layoutParams.height = (int)(f * f2.floatValue());
        this$0.webView.setLayoutParams(layoutParams);
    }

    private static final Unit receiveMessage$lambda$5$lambda$3(ToldWebViewInterface this$0) {
        this$0.activity.finish();
        return Unit.INSTANCE;
    }

    private static final void receiveMessage$lambda$5(String $message, ToldWebViewInterface this$0) {
        try {
            JSONObject jsonMessage = new JSONObject($message);
            String string = jsonMessage.getString("type");
            if (Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.OpenLink.getRawValue()) || Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.ReplaceUrl.getRawValue())) {
                String url = jsonMessage.getJSONObject("value").getString("url");
                boolean bl = false;
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                this$0.activity.startActivity(browserIntent);
            } else if (Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.IsLoaded.getRawValue())) {
                String id = jsonMessage.getString("id");
                SurveyId surveyId = this$0.surveyId;
                if (Intrinsics.areEqual((Object)id, (Object)(surveyId != null ? surveyId.getValue() : null))) {
                    this$0.webView.loadUrl("javascript:window.postMessage({type: 'DEVICE_TYPE', value: 'phone'})");
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.HeightChange.getRawValue())) {
                SurveyId surveyId = this$0.surveyId;
                if (Intrinsics.areEqual((Object)jsonMessage.getString("id"), (Object)(surveyId != null ? surveyId.getValue() : null))) {
                    int newHeight = jsonMessage.getInt("value");
                    int[] bl = new int[]{this$0.previousHeight, newHeight};
                    ValueAnimator animator = ValueAnimator.ofInt((int[])bl);
                    animator.addUpdateListener(arg_0 -> ToldWebViewInterface.receiveMessage$lambda$5$lambda$1(this$0, arg_0));
                    Intrinsics.checkNotNull((Object)animator);
                    Animator $this$doOnEnd$iv = (Animator)animator;
                    boolean $i$f$doOnEnd = false;
                    Animator $this$addListener_u24default$iv$iv = $this$doOnEnd$iv;
                    boolean $i$f$addListener = false;
                    Animator.AnimatorListener listener$iv$iv = new Animator.AnimatorListener(this$0, newHeight){
                        final /* synthetic */ ToldWebViewInterface this$0;
                        final /* synthetic */ int $newHeight$inlined;
                        {
                            this.this$0 = toldWebViewInterface;
                            this.$newHeight$inlined = n;
                        }

                        public void onAnimationRepeat(Animator animator) {
                            Animator animator2 = animator;
                            boolean bl = false;
                        }

                        public void onAnimationEnd(Animator animator) {
                            Animator it = animator;
                            boolean bl = false;
                            ToldWebViewInterface.access$setPreviousHeight$p(this.this$0, this.$newHeight$inlined);
                            ToldWebViewInterface.access$getOnWebViewReady$p(this.this$0).invoke();
                        }

                        public void onAnimationCancel(Animator animator) {
                            Animator animator2 = animator;
                            boolean bl = false;
                        }

                        public void onAnimationStart(Animator animator) {
                            Animator animator2 = animator;
                            boolean bl = false;
                        }
                    };
                    $this$addListener_u24default$iv$iv.addListener(listener$iv$iv);
                    animator.setDuration(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)250, (DurationUnit)DurationUnit.MILLISECONDS)));
                    animator.start();
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.Close.getRawValue())) {
                SurveyId surveyId = this$0.surveyId;
                if (Intrinsics.areEqual((Object)jsonMessage.getString("id"), (Object)(surveyId != null ? surveyId.getValue() : null))) {
                    this$0.trackClose.invoke(() -> ToldWebViewInterface.receiveMessage$lambda$5$lambda$3(this$0));
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.LaunchCalendar.getRawValue())) {
                String iframeUrl = jsonMessage.getJSONObject("value").getString("iframeUrl");
                boolean bl = false;
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)iframeUrl));
                this$0.activity.startActivity(browserIntent);
            } else if (Intrinsics.areEqual((Object)string, (Object)ToldWidgetEvent.CloseCalendar.getRawValue())) {
                // empty if block
            }
        }
        catch (JSONException e) {
            Log.e((String)"WebAppInterface", (String)("Error parsing JSON message: " + $message));
        }
    }

    public static final /* synthetic */ void access$setPreviousHeight$p(ToldWebViewInterface $this, int n) {
        $this.previousHeight = n;
    }

    public static final /* synthetic */ Function0 access$getOnWebViewReady$p(ToldWebViewInterface $this) {
        return $this.onWebViewReady;
    }
}

