package com.told.sdk

import kotlin.time.Duration
import kotlin.time.Duration.Companion.seconds

/**
 * Result send when tracking an event.
 * Use by SDK to check if a survey can be display or not.
 */
sealed interface TrackEventResult {
    data class TriggerOn(val surveyId: SurveyId, val withDelay: Duration = 0.seconds) : TrackEventResult
    data object NoTrigger : TrackEventResult
}
