package club.zhcs.job.example;

import org.nutz.json.Json;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.springframework.beans.factory.annotation.Autowired;

import club.zhcs.job.client.LogReporter;
import club.zhcs.job.core.Consts.ExecutorBlockStrategyEnum;
import club.zhcs.job.core.Consts.ExecutorFailStrategyEnum;
import club.zhcs.job.core.Consts.ExecutorRouteStrategyEnum;
import club.zhcs.job.core.Job;
import club.zhcs.job.core.JobHanlder;
import club.zhcs.job.core.JobTrigerInfo;

/**
 * @author kerbores
 *
 */
@Job(cron = "0 * * * * ?", description = "测试一下集群", value = "testClusterJob")
public class TestAysnJob implements JobHanlder {
	Log log = Logs.get();
	
	@Autowired
	LogReporter logReporter;

	@Override
	public ExecutorRouteStrategyEnum routeStrategy() {
		return ExecutorRouteStrategyEnum.MODULO;
	}

	@Override
	public ExecutorBlockStrategyEnum blockStrategy() {
		return ExecutorBlockStrategyEnum.COVER_EARLY;
	}

	@Override
	public ExecutorFailStrategyEnum failStrategy() {
		return ExecutorFailStrategyEnum.FAIL_ALARM;
	}

	@Override
	public void exec(JobTrigerInfo info) {
		log.debug(Json.toJson(info));
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
			log.debug(e);
			Thread.currentThread().interrupt();
		}
		logReporter.report(info.getUuid(), info.getGroupId(), info.getName(), true, 0, "任务执行完成!");
	}

}
