package club.zhcs.job.example;

import club.zhcs.job.core.Consts.ExecutorBlockStrategyEnum;
import club.zhcs.job.core.Consts.ExecutorFailStrategyEnum;
import club.zhcs.job.core.Consts.ExecutorRouteStrategyEnum;

import org.nutz.json.Json;
import org.nutz.log.Log;
import org.nutz.log.Logs;

import club.zhcs.job.core.Job;
import club.zhcs.job.core.JobHanlder;
import club.zhcs.job.core.JobTrigerInfo;

/**
 * @author kerbores
 *
 */
@Job(cron = "0/5 * * * * ?", description = "测试一下", value = "ttt")
public class TestJob implements JobHanlder {
	Log log = Logs.get();

	/*
	 * (non-Javadoc)
	 * 
	 * @see club.zhcs.job.core.JobHanlder#exec(club.zhcs.job.core.JobTrigerInfo)
	 */
	@Override
	public void exec(JobTrigerInfo info) {
		log.debug(Json.toJson(info));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see club.zhcs.job.core.JobHanlder#routeStrategy()
	 */
	@Override
	public ExecutorRouteStrategyEnum routeStrategy() {
		return ExecutorRouteStrategyEnum.RANDOM;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see club.zhcs.job.core.JobHanlder#blockStrategy()
	 */
	@Override
	public ExecutorBlockStrategyEnum blockStrategy() {
		return ExecutorBlockStrategyEnum.COVER_EARLY;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see club.zhcs.job.core.JobHanlder#failStrategy()
	 */
	@Override
	public ExecutorFailStrategyEnum failStrategy() {
		return ExecutorFailStrategyEnum.FAIL_ALARM;
	}

}
