/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.eightchar.Yun;
import com.nlf.calendar.util.LunarUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EightChar {
    protected int sect = 2;
    protected Lunar lunar;

    public EightChar(Lunar lunar) {
        this.lunar = lunar;
    }

    public static EightChar fromLunar(Lunar lunar) {
        return new EightChar(lunar);
    }

    public String toString() {
        return this.getYear() + " " + this.getMonth() + " " + this.getDay() + " " + this.getTime();
    }

    public int getSect() {
        return this.sect;
    }

    public void setSect(int sect) {
        this.sect = 1 == sect ? 1 : 2;
    }

    public String getYear() {
        return this.lunar.getYearInGanZhiExact();
    }

    public String getYearGan() {
        return this.lunar.getYearGanExact();
    }

    public String getYearZhi() {
        return this.lunar.getYearZhiExact();
    }

    public List<String> getYearHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getYearZhi());
    }

    public String getYearWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.getYearGan()) + LunarUtil.WU_XING_ZHI.get(this.getYearZhi());
    }

    public String getYearNaYin() {
        return LunarUtil.NAYIN.get(this.getYear());
    }

    public String getYearShiShenGan() {
        return LunarUtil.SHI_SHEN_GAN.get(this.getDayGan() + this.getYearGan());
    }

    private List<String> getShiShenZhi(String zhi) {
        List<String> hideGan = LunarUtil.ZHI_HIDE_GAN.get(zhi);
        ArrayList<String> l = new ArrayList<String>(hideGan.size());
        for (String gan : hideGan) {
            l.add(LunarUtil.SHI_SHEN_ZHI.get(this.getDayGan() + zhi + gan));
        }
        return l;
    }

    public List<String> getYearShiShenZhi() {
        return this.getShiShenZhi(this.getYearZhi());
    }

    public int getDayGanIndex() {
        return 2 == this.sect ? this.lunar.getDayGanIndexExact2() : this.lunar.getDayGanIndexExact();
    }

    public int getDayZhiIndex() {
        return 2 == this.sect ? this.lunar.getDayZhiIndexExact2() : this.lunar.getDayZhiIndexExact();
    }

    private String getDiShi(int zhiIndex) {
        int index = LunarUtil.CHANG_SHENG_OFFSET.get(this.getDayGan()) + (this.getDayGanIndex() % 2 == 0 ? zhiIndex : -zhiIndex);
        if (index >= 12) {
            index -= 12;
        }
        if (index < 0) {
            index += 12;
        }
        return LunarUtil.CHANG_SHENG[index];
    }

    public String getYearDiShi() {
        return this.getDiShi(this.lunar.getYearZhiIndexExact());
    }

    public String getMonth() {
        return this.lunar.getMonthInGanZhiExact();
    }

    public String getMonthGan() {
        return this.lunar.getMonthGanExact();
    }

    public String getMonthZhi() {
        return this.lunar.getMonthZhiExact();
    }

    public List<String> getMonthHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getMonthZhi());
    }

    public String getMonthWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.getMonthGan()) + LunarUtil.WU_XING_ZHI.get(this.getMonthZhi());
    }

    public String getMonthNaYin() {
        return LunarUtil.NAYIN.get(this.getMonth());
    }

    public String getMonthShiShenGan() {
        return LunarUtil.SHI_SHEN_GAN.get(this.getDayGan() + this.getMonthGan());
    }

    public List<String> getMonthShiShenZhi() {
        return this.getShiShenZhi(this.getMonthZhi());
    }

    public String getMonthDiShi() {
        return this.getDiShi(this.lunar.getMonthZhiIndexExact());
    }

    public String getDay() {
        return 2 == this.sect ? this.lunar.getDayInGanZhiExact2() : this.lunar.getDayInGanZhiExact();
    }

    public String getDayGan() {
        return 2 == this.sect ? this.lunar.getDayGanExact2() : this.lunar.getDayGanExact();
    }

    public String getDayZhi() {
        return 2 == this.sect ? this.lunar.getDayZhiExact2() : this.lunar.getDayZhiExact();
    }

    public List<String> getDayHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getDayZhi());
    }

    public String getDayWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.getDayGan()) + LunarUtil.WU_XING_ZHI.get(this.getDayZhi());
    }

    public String getDayNaYin() {
        return LunarUtil.NAYIN.get(this.getDay());
    }

    public String getDayShiShenGan() {
        return "\u65e5\u4e3b";
    }

    public List<String> getDayShiShenZhi() {
        return this.getShiShenZhi(this.getDayZhi());
    }

    public String getDayDiShi() {
        return this.getDiShi(this.getDayZhiIndex());
    }

    public String getTime() {
        return this.lunar.getTimeInGanZhi();
    }

    public String getTimeGan() {
        return this.lunar.getTimeGan();
    }

    public String getTimeZhi() {
        return this.lunar.getTimeZhi();
    }

    public List<String> getTimeHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getTimeZhi());
    }

    public String getTimeWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.lunar.getTimeGan()) + LunarUtil.WU_XING_ZHI.get(this.lunar.getTimeZhi());
    }

    public String getTimeNaYin() {
        return LunarUtil.NAYIN.get(this.getTime());
    }

    public String getTimeShiShenGan() {
        return LunarUtil.SHI_SHEN_GAN.get(this.getDayGan() + this.getTimeGan());
    }

    public List<String> getTimeShiShenZhi() {
        return this.getShiShenZhi(this.getTimeZhi());
    }

    public String getTimeDiShi() {
        return this.getDiShi(this.lunar.getTimeZhiIndex());
    }

    public String getTaiYuan() {
        int zhiIndex;
        int ganIndex = this.lunar.getMonthGanIndexExact() + 1;
        if (ganIndex >= 10) {
            ganIndex -= 10;
        }
        if ((zhiIndex = this.lunar.getMonthZhiIndexExact() + 3) >= 12) {
            zhiIndex -= 12;
        }
        return LunarUtil.GAN[ganIndex + 1] + LunarUtil.ZHI[zhiIndex + 1];
    }

    public String getTaiYuanNaYin() {
        return LunarUtil.NAYIN.get(this.getTaiYuan());
    }

    public String getTaiXi() {
        int ganIndex = 2 == this.sect ? this.lunar.getDayGanIndexExact2() : this.lunar.getDayGanIndexExact();
        int zhiIndex = 2 == this.sect ? this.lunar.getDayZhiIndexExact2() : this.lunar.getDayZhiIndexExact();
        return LunarUtil.HE_GAN_5[ganIndex] + LunarUtil.HE_ZHI_6[zhiIndex];
    }

    public String getTaiXiNaYin() {
        return LunarUtil.NAYIN.get(this.getTaiXi());
    }

    public String getMingGong() {
        int jiaZiIndex;
        int zhiIndex;
        int monthZhiIndex = 0;
        int timeZhiIndex = 0;
        LunarUtil.IndexValue iv = LunarUtil.find(this.lunar.getMonthZhiExact(), LunarUtil.MONTH_ZHI);
        if (null != iv) {
            monthZhiIndex = iv.getIndex();
        }
        if (null != (iv = LunarUtil.find(this.lunar.getTimeZhi(), LunarUtil.MONTH_ZHI))) {
            timeZhiIndex = iv.getIndex();
        }
        if ((zhiIndex = 26 - (monthZhiIndex + timeZhiIndex)) > 12) {
            zhiIndex -= 12;
        }
        if ((jiaZiIndex = LunarUtil.getJiaZiIndex(this.lunar.getMonthInGanZhiExact()) - (monthZhiIndex - zhiIndex)) >= 60) {
            jiaZiIndex -= 60;
        }
        if (jiaZiIndex < 0) {
            jiaZiIndex += 60;
        }
        return LunarUtil.JIA_ZI[jiaZiIndex];
    }

    public String getMingGongNaYin() {
        return LunarUtil.NAYIN.get(this.getMingGong());
    }

    public String getShenGong() {
        int jiaZiIndex;
        int zhiIndex;
        int monthZhiIndex = 0;
        int timeZhiIndex = 0;
        LunarUtil.IndexValue iv = LunarUtil.find(this.lunar.getMonthZhiExact(), LunarUtil.MONTH_ZHI);
        if (null != iv) {
            monthZhiIndex = iv.getIndex();
        }
        if (null != (iv = LunarUtil.find(this.lunar.getTimeZhi(), LunarUtil.MONTH_ZHI))) {
            timeZhiIndex = iv.getIndex();
        }
        if ((zhiIndex = 2 + monthZhiIndex + timeZhiIndex) > 12) {
            zhiIndex -= 12;
        }
        if ((jiaZiIndex = LunarUtil.getJiaZiIndex(this.lunar.getMonthInGanZhiExact()) - (monthZhiIndex - zhiIndex)) >= 60) {
            jiaZiIndex -= 60;
        }
        if (jiaZiIndex < 0) {
            jiaZiIndex += 60;
        }
        return LunarUtil.JIA_ZI[jiaZiIndex];
    }

    public String getShenGongNaYin() {
        return LunarUtil.NAYIN.get(this.getShenGong());
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public Yun getYun(int gender) {
        return this.getYun(gender, 1);
    }

    public Yun getYun(int gender, int sect) {
        return new Yun(this, gender, sect);
    }

    public String getYearXun() {
        return this.lunar.getYearXunExact();
    }

    public String getYearXunKong() {
        return this.lunar.getYearXunKongExact();
    }

    public String getMonthXun() {
        return this.lunar.getMonthXunExact();
    }

    public String getMonthXunKong() {
        return this.lunar.getMonthXunKongExact();
    }

    public String getDayXun() {
        return 2 == this.sect ? this.lunar.getDayXunExact2() : this.lunar.getDayXunExact();
    }

    public String getDayXunKong() {
        return 2 == this.sect ? this.lunar.getDayXunKongExact2() : this.lunar.getDayXunKongExact();
    }

    public String getTimeXun() {
        return this.lunar.getTimeXun();
    }

    public String getTimeXunKong() {
        return this.lunar.getTimeXunKong();
    }
}

