/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.util.FotoUtil;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.NineStarUtil;
import com.nlf.calendar.util.SolarUtil;
import com.nlf.calendar.util.TaoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18n {
    private static final String DEFAULT_LANG = "chs";
    private static String LANG;
    private static boolean INIT;
    private static final Pattern PATTERN;
    private static final Map<String, Map<String, String>> MESSAGES;
    private static final Map<String, Map<String, Map<String, String>>> DICT_STRING;
    private static final Map<String, Map<String, Map<String, Integer>>> DICT_NUMBER;
    private static final Map<String, Map<String, Map<String, List<String>>>> DICT_ARRAY;
    private static final Map<String, Map<String, String[]>> ARRAYS;

    private static String replace(String key) {
        String s = key;
        Matcher matcher = PATTERN.matcher(s);
        while (matcher.find()) {
            String k = matcher.group(1);
            s = s.replace("{" + k + "}", I18n.getMessage(k));
        }
        return s;
    }

    private static void updateArray(String className) {
        Map<String, String[]> klass = ARRAYS.get(className);
        for (Map.Entry<String, String[]> prop : klass.entrySet()) {
            String propName = prop.getKey();
            String[] propValue = prop.getValue();
            int j = propValue.length;
            for (int i = 0; i < j; ++i) {
                String v = I18n.replace(propValue[i]);
                if ("LunarUtil".equals(className)) {
                    if ("GAN".equals(propName)) {
                        LunarUtil.GAN[i] = v;
                        continue;
                    }
                    if ("ZHI".equals(propName)) {
                        LunarUtil.ZHI[i] = v;
                        continue;
                    }
                    if ("JIA_ZI".equals(propName)) {
                        LunarUtil.JIA_ZI[i] = v;
                        continue;
                    }
                    if ("ZHI_XING".equals(propName)) {
                        LunarUtil.ZHI_XING[i] = v;
                        continue;
                    }
                    if ("XUN".equals(propName)) {
                        LunarUtil.XUN[i] = v;
                        continue;
                    }
                    if ("XUN_KONG".equals(propName)) {
                        LunarUtil.XUN_KONG[i] = v;
                        continue;
                    }
                    if ("CHONG".equals(propName)) {
                        LunarUtil.CHONG[i] = v;
                        continue;
                    }
                    if ("CHONG_GAN".equals(propName)) {
                        LunarUtil.CHONG_GAN[i] = v;
                        continue;
                    }
                    if ("CHONG_GAN_TIE".equals(propName)) {
                        LunarUtil.CHONG_GAN_TIE[i] = v;
                        continue;
                    }
                    if ("HE_GAN_5".equals(propName)) {
                        LunarUtil.HE_GAN_5[i] = v;
                        continue;
                    }
                    if ("HE_ZHI_6".equals(propName)) {
                        LunarUtil.HE_ZHI_6[i] = v;
                        continue;
                    }
                    if ("SHENGXIAO".equals(propName)) {
                        LunarUtil.SHENGXIAO[i] = v;
                        continue;
                    }
                    if ("NUMBER".equals(propName)) {
                        LunarUtil.NUMBER[i] = v;
                        continue;
                    }
                    if ("POSITION_XI".equals(propName)) {
                        LunarUtil.POSITION_XI[i] = v;
                        continue;
                    }
                    if ("POSITION_YANG_GUI".equals(propName)) {
                        LunarUtil.POSITION_YANG_GUI[i] = v;
                        continue;
                    }
                    if ("POSITION_YIN_GUI".equals(propName)) {
                        LunarUtil.POSITION_YIN_GUI[i] = v;
                        continue;
                    }
                    if ("POSITION_FU".equals(propName)) {
                        LunarUtil.POSITION_FU[i] = v;
                        continue;
                    }
                    if ("POSITION_FU_2".equals(propName)) {
                        LunarUtil.POSITION_FU_2[i] = v;
                        continue;
                    }
                    if ("POSITION_CAI".equals(propName)) {
                        LunarUtil.POSITION_CAI[i] = v;
                        continue;
                    }
                    if ("POSITION_TAI_SUI_YEAR".equals(propName)) {
                        LunarUtil.POSITION_TAI_SUI_YEAR[i] = v;
                        continue;
                    }
                    if ("POSITION_GAN".equals(propName)) {
                        LunarUtil.POSITION_GAN[i] = v;
                        continue;
                    }
                    if ("POSITION_ZHI".equals(propName)) {
                        LunarUtil.POSITION_ZHI[i] = v;
                        continue;
                    }
                    if ("JIE_QI".equals(propName)) {
                        LunarUtil.JIE_QI[i] = v;
                        continue;
                    }
                    if ("JIE_QI_IN_USE".equals(propName)) {
                        LunarUtil.JIE_QI_IN_USE[i] = v;
                        continue;
                    }
                    if ("TIAN_SHEN".equals(propName)) {
                        LunarUtil.TIAN_SHEN[i] = v;
                        continue;
                    }
                    if ("SHEN_SHA".equals(propName)) {
                        LunarUtil.SHEN_SHA[i] = v;
                        continue;
                    }
                    if ("PENGZU_GAN".equals(propName)) {
                        LunarUtil.PENGZU_GAN[i] = v;
                        continue;
                    }
                    if ("PENGZU_ZHI".equals(propName)) {
                        LunarUtil.PENGZU_ZHI[i] = v;
                        continue;
                    }
                    if ("MONTH_ZHI".equals(propName)) {
                        LunarUtil.MONTH_ZHI[i] = v;
                        continue;
                    }
                    if ("CHANG_SHENG".equals(propName)) {
                        LunarUtil.CHANG_SHENG[i] = v;
                        continue;
                    }
                    if ("HOU".equals(propName)) {
                        LunarUtil.HOU[i] = v;
                        continue;
                    }
                    if ("WU_HOU".equals(propName)) {
                        LunarUtil.WU_HOU[i] = v;
                        continue;
                    }
                    if ("POSITION_TAI_DAY".equals(propName)) {
                        LunarUtil.POSITION_TAI_DAY[i] = v;
                        continue;
                    }
                    if ("POSITION_TAI_MONTH".equals(propName)) {
                        LunarUtil.POSITION_TAI_MONTH[i] = v;
                        continue;
                    }
                    if ("YI_JI".equals(propName)) {
                        LunarUtil.YI_JI[i] = v;
                        continue;
                    }
                    if ("LIU_YAO".equals(propName)) {
                        LunarUtil.LIU_YAO[i] = v;
                        continue;
                    }
                    if ("MONTH".equals(propName)) {
                        LunarUtil.MONTH[i] = v;
                        continue;
                    }
                    if ("SEASON".equals(propName)) {
                        LunarUtil.SEASON[i] = v;
                        continue;
                    }
                    if ("DAY".equals(propName)) {
                        LunarUtil.DAY[i] = v;
                        continue;
                    }
                    if (!"YUE_XIANG".equals(propName)) continue;
                    LunarUtil.YUE_XIANG[i] = v;
                    continue;
                }
                if ("SolarUtil".equals(className)) {
                    if ("WEEK".equals(propName)) {
                        SolarUtil.WEEK[i] = v;
                        continue;
                    }
                    if (!"XINGZUO".equals(propName)) continue;
                    SolarUtil.XINGZUO[i] = v;
                    continue;
                }
                if ("TaoUtil".equals(className)) {
                    if (!"AN_WU".equals(propName)) continue;
                    TaoUtil.AN_WU[i] = v;
                    continue;
                }
                if ("FotoUtil".equals(className)) {
                    if (!"XIU_27".equals(propName)) continue;
                    FotoUtil.XIU_27[i] = v;
                    continue;
                }
                if (!"NineStarUtil".equals(className)) continue;
                if ("NUMBER".equals(propName)) {
                    NineStarUtil.NUMBER[i] = v;
                    continue;
                }
                if ("WU_XING".equals(propName)) {
                    NineStarUtil.WU_XING[i] = v;
                    continue;
                }
                if ("POSITION".equals(propName)) {
                    NineStarUtil.POSITION[i] = v;
                    continue;
                }
                if ("LUCK_XUAN_KONG".equals(propName)) {
                    NineStarUtil.LUCK_XUAN_KONG[i] = v;
                    continue;
                }
                if ("YIN_YANG_QI_MEN".equals(propName)) {
                    NineStarUtil.YIN_YANG_QI_MEN[i] = v;
                    continue;
                }
                if (!"COLOR".equals(propName)) continue;
                NineStarUtil.COLOR[i] = v;
            }
        }
    }

    private static void updateStringDictionary(String className) {
        Map<String, Map<String, String>> klass = DICT_STRING.get(className);
        for (Map.Entry<String, Map<String, String>> prop : klass.entrySet()) {
            String propName = prop.getKey();
            Map<String, String> propValue = prop.getValue();
            for (Map.Entry<String, String> o : propValue.entrySet()) {
                String k = I18n.replace(o.getKey());
                String v = I18n.replace(o.getValue());
                if ("LunarUtil".equals(className)) {
                    if ("TIAN_SHEN_TYPE".equals(propName)) {
                        LunarUtil.TIAN_SHEN_TYPE.put(k, v);
                        continue;
                    }
                    if ("TIAN_SHEN_TYPE_LUCK".equals(propName)) {
                        LunarUtil.TIAN_SHEN_TYPE_LUCK.put(k, v);
                        continue;
                    }
                    if ("XIU_LUCK".equals(propName)) {
                        LunarUtil.XIU_LUCK.put(k, v);
                        continue;
                    }
                    if ("LU".equals(propName)) {
                        LunarUtil.LU.put(k, v);
                        continue;
                    }
                    if ("XIU".equals(propName)) {
                        LunarUtil.XIU.put(k, v);
                        continue;
                    }
                    if ("SHA".equals(propName)) {
                        LunarUtil.SHA.put(k, v);
                        continue;
                    }
                    if ("POSITION_DESC".equals(propName)) {
                        LunarUtil.POSITION_DESC.put(k, v);
                        continue;
                    }
                    if ("NAYIN".equals(propName)) {
                        LunarUtil.NAYIN.put(k, v);
                        continue;
                    }
                    if ("WU_XING_GAN".equals(propName)) {
                        LunarUtil.WU_XING_GAN.put(k, v);
                        continue;
                    }
                    if ("WU_XING_ZHI".equals(propName)) {
                        LunarUtil.WU_XING_ZHI.put(k, v);
                        continue;
                    }
                    if ("SHOU".equals(propName)) {
                        LunarUtil.SHOU.put(k, v);
                        continue;
                    }
                    if ("GONG".equals(propName)) {
                        LunarUtil.GONG.put(k, v);
                        continue;
                    }
                    if ("FESTIVAL".equals(propName)) {
                        LunarUtil.FESTIVAL.put(k, v);
                        continue;
                    }
                    if ("ZHENG".equals(propName)) {
                        LunarUtil.ZHENG.put(k, v);
                        continue;
                    }
                    if ("ANIMAL".equals(propName)) {
                        LunarUtil.ANIMAL.put(k, v);
                        continue;
                    }
                    if ("SHI_SHEN_GAN".equals(propName)) {
                        LunarUtil.SHI_SHEN_GAN.put(k, v);
                        continue;
                    }
                    if ("SHI_SHEN_ZHI".equals(propName)) {
                        LunarUtil.SHI_SHEN_ZHI.put(k, v);
                        continue;
                    }
                    if (!"XIU_SONG".equals(propName)) continue;
                    LunarUtil.XIU_SONG.put(k, v);
                    continue;
                }
                if ("SolarUtil".equals(className)) {
                    if (!"FESTIVAL".equals(propName)) continue;
                    SolarUtil.FESTIVAL.put(k, v);
                    continue;
                }
                if (!"TaoUtil".equals(className)) continue;
                if ("BA_HUI".equals(propName)) {
                    TaoUtil.BA_HUI.put(k, v);
                    continue;
                }
                if (!"BA_JIE".equals(propName)) continue;
                TaoUtil.BA_JIE.put(k, v);
            }
        }
    }

    private static void updateNumberDictionary(String className) {
        Map<String, Map<String, Integer>> klass = DICT_NUMBER.get(className);
        for (Map.Entry<String, Map<String, Integer>> prop : klass.entrySet()) {
            String propName = prop.getKey();
            Map<String, Integer> propValue = prop.getValue();
            for (Map.Entry<String, Integer> o : propValue.entrySet()) {
                String k = I18n.replace(o.getKey());
                int v = o.getValue();
                if (!"LunarUtil".equals(className)) continue;
                if ("ZHI_TIAN_SHEN_OFFSET".equals(propName)) {
                    LunarUtil.ZHI_TIAN_SHEN_OFFSET.put(k, v);
                    continue;
                }
                if (!"CHANG_SHENG_OFFSET".equals(propName)) continue;
                LunarUtil.CHANG_SHENG_OFFSET.put(k, v);
            }
        }
    }

    private static void updateArrayDictionary(String className) {
        Map<String, Map<String, List<String>>> klass = DICT_ARRAY.get(className);
        for (Map.Entry<String, Map<String, List<String>>> prop : klass.entrySet()) {
            String propName = prop.getKey();
            Map<String, List<String>> propValue = prop.getValue();
            for (Map.Entry<String, List<String>> o : propValue.entrySet()) {
                ArrayList<String> nv = new ArrayList<String>();
                for (String v : o.getValue()) {
                    nv.add(I18n.replace(v));
                }
                if (!"LunarUtil".equals(className) || !"ZHI_HIDE_GAN".equals(propName)) continue;
                LunarUtil.ZHI_HIDE_GAN.put(I18n.replace(o.getKey()), nv);
            }
        }
    }

    private static void update() {
        for (String c : ARRAYS.keySet()) {
            I18n.updateArray(c);
        }
        for (String c : DICT_STRING.keySet()) {
            I18n.updateStringDictionary(c);
        }
        for (String c : DICT_NUMBER.keySet()) {
            I18n.updateNumberDictionary(c);
        }
        for (String c : DICT_ARRAY.keySet()) {
            I18n.updateArrayDictionary(c);
        }
    }

    public static String getMessage(String key) {
        Map<String, String> messages = MESSAGES.get(LANG);
        String value = null;
        if (null != messages) {
            value = messages.get(key);
        }
        if (null == value) {
            messages = MESSAGES.get(DEFAULT_LANG);
        }
        if (null != messages) {
            value = messages.get(key);
        }
        return null == value ? key : value;
    }

    public static void setMessages(String lang, Map<String, String> messages) {
        if (null == messages) {
            return;
        }
        Map<String, String> v = MESSAGES.get(lang);
        if (null == v) {
            v = new HashMap<String, String>();
            MESSAGES.put(lang, v);
        }
        v.putAll(messages);
        I18n.update();
    }

    public static String getLanguage() {
        return LANG;
    }

    public static void setLanguage(String lang) {
        if (MESSAGES.containsKey(lang)) {
            LANG = lang;
            I18n.update();
        }
    }

    private static void initArray() {
        Map<String, String[]> klass = ARRAYS.get("LunarUtil");
        int n = LunarUtil.GAN.length;
        String[] v = new String[n];
        System.arraycopy(LunarUtil.GAN, 0, v, 0, n);
        klass.put("GAN", v);
        n = LunarUtil.ZHI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.ZHI, 0, v, 0, n);
        klass.put("ZHI", v);
        n = LunarUtil.JIA_ZI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.JIA_ZI, 0, v, 0, n);
        klass.put("JIA_ZI", v);
        n = LunarUtil.ZHI_XING.length;
        v = new String[n];
        System.arraycopy(LunarUtil.ZHI_XING, 0, v, 0, n);
        klass.put("ZHI_XING", v);
        n = LunarUtil.XUN.length;
        v = new String[n];
        System.arraycopy(LunarUtil.XUN, 0, v, 0, n);
        klass.put("XUN", v);
        n = LunarUtil.XUN_KONG.length;
        v = new String[n];
        System.arraycopy(LunarUtil.XUN_KONG, 0, v, 0, n);
        klass.put("XUN_KONG", v);
        n = LunarUtil.CHONG.length;
        v = new String[n];
        System.arraycopy(LunarUtil.CHONG, 0, v, 0, n);
        klass.put("CHONG", v);
        n = LunarUtil.CHONG_GAN.length;
        v = new String[n];
        System.arraycopy(LunarUtil.CHONG_GAN, 0, v, 0, n);
        klass.put("CHONG_GAN", v);
        n = LunarUtil.CHONG_GAN_TIE.length;
        v = new String[n];
        System.arraycopy(LunarUtil.CHONG_GAN_TIE, 0, v, 0, n);
        klass.put("CHONG_GAN_TIE", v);
        n = LunarUtil.HE_GAN_5.length;
        v = new String[n];
        System.arraycopy(LunarUtil.HE_GAN_5, 0, v, 0, n);
        klass.put("HE_GAN_5", v);
        n = LunarUtil.HE_ZHI_6.length;
        v = new String[n];
        System.arraycopy(LunarUtil.HE_ZHI_6, 0, v, 0, n);
        klass.put("HE_ZHI_6", v);
        n = LunarUtil.SHENGXIAO.length;
        v = new String[n];
        System.arraycopy(LunarUtil.SHENGXIAO, 0, v, 0, n);
        klass.put("SHENGXIAO", v);
        n = LunarUtil.NUMBER.length;
        v = new String[n];
        System.arraycopy(LunarUtil.NUMBER, 0, v, 0, n);
        klass.put("NUMBER", v);
        n = LunarUtil.POSITION_XI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_XI, 0, v, 0, n);
        klass.put("POSITION_XI", v);
        n = LunarUtil.POSITION_YANG_GUI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_YANG_GUI, 0, v, 0, n);
        klass.put("POSITION_YANG_GUI", v);
        n = LunarUtil.POSITION_YIN_GUI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_YIN_GUI, 0, v, 0, n);
        klass.put("POSITION_YIN_GUI", v);
        n = LunarUtil.POSITION_FU.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_FU, 0, v, 0, n);
        klass.put("POSITION_FU", v);
        n = LunarUtil.POSITION_FU_2.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_FU_2, 0, v, 0, n);
        klass.put("POSITION_FU_2", v);
        n = LunarUtil.POSITION_CAI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_CAI, 0, v, 0, n);
        klass.put("POSITION_CAI", v);
        n = LunarUtil.POSITION_TAI_SUI_YEAR.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_TAI_SUI_YEAR, 0, v, 0, n);
        klass.put("POSITION_TAI_SUI_YEAR", v);
        n = LunarUtil.POSITION_GAN.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_GAN, 0, v, 0, n);
        klass.put("POSITION_GAN", v);
        n = LunarUtil.POSITION_ZHI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_ZHI, 0, v, 0, n);
        klass.put("POSITION_ZHI", v);
        n = LunarUtil.JIE_QI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.JIE_QI, 0, v, 0, n);
        klass.put("JIE_QI", v);
        n = LunarUtil.JIE_QI_IN_USE.length;
        v = new String[n];
        System.arraycopy(LunarUtil.JIE_QI_IN_USE, 0, v, 0, n);
        klass.put("JIE_QI_IN_USE", v);
        n = LunarUtil.TIAN_SHEN.length;
        v = new String[n];
        System.arraycopy(LunarUtil.TIAN_SHEN, 0, v, 0, n);
        klass.put("TIAN_SHEN", v);
        n = LunarUtil.SHEN_SHA.length;
        v = new String[n];
        System.arraycopy(LunarUtil.SHEN_SHA, 0, v, 0, n);
        klass.put("SHEN_SHA", v);
        n = LunarUtil.PENGZU_GAN.length;
        v = new String[n];
        System.arraycopy(LunarUtil.PENGZU_GAN, 0, v, 0, n);
        klass.put("PENGZU_GAN", v);
        n = LunarUtil.PENGZU_ZHI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.PENGZU_ZHI, 0, v, 0, n);
        klass.put("PENGZU_ZHI", v);
        n = LunarUtil.MONTH_ZHI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.MONTH_ZHI, 0, v, 0, n);
        klass.put("MONTH_ZHI", v);
        n = LunarUtil.CHANG_SHENG.length;
        v = new String[n];
        System.arraycopy(LunarUtil.CHANG_SHENG, 0, v, 0, n);
        klass.put("CHANG_SHENG", v);
        n = LunarUtil.HOU.length;
        v = new String[n];
        System.arraycopy(LunarUtil.HOU, 0, v, 0, n);
        klass.put("HOU", v);
        n = LunarUtil.WU_HOU.length;
        v = new String[n];
        System.arraycopy(LunarUtil.WU_HOU, 0, v, 0, n);
        klass.put("WU_HOU", v);
        n = LunarUtil.POSITION_TAI_DAY.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_TAI_DAY, 0, v, 0, n);
        klass.put("POSITION_TAI_DAY", v);
        n = LunarUtil.POSITION_TAI_MONTH.length;
        v = new String[n];
        System.arraycopy(LunarUtil.POSITION_TAI_MONTH, 0, v, 0, n);
        klass.put("POSITION_TAI_MONTH", v);
        n = LunarUtil.YI_JI.length;
        v = new String[n];
        System.arraycopy(LunarUtil.YI_JI, 0, v, 0, n);
        klass.put("YI_JI", v);
        n = LunarUtil.LIU_YAO.length;
        v = new String[n];
        System.arraycopy(LunarUtil.LIU_YAO, 0, v, 0, n);
        klass.put("LIU_YAO", v);
        n = LunarUtil.MONTH.length;
        v = new String[n];
        System.arraycopy(LunarUtil.MONTH, 0, v, 0, n);
        klass.put("MONTH", v);
        n = LunarUtil.SEASON.length;
        v = new String[n];
        System.arraycopy(LunarUtil.SEASON, 0, v, 0, n);
        klass.put("SEASON", v);
        n = LunarUtil.DAY.length;
        v = new String[n];
        System.arraycopy(LunarUtil.DAY, 0, v, 0, n);
        klass.put("DAY", v);
        n = LunarUtil.YUE_XIANG.length;
        v = new String[n];
        System.arraycopy(LunarUtil.YUE_XIANG, 0, v, 0, n);
        klass.put("YUE_XIANG", v);
        klass = ARRAYS.get("SolarUtil");
        n = SolarUtil.WEEK.length;
        v = new String[n];
        System.arraycopy(SolarUtil.WEEK, 0, v, 0, n);
        klass.put("WEEK", v);
        n = SolarUtil.XINGZUO.length;
        v = new String[n];
        System.arraycopy(SolarUtil.XINGZUO, 0, v, 0, n);
        klass.put("XINGZUO", v);
        klass = ARRAYS.get("TaoUtil");
        n = TaoUtil.AN_WU.length;
        v = new String[n];
        System.arraycopy(TaoUtil.AN_WU, 0, v, 0, n);
        klass.put("AN_WU", v);
        klass = ARRAYS.get("FotoUtil");
        n = FotoUtil.XIU_27.length;
        v = new String[n];
        System.arraycopy(FotoUtil.XIU_27, 0, v, 0, n);
        klass.put("XIU_27", v);
        klass = ARRAYS.get("NineStarUtil");
        n = NineStarUtil.NUMBER.length;
        v = new String[n];
        System.arraycopy(NineStarUtil.NUMBER, 0, v, 0, n);
        klass.put("NUMBER", v);
        n = NineStarUtil.WU_XING.length;
        v = new String[n];
        System.arraycopy(NineStarUtil.WU_XING, 0, v, 0, n);
        klass.put("WU_XING", v);
        n = NineStarUtil.POSITION.length;
        v = new String[n];
        System.arraycopy(NineStarUtil.POSITION, 0, v, 0, n);
        klass.put("POSITION", v);
        n = NineStarUtil.LUCK_XUAN_KONG.length;
        v = new String[n];
        System.arraycopy(NineStarUtil.LUCK_XUAN_KONG, 0, v, 0, n);
        klass.put("LUCK_XUAN_KONG", v);
        n = NineStarUtil.YIN_YANG_QI_MEN.length;
        v = new String[n];
        System.arraycopy(NineStarUtil.YIN_YANG_QI_MEN, 0, v, 0, n);
        klass.put("YIN_YANG_QI_MEN", v);
        n = NineStarUtil.COLOR.length;
        v = new String[n];
        System.arraycopy(NineStarUtil.COLOR, 0, v, 0, n);
        klass.put("COLOR", v);
    }

    private static void initStringDictionary() {
        Map<String, Map<String, String>> v = DICT_STRING.get("LunarUtil");
        v.get("TIAN_SHEN_TYPE").putAll(LunarUtil.TIAN_SHEN_TYPE);
        v.get("TIAN_SHEN_TYPE_LUCK").putAll(LunarUtil.TIAN_SHEN_TYPE_LUCK);
        v.get("XIU_LUCK").putAll(LunarUtil.XIU_LUCK);
        v.get("LU").putAll(LunarUtil.LU);
        v.get("XIU").putAll(LunarUtil.XIU);
        v.get("SHA").putAll(LunarUtil.SHA);
        v.get("POSITION_DESC").putAll(LunarUtil.POSITION_DESC);
        v.get("NAYIN").putAll(LunarUtil.NAYIN);
        v.get("WU_XING_GAN").putAll(LunarUtil.WU_XING_GAN);
        v.get("WU_XING_ZHI").putAll(LunarUtil.WU_XING_ZHI);
        v.get("SHOU").putAll(LunarUtil.SHOU);
        v.get("GONG").putAll(LunarUtil.GONG);
        v.get("FESTIVAL").putAll(LunarUtil.FESTIVAL);
        v.get("ZHENG").putAll(LunarUtil.ZHENG);
        v.get("ANIMAL").putAll(LunarUtil.ANIMAL);
        v.get("SHI_SHEN_GAN").putAll(LunarUtil.SHI_SHEN_GAN);
        v.get("SHI_SHEN_ZHI").putAll(LunarUtil.SHI_SHEN_ZHI);
        v.get("XIU_SONG").putAll(LunarUtil.XIU_SONG);
        v = DICT_STRING.get("SolarUtil");
        v.get("FESTIVAL").putAll(SolarUtil.FESTIVAL);
        v = DICT_STRING.get("TaoUtil");
        v.get("BA_HUI").putAll(TaoUtil.BA_HUI);
        v.get("BA_JIE").putAll(TaoUtil.BA_JIE);
    }

    private static void initNumberDictionary() {
        Map<String, Map<String, Integer>> v = DICT_NUMBER.get("LunarUtil");
        v.get("ZHI_TIAN_SHEN_OFFSET").putAll(LunarUtil.ZHI_TIAN_SHEN_OFFSET);
        v.get("CHANG_SHENG_OFFSET").putAll(LunarUtil.CHANG_SHENG_OFFSET);
    }

    private static void initArrayDictionary() {
        Map<String, Map<String, List<String>>> v = DICT_ARRAY.get("LunarUtil");
        Map<String, List<String>> m = v.get("ZHI_HIDE_GAN");
        for (Map.Entry<String, List<String>> o : LunarUtil.ZHI_HIDE_GAN.entrySet()) {
            m.put(o.getKey(), new ArrayList(o.getValue()));
        }
    }

    public static void init() {
        if (INIT) {
            return;
        }
        INIT = true;
        I18n.initArray();
        I18n.initStringDictionary();
        I18n.initNumberDictionary();
        I18n.initArrayDictionary();
        I18n.setLanguage(DEFAULT_LANG);
    }

    static {
        INIT = false;
        PATTERN = Pattern.compile("\\{(.[^}]*)\\}");
        MESSAGES = new HashMap<String, Map<String, String>>(){
            {
                this.put(I18n.DEFAULT_LANG, new HashMap<String, String>(){
                    {
                        this.put("tg.jia", "\u7532");
                        this.put("tg.yi", "\u4e59");
                        this.put("tg.bing", "\u4e19");
                        this.put("tg.ding", "\u4e01");
                        this.put("tg.wu", "\u620a");
                        this.put("tg.ji", "\u5df1");
                        this.put("tg.geng", "\u5e9a");
                        this.put("tg.xin", "\u8f9b");
                        this.put("tg.ren", "\u58ec");
                        this.put("tg.gui", "\u7678");
                        this.put("dz.zi", "\u5b50");
                        this.put("dz.chou", "\u4e11");
                        this.put("dz.yin", "\u5bc5");
                        this.put("dz.mao", "\u536f");
                        this.put("dz.chen", "\u8fb0");
                        this.put("dz.si", "\u5df3");
                        this.put("dz.wu", "\u5348");
                        this.put("dz.wei", "\u672a");
                        this.put("dz.shen", "\u7533");
                        this.put("dz.you", "\u9149");
                        this.put("dz.xu", "\u620c");
                        this.put("dz.hai", "\u4ea5");
                        this.put("zx.jian", "\u5efa");
                        this.put("zx.chu", "\u9664");
                        this.put("zx.man", "\u6ee1");
                        this.put("zx.ping", "\u5e73");
                        this.put("zx.ding", "\u5b9a");
                        this.put("zx.zhi", "\u6267");
                        this.put("zx.po", "\u7834");
                        this.put("zx.wei", "\u5371");
                        this.put("zx.cheng", "\u6210");
                        this.put("zx.shou", "\u6536");
                        this.put("zx.kai", "\u5f00");
                        this.put("zx.bi", "\u95ed");
                        this.put("jz.jiaZi", "\u7532\u5b50");
                        this.put("jz.yiChou", "\u4e59\u4e11");
                        this.put("jz.bingYin", "\u4e19\u5bc5");
                        this.put("jz.dingMao", "\u4e01\u536f");
                        this.put("jz.wuChen", "\u620a\u8fb0");
                        this.put("jz.jiSi", "\u5df1\u5df3");
                        this.put("jz.gengWu", "\u5e9a\u5348");
                        this.put("jz.xinWei", "\u8f9b\u672a");
                        this.put("jz.renShen", "\u58ec\u7533");
                        this.put("jz.guiYou", "\u7678\u9149");
                        this.put("jz.jiaXu", "\u7532\u620c");
                        this.put("jz.yiHai", "\u4e59\u4ea5");
                        this.put("jz.bingZi", "\u4e19\u5b50");
                        this.put("jz.dingChou", "\u4e01\u4e11");
                        this.put("jz.wuYin", "\u620a\u5bc5");
                        this.put("jz.jiMao", "\u5df1\u536f");
                        this.put("jz.gengChen", "\u5e9a\u8fb0");
                        this.put("jz.xinSi", "\u8f9b\u5df3");
                        this.put("jz.renWu", "\u58ec\u5348");
                        this.put("jz.guiWei", "\u7678\u672a");
                        this.put("jz.jiaShen", "\u7532\u7533");
                        this.put("jz.yiYou", "\u4e59\u9149");
                        this.put("jz.bingXu", "\u4e19\u620c");
                        this.put("jz.dingHai", "\u4e01\u4ea5");
                        this.put("jz.wuZi", "\u620a\u5b50");
                        this.put("jz.jiChou", "\u5df1\u4e11");
                        this.put("jz.gengYin", "\u5e9a\u5bc5");
                        this.put("jz.xinMao", "\u8f9b\u536f");
                        this.put("jz.renChen", "\u58ec\u8fb0");
                        this.put("jz.guiSi", "\u7678\u5df3");
                        this.put("jz.jiaWu", "\u7532\u5348");
                        this.put("jz.yiWei", "\u4e59\u672a");
                        this.put("jz.bingShen", "\u4e19\u7533");
                        this.put("jz.dingYou", "\u4e01\u9149");
                        this.put("jz.wuXu", "\u620a\u620c");
                        this.put("jz.jiHai", "\u5df1\u4ea5");
                        this.put("jz.gengZi", "\u5e9a\u5b50");
                        this.put("jz.xinChou", "\u8f9b\u4e11");
                        this.put("jz.renYin", "\u58ec\u5bc5");
                        this.put("jz.guiMao", "\u7678\u536f");
                        this.put("jz.jiaChen", "\u7532\u8fb0");
                        this.put("jz.yiSi", "\u4e59\u5df3");
                        this.put("jz.bingWu", "\u4e19\u5348");
                        this.put("jz.dingWei", "\u4e01\u672a");
                        this.put("jz.wuShen", "\u620a\u7533");
                        this.put("jz.jiYou", "\u5df1\u9149");
                        this.put("jz.gengXu", "\u5e9a\u620c");
                        this.put("jz.xinHai", "\u8f9b\u4ea5");
                        this.put("jz.renZi", "\u58ec\u5b50");
                        this.put("jz.guiChou", "\u7678\u4e11");
                        this.put("jz.jiaYin", "\u7532\u5bc5");
                        this.put("jz.yiMao", "\u4e59\u536f");
                        this.put("jz.bingChen", "\u4e19\u8fb0");
                        this.put("jz.dingSi", "\u4e01\u5df3");
                        this.put("jz.wuWu", "\u620a\u5348");
                        this.put("jz.jiWei", "\u5df1\u672a");
                        this.put("jz.gengShen", "\u5e9a\u7533");
                        this.put("jz.xinYou", "\u8f9b\u9149");
                        this.put("jz.renXu", "\u58ec\u620c");
                        this.put("jz.guiHai", "\u7678\u4ea5");
                        this.put("sx.rat", "\u9f20");
                        this.put("sx.ox", "\u725b");
                        this.put("sx.tiger", "\u864e");
                        this.put("sx.rabbit", "\u5154");
                        this.put("sx.dragon", "\u9f99");
                        this.put("sx.snake", "\u86c7");
                        this.put("sx.horse", "\u9a6c");
                        this.put("sx.goat", "\u7f8a");
                        this.put("sx.monkey", "\u7334");
                        this.put("sx.rooster", "\u9e21");
                        this.put("sx.dog", "\u72d7");
                        this.put("sx.pig", "\u732a");
                        this.put("dw.long", "\u9f99");
                        this.put("dw.niu", "\u725b");
                        this.put("dw.gou", "\u72d7");
                        this.put("dw.yang", "\u7f8a");
                        this.put("dw.tu", "\u5154");
                        this.put("dw.shu", "\u9f20");
                        this.put("dw.ji", "\u9e21");
                        this.put("dw.ma", "\u9a6c");
                        this.put("dw.hu", "\u864e");
                        this.put("dw.zhu", "\u732a");
                        this.put("dw.hou", "\u7334");
                        this.put("dw.she", "\u86c7");
                        this.put("dw.huLi", "\u72d0");
                        this.put("dw.yan", "\u71d5");
                        this.put("dw.bao", "\u8c79");
                        this.put("dw.yuan", "\u733f");
                        this.put("dw.yin", "\u8693");
                        this.put("dw.lu", "\u9e7f");
                        this.put("dw.wu", "\u4e4c");
                        this.put("dw.jiao", "\u86df");
                        this.put("dw.lang", "\u72fc");
                        this.put("dw.fu", "\u8760");
                        this.put("dw.zhang", "\u7350");
                        this.put("dw.xu", "\u735d");
                        this.put("dw.xie", "\u736c");
                        this.put("dw.han", "\u72b4");
                        this.put("dw.he", "\u8c89");
                        this.put("dw.zhi", "\u5f58");
                        this.put("wx.jin", "\u91d1");
                        this.put("wx.mu", "\u6728");
                        this.put("wx.shui", "\u6c34");
                        this.put("wx.huo", "\u706b");
                        this.put("wx.tu", "\u571f");
                        this.put("wx.ri", "\u65e5");
                        this.put("wx.yue", "\u6708");
                        this.put("n.zero", "\u3007");
                        this.put("n.one", "\u4e00");
                        this.put("n.two", "\u4e8c");
                        this.put("n.three", "\u4e09");
                        this.put("n.four", "\u56db");
                        this.put("n.five", "\u4e94");
                        this.put("n.six", "\u516d");
                        this.put("n.seven", "\u4e03");
                        this.put("n.eight", "\u516b");
                        this.put("n.nine", "\u4e5d");
                        this.put("n.ten", "\u5341");
                        this.put("n.eleven", "\u5341\u4e00");
                        this.put("n.twelve", "\u5341\u4e8c");
                        this.put("d.one", "\u521d\u4e00");
                        this.put("d.two", "\u521d\u4e8c");
                        this.put("d.three", "\u521d\u4e09");
                        this.put("d.four", "\u521d\u56db");
                        this.put("d.five", "\u521d\u4e94");
                        this.put("d.six", "\u521d\u516d");
                        this.put("d.seven", "\u521d\u4e03");
                        this.put("d.eight", "\u521d\u516b");
                        this.put("d.nine", "\u521d\u4e5d");
                        this.put("d.ten", "\u521d\u5341");
                        this.put("d.eleven", "\u5341\u4e00");
                        this.put("d.twelve", "\u5341\u4e8c");
                        this.put("d.thirteen", "\u5341\u4e09");
                        this.put("d.fourteen", "\u5341\u56db");
                        this.put("d.fifteen", "\u5341\u4e94");
                        this.put("d.sixteen", "\u5341\u516d");
                        this.put("d.seventeen", "\u5341\u4e03");
                        this.put("d.eighteen", "\u5341\u516b");
                        this.put("d.nighteen", "\u5341\u4e5d");
                        this.put("d.twenty", "\u4e8c\u5341");
                        this.put("d.twentyOne", "\u5eff\u4e00");
                        this.put("d.twentyTwo", "\u5eff\u4e8c");
                        this.put("d.twentyThree", "\u5eff\u4e09");
                        this.put("d.twentyFour", "\u5eff\u56db");
                        this.put("d.twentyFive", "\u5eff\u4e94");
                        this.put("d.twentySix", "\u5eff\u516d");
                        this.put("d.twentySeven", "\u5eff\u4e03");
                        this.put("d.twentyEight", "\u5eff\u516b");
                        this.put("d.twentyNine", "\u5eff\u4e5d");
                        this.put("d.thirty", "\u4e09\u5341");
                        this.put("m.one", "\u6b63");
                        this.put("m.two", "\u4e8c");
                        this.put("m.three", "\u4e09");
                        this.put("m.four", "\u56db");
                        this.put("m.five", "\u4e94");
                        this.put("m.six", "\u516d");
                        this.put("m.seven", "\u4e03");
                        this.put("m.eight", "\u516b");
                        this.put("m.nine", "\u4e5d");
                        this.put("m.ten", "\u5341");
                        this.put("m.eleven", "\u51ac");
                        this.put("m.twelve", "\u814a");
                        this.put("w.sun", "\u65e5");
                        this.put("w.mon", "\u4e00");
                        this.put("w.tues", "\u4e8c");
                        this.put("w.wed", "\u4e09");
                        this.put("w.thur", "\u56db");
                        this.put("w.fri", "\u4e94");
                        this.put("w.sat", "\u516d");
                        this.put("xz.aries", "\u767d\u7f8a");
                        this.put("xz.taurus", "\u91d1\u725b");
                        this.put("xz.gemini", "\u53cc\u5b50");
                        this.put("xz.cancer", "\u5de8\u87f9");
                        this.put("xz.leo", "\u72ee\u5b50");
                        this.put("xz.virgo", "\u5904\u5973");
                        this.put("xz.libra", "\u5929\u79e4");
                        this.put("xz.scorpio", "\u5929\u874e");
                        this.put("xz.sagittarius", "\u5c04\u624b");
                        this.put("xz.capricornus", "\u6469\u7faf");
                        this.put("xz.aquarius", "\u6c34\u74f6");
                        this.put("xz.pisces", "\u53cc\u9c7c");
                        this.put("bg.qian", "\u4e7e");
                        this.put("bg.kun", "\u5764");
                        this.put("bg.zhen", "\u9707");
                        this.put("bg.xun", "\u5dfd");
                        this.put("bg.kan", "\u574e");
                        this.put("bg.li", "\u79bb");
                        this.put("bg.gen", "\u826e");
                        this.put("bg.dui", "\u5151");
                        this.put("ps.center", "\u4e2d");
                        this.put("ps.dong", "\u4e1c");
                        this.put("ps.nan", "\u5357");
                        this.put("ps.xi", "\u897f");
                        this.put("ps.bei", "\u5317");
                        this.put("ps.zhong", "\u4e2d\u5bab");
                        this.put("ps.zhengDong", "\u6b63\u4e1c");
                        this.put("ps.zhengNan", "\u6b63\u5357");
                        this.put("ps.zhengXi", "\u6b63\u897f");
                        this.put("ps.zhengBei", "\u6b63\u5317");
                        this.put("ps.dongBei", "\u4e1c\u5317");
                        this.put("ps.dongNan", "\u4e1c\u5357");
                        this.put("ps.xiBei", "\u897f\u5317");
                        this.put("ps.xiNan", "\u897f\u5357");
                        this.put("ps.wai", "\u5916");
                        this.put("ps.fangNei", "\u623f\u5185");
                        this.put("jq.dongZhi", "\u51ac\u81f3");
                        this.put("jq.xiaoHan", "\u5c0f\u5bd2");
                        this.put("jq.daHan", "\u5927\u5bd2");
                        this.put("jq.liChun", "\u7acb\u6625");
                        this.put("jq.yuShui", "\u96e8\u6c34");
                        this.put("jq.jingZhe", "\u60ca\u86f0");
                        this.put("jq.chunFen", "\u6625\u5206");
                        this.put("jq.qingMing", "\u6e05\u660e");
                        this.put("jq.guYu", "\u8c37\u96e8");
                        this.put("jq.liXia", "\u7acb\u590f");
                        this.put("jq.xiaoMan", "\u5c0f\u6ee1");
                        this.put("jq.mangZhong", "\u8292\u79cd");
                        this.put("jq.xiaZhi", "\u590f\u81f3");
                        this.put("jq.xiaoShu", "\u5c0f\u6691");
                        this.put("jq.daShu", "\u5927\u6691");
                        this.put("jq.liQiu", "\u7acb\u79cb");
                        this.put("jq.chuShu", "\u5904\u6691");
                        this.put("jq.baiLu", "\u767d\u9732");
                        this.put("jq.qiuFen", "\u79cb\u5206");
                        this.put("jq.hanLu", "\u5bd2\u9732");
                        this.put("jq.shuangJiang", "\u971c\u964d");
                        this.put("jq.liDong", "\u7acb\u51ac");
                        this.put("jq.xiaoXue", "\u5c0f\u96ea");
                        this.put("jq.daXue", "\u5927\u96ea");
                        this.put("sn.qingLong", "\u9752\u9f99");
                        this.put("sn.baiHu", "\u767d\u864e");
                        this.put("sn.zhuQue", "\u6731\u96c0");
                        this.put("sn.xuanWu", "\u7384\u6b66");
                        this.put("sn.mingTang", "\u660e\u5802");
                        this.put("sn.tianXing", "\u5929\u5211");
                        this.put("sn.tianDe", "\u5929\u5fb7");
                        this.put("sn.jinKui", "\u91d1\u532e");
                        this.put("sn.yuTang", "\u7389\u5802");
                        this.put("sn.siMing", "\u53f8\u547d");
                        this.put("sn.tianLao", "\u5929\u7262");
                        this.put("sn.gouChen", "\u52fe\u9648");
                        this.put("sn.tianEn", "\u5929\u6069");
                        this.put("sn.muCang", "\u6bcd\u4ed3");
                        this.put("sn.shiYang", "\u65f6\u9633");
                        this.put("sn.shengQi", "\u751f\u6c14");
                        this.put("sn.yiHou", "\u76ca\u540e");
                        this.put("sn.zaiSha", "\u707e\u715e");
                        this.put("sn.tianHuo", "\u5929\u706b");
                        this.put("sn.siJi", "\u56db\u5fcc");
                        this.put("sn.baLong", "\u516b\u9f99");
                        this.put("sn.fuRi", "\u590d\u65e5");
                        this.put("sn.xuShi", "\u7eed\u4e16");
                        this.put("sn.yueSha", "\u6708\u715e");
                        this.put("sn.yueXu", "\u6708\u865a");
                        this.put("sn.xueZhi", "\u8840\u652f");
                        this.put("sn.tianZei", "\u5929\u8d3c");
                        this.put("sn.wuXu", "\u4e94\u865a");
                        this.put("sn.tuFu", "\u571f\u7b26");
                        this.put("sn.guiJi", "\u5f52\u5fcc");
                        this.put("sn.xueJi", "\u8840\u5fcc");
                        this.put("sn.yueDe", "\u6708\u5fb7");
                        this.put("sn.yueEn", "\u6708\u6069");
                        this.put("sn.siXiang", "\u56db\u76f8");
                        this.put("sn.wangRi", "\u738b\u65e5");
                        this.put("sn.tianCang", "\u5929\u4ed3");
                        this.put("sn.buJiang", "\u4e0d\u5c06");
                        this.put("sn.wuHe", "\u4e94\u5408");
                        this.put("sn.mingFeiDui", "\u9e23\u5420\u5bf9");
                        this.put("sn.yueJian", "\u6708\u5efa");
                        this.put("sn.xiaoShi", "\u5c0f\u65f6");
                        this.put("sn.tuHu", "\u571f\u5e9c");
                        this.put("sn.wangWang", "\u5f80\u4ea1");
                        this.put("sn.yaoAn", "\u8981\u5b89");
                        this.put("sn.siShen", "\u6b7b\u795e");
                        this.put("sn.tianMa", "\u5929\u9a6c");
                        this.put("sn.jiuHu", "\u4e5d\u864e");
                        this.put("sn.qiNiao", "\u4e03\u9e1f");
                        this.put("sn.liuShe", "\u516d\u86c7");
                        this.put("sn.guanRi", "\u5b98\u65e5");
                        this.put("sn.jiQi", "\u5409\u671f");
                        this.put("sn.yuYu", "\u7389\u5b87");
                        this.put("sn.daShi", "\u5927\u65f6");
                        this.put("sn.daBai", "\u5927\u8d25");
                        this.put("sn.xianChi", "\u54b8\u6c60");
                        this.put("sn.shouRi", "\u5b88\u65e5");
                        this.put("sn.tianWu", "\u5929\u5deb");
                        this.put("sn.fuDe", "\u798f\u5fb7");
                        this.put("sn.liuYi", "\u516d\u4eea");
                        this.put("sn.jinTang", "\u91d1\u5802");
                        this.put("sn.yanDui", "\u538c\u5bf9");
                        this.put("sn.zhaoYao", "\u62db\u6447");
                        this.put("sn.jiuKong", "\u4e5d\u7a7a");
                        this.put("sn.jiuKan", "\u4e5d\u574e");
                        this.put("sn.jiuJiao", "\u4e5d\u7126");
                        this.put("sn.xiangRi", "\u76f8\u65e5");
                        this.put("sn.baoGuang", "\u5b9d\u5149");
                        this.put("sn.tianGang", "\u5929\u7f61");
                        this.put("sn.yueXing", "\u6708\u5211");
                        this.put("sn.yueHai", "\u6708\u5bb3");
                        this.put("sn.youHuo", "\u6e38\u7978");
                        this.put("sn.chongRi", "\u91cd\u65e5");
                        this.put("sn.shiDe", "\u65f6\u5fb7");
                        this.put("sn.minRi", "\u6c11\u65e5");
                        this.put("sn.sanHe", "\u4e09\u5408");
                        this.put("sn.linRi", "\u4e34\u65e5");
                        this.put("sn.shiYin", "\u65f6\u9634");
                        this.put("sn.mingFei", "\u9e23\u5420");
                        this.put("sn.siQi", "\u6b7b\u6c14");
                        this.put("sn.diNang", "\u5730\u56ca");
                        this.put("sn.yueDeHe", "\u6708\u5fb7\u5408");
                        this.put("sn.jingAn", "\u656c\u5b89");
                        this.put("sn.puHu", "\u666e\u62a4");
                        this.put("sn.jieShen", "\u89e3\u795e");
                        this.put("sn.xiaoHao", "\u5c0f\u8017");
                        this.put("sn.tianDeHe", "\u5929\u5fb7\u5408");
                        this.put("sn.yueKong", "\u6708\u7a7a");
                        this.put("sn.yiMa", "\u9a7f\u9a6c");
                        this.put("sn.tianHou", "\u5929\u540e");
                        this.put("sn.chuShen", "\u9664\u795e");
                        this.put("sn.yuePo", "\u6708\u7834");
                        this.put("sn.daHao", "\u5927\u8017");
                        this.put("sn.wuLi", "\u4e94\u79bb");
                        this.put("sn.yinDe", "\u9634\u5fb7");
                        this.put("sn.fuSheng", "\u798f\u751f");
                        this.put("sn.tianLi", "\u5929\u540f");
                        this.put("sn.zhiSi", "\u81f4\u6b7b");
                        this.put("sn.yuanWu", "\u5143\u6b66");
                        this.put("sn.yangDe", "\u9633\u5fb7");
                        this.put("sn.tianXi", "\u5929\u559c");
                        this.put("sn.tianYi", "\u5929\u533b");
                        this.put("sn.yueYan", "\u6708\u538c");
                        this.put("sn.diHuo", "\u5730\u706b");
                        this.put("sn.fourHit", "\u56db\u51fb");
                        this.put("sn.daSha", "\u5927\u715e");
                        this.put("sn.daHui", "\u5927\u4f1a");
                        this.put("sn.tianYuan", "\u5929\u613f");
                        this.put("sn.liuHe", "\u516d\u5408");
                        this.put("sn.wuFu", "\u4e94\u5bcc");
                        this.put("sn.shengXin", "\u5723\u5fc3");
                        this.put("sn.heKui", "\u6cb3\u9b41");
                        this.put("sn.jieSha", "\u52ab\u715e");
                        this.put("sn.siQiong", "\u56db\u7a77");
                        this.put("sn.chuShuiLong", "\u89e6\u6c34\u9f99");
                        this.put("sn.baFeng", "\u516b\u98ce");
                        this.put("sn.tianShe", "\u5929\u8d66");
                        this.put("sn.wuMu", "\u4e94\u5893");
                        this.put("sn.baZhuan", "\u516b\u4e13");
                        this.put("sn.yinCuo", "\u9634\u9519");
                        this.put("sn.siHao", "\u56db\u8017");
                        this.put("sn.yangCuo", "\u9633\u9519");
                        this.put("sn.siFei", "\u56db\u5e9f");
                        this.put("sn.sanYin", "\u4e09\u9634");
                        this.put("sn.xiaoHui", "\u5c0f\u4f1a");
                        this.put("sn.yinDaoChongYang", "\u9634\u9053\u51b2\u9633");
                        this.put("sn.danYin", "\u5355\u9634");
                        this.put("sn.guChen", "\u5b64\u8fb0");
                        this.put("sn.yinWei", "\u9634\u4f4d");
                        this.put("sn.xingHen", "\u884c\u72e0");
                        this.put("sn.liaoLi", "\u4e86\u623e");
                        this.put("sn.jueYin", "\u7edd\u9634");
                        this.put("sn.chunYang", "\u7eaf\u9633");
                        this.put("sn.suiBo", "\u5c81\u8584");
                        this.put("sn.yinYangJiaoPo", "\u9634\u9633\u4ea4\u7834");
                        this.put("sn.yinYangJuCuo", "\u9634\u9633\u4ff1\u9519");
                        this.put("sn.yinYangJiChong", "\u9634\u9633\u51fb\u51b2");
                        this.put("sn.zhuZhen", "\u9010\u9635");
                        this.put("sn.yangCuoYinChong", "\u9633\u9519\u9634\u51b2");
                        this.put("sn.qiFu", "\u4e03\u7b26");
                        this.put("sn.tianGou", "\u5929\u72d7");
                        this.put("sn.chengRi", "\u6210\u65e5");
                        this.put("sn.tianFu", "\u5929\u7b26");
                        this.put("sn.guYang", "\u5b64\u9633");
                        this.put("sn.jueYang", "\u7edd\u9633");
                        this.put("sn.chunYin", "\u7eaf\u9634");
                        this.put("sn.yinShen", "\u9634\u795e");
                        this.put("sn.jieChu", "\u89e3\u9664");
                        this.put("sn.yangPoYinChong", "\u9633\u7834\u9634\u51b2");
                        this.put("ss.biJian", "\u6bd4\u80a9");
                        this.put("ss.jieCai", "\u52ab\u8d22");
                        this.put("ss.shiShen", "\u98df\u795e");
                        this.put("ss.shangGuan", "\u4f24\u5b98");
                        this.put("ss.pianCai", "\u504f\u8d22");
                        this.put("ss.zhengCai", "\u6b63\u8d22");
                        this.put("ss.qiSha", "\u4e03\u6740");
                        this.put("ss.zhengGuan", "\u6b63\u5b98");
                        this.put("ss.pianYin", "\u504f\u5370");
                        this.put("ss.zhengYin", "\u6b63\u5370");
                        this.put("s.none", "\u65e0");
                        this.put("s.huangDao", "\u9ec4\u9053");
                        this.put("s.heiDao", "\u9ed1\u9053");
                        this.put("s.goodLuck", "\u5409");
                        this.put("s.badLuck", "\u51f6");
                        this.put("s.yin", "\u9634");
                        this.put("s.yang", "\u9633");
                        this.put("s.white", "\u767d");
                        this.put("s.black", "\u9ed1");
                        this.put("s.blue", "\u78a7");
                        this.put("s.green", "\u7eff");
                        this.put("s.yellow", "\u9ec4");
                        this.put("s.red", "\u8d64");
                        this.put("s.purple", "\u7d2b");
                        this.put("jr.chuXi", "\u9664\u5915");
                        this.put("jr.chunJie", "\u6625\u8282");
                        this.put("jr.yuanXiao", "\u5143\u5bb5\u8282");
                        this.put("jr.longTou", "\u9f99\u5934\u8282");
                        this.put("jr.duanWu", "\u7aef\u5348\u8282");
                        this.put("jr.qiXi", "\u4e03\u5915\u8282");
                        this.put("jr.zhongQiu", "\u4e2d\u79cb\u8282");
                        this.put("jr.chongYang", "\u91cd\u9633\u8282");
                        this.put("jr.laBa", "\u814a\u516b\u8282");
                        this.put("jr.yuanDan", "\u5143\u65e6\u8282");
                        this.put("jr.qingRen", "\u60c5\u4eba\u8282");
                        this.put("jr.fuNv", "\u5987\u5973\u8282");
                        this.put("jr.zhiShu", "\u690d\u6811\u8282");
                        this.put("jr.xiaoFei", "\u6d88\u8d39\u8005\u6743\u76ca\u65e5");
                        this.put("jr.wuYi", "\u52b3\u52a8\u8282");
                        this.put("jr.qingNian", "\u9752\u5e74\u8282");
                        this.put("jr.erTong", "\u513f\u7ae5\u8282");
                        this.put("jr.yuRen", "\u611a\u4eba\u8282");
                        this.put("jr.jianDang", "\u5efa\u515a\u8282");
                        this.put("jr.jianJun", "\u5efa\u519b\u8282");
                        this.put("jr.jiaoShi", "\u6559\u5e08\u8282");
                        this.put("jr.guoQing", "\u56fd\u5e86\u8282");
                        this.put("jr.wanShengYe", "\u4e07\u5723\u8282\u524d\u591c");
                        this.put("jr.wanSheng", "\u4e07\u5723\u8282");
                        this.put("jr.pingAn", "\u5e73\u5b89\u591c");
                        this.put("jr.shengDan", "\u5723\u8bde\u8282");
                        this.put("ds.changSheng", "\u957f\u751f");
                        this.put("ds.muYu", "\u6c90\u6d74");
                        this.put("ds.guanDai", "\u51a0\u5e26");
                        this.put("ds.linGuan", "\u4e34\u5b98");
                        this.put("ds.diWang", "\u5e1d\u65fa");
                        this.put("ds.shuai", "\u8870");
                        this.put("ds.bing", "\u75c5");
                        this.put("ds.si", "\u6b7b");
                        this.put("ds.mu", "\u5893");
                        this.put("ds.jue", "\u7edd");
                        this.put("ds.tai", "\u80ce");
                        this.put("ds.yang", "\u517b");
                        this.put("h.first", "\u521d\u5019");
                        this.put("h.second", "\u4e8c\u5019");
                        this.put("h.third", "\u4e09\u5019");
                        this.put("h.qiuYinJie", "\u86af\u8693\u7ed3");
                        this.put("h.miJiao", "\u9e8b\u89d2\u89e3");
                        this.put("h.shuiQuan", "\u6c34\u6cc9\u52a8");
                        this.put("h.yanBei", "\u96c1\u5317\u4e61");
                        this.put("h.queShi", "\u9e4a\u59cb\u5de2");
                        this.put("h.zhiShi", "\u96c9\u59cb\u96ca");
                        this.put("h.jiShi", "\u9e21\u59cb\u4e73");
                        this.put("h.zhengNiao", "\u5f81\u9e1f\u5389\u75be");
                        this.put("h.shuiZe", "\u6c34\u6cfd\u8179\u575a");
                        this.put("h.dongFeng", "\u4e1c\u98ce\u89e3\u51bb");
                        this.put("h.zheChongShiZhen", "\u86f0\u866b\u59cb\u632f");
                        this.put("h.yuZhi", "\u9c7c\u965f\u8d1f\u51b0");
                        this.put("h.taJi", "\u736d\u796d\u9c7c");
                        this.put("h.houYan", "\u5019\u96c1\u5317");
                        this.put("h.caoMuMengDong", "\u8349\u6728\u840c\u52a8");
                        this.put("h.taoShi", "\u6843\u59cb\u534e");
                        this.put("h.cangGeng", "\u4ed3\u5e9a\u9e23");
                        this.put("h.yingHua", "\u9e70\u5316\u4e3a\u9e20");
                        this.put("h.xuanNiaoZhi", "\u7384\u9e1f\u81f3");
                        this.put("h.leiNai", "\u96f7\u4e43\u53d1\u58f0");
                        this.put("h.shiDian", "\u59cb\u7535");
                        this.put("h.tongShi", "\u6850\u59cb\u534e");
                        this.put("h.tianShu", "\u7530\u9f20\u5316\u4e3a\u9d3d");
                        this.put("h.hongShi", "\u8679\u59cb\u89c1");
                        this.put("h.pingShi", "\u840d\u59cb\u751f");
                        this.put("h.mingJiu", "\u9e23\u9e20\u62c2\u5947\u7fbd");
                        this.put("h.daiSheng", "\u6234\u80dc\u964d\u4e8e\u6851");
                        this.put("h.louGuo", "\u877c\u8748\u9e23");
                        this.put("h.qiuYinChu", "\u86af\u8693\u51fa");
                        this.put("h.wangGua", "\u738b\u74dc\u751f");
                        this.put("h.kuCai", "\u82e6\u83dc\u79c0");
                        this.put("h.miCao", "\u9761\u8349\u6b7b");
                        this.put("h.maiQiu", "\u9ea6\u79cb\u81f3");
                        this.put("h.tangLang", "\u87b3\u8782\u751f");
                        this.put("h.juShi", "\u9d59\u59cb\u9e23");
                        this.put("h.fanShe", "\u53cd\u820c\u65e0\u58f0");
                        this.put("h.luJia", "\u9e7f\u89d2\u89e3");
                        this.put("h.tiaoShi", "\u8729\u59cb\u9e23");
                        this.put("h.banXia", "\u534a\u590f\u751f");
                        this.put("h.wenFeng", "\u6e29\u98ce\u81f3");
                        this.put("h.xiShuai", "\u87cb\u87c0\u5c45\u58c1");
                        this.put("h.yingShi", "\u9e70\u59cb\u631a");
                        this.put("h.fuCao", "\u8150\u8349\u4e3a\u8424");
                        this.put("h.tuRun", "\u571f\u6da6\u6ebd\u6691");
                        this.put("h.daYu", "\u5927\u96e8\u884c\u65f6");
                        this.put("h.liangFeng", "\u51c9\u98ce\u81f3");
                        this.put("h.baiLu", "\u767d\u9732\u964d");
                        this.put("h.hanChan", "\u5bd2\u8749\u9e23");
                        this.put("h.yingNai", "\u9e70\u4e43\u796d\u9e1f");
                        this.put("h.tianDi", "\u5929\u5730\u59cb\u8083");
                        this.put("h.heNai", "\u79be\u4e43\u767b");
                        this.put("h.hongYanLai", "\u9e3f\u96c1\u6765");
                        this.put("h.xuanNiaoGui", "\u7384\u9e1f\u5f52");
                        this.put("h.qunNiao", "\u7fa4\u9e1f\u517b\u7f9e");
                        this.put("h.leiShi", "\u96f7\u59cb\u6536\u58f0");
                        this.put("h.zheChongPiHu", "\u86f0\u866b\u576f\u6237");
                        this.put("h.shuiShiHe", "\u6c34\u59cb\u6db8");
                        this.put("h.hongYanLaiBin", "\u9e3f\u96c1\u6765\u5bbe");
                        this.put("h.queRu", "\u96c0\u5165\u5927\u6c34\u4e3a\u86e4");
                        this.put("h.juYou", "\u83ca\u6709\u9ec4\u82b1");
                        this.put("h.caiNai", "\u8c7a\u4e43\u796d\u517d");
                        this.put("h.caoMuHuangLuo", "\u8349\u6728\u9ec4\u843d");
                        this.put("h.zheChongXianFu", "\u86f0\u866b\u54b8\u4fef");
                        this.put("h.shuiShiBing", "\u6c34\u59cb\u51b0");
                        this.put("h.diShi", "\u5730\u59cb\u51bb");
                        this.put("h.zhiRu", "\u96c9\u5165\u5927\u6c34\u4e3a\u8703");
                        this.put("h.hongCang", "\u8679\u85cf\u4e0d\u89c1");
                        this.put("h.tianQi", "\u5929\u6c14\u4e0a\u5347\u5730\u6c14\u4e0b\u964d");
                        this.put("h.biSe", "\u95ed\u585e\u800c\u6210\u51ac");
                        this.put("h.heDan", "\u9e56\u9d20\u4e0d\u9e23");
                        this.put("h.huShi", "\u864e\u59cb\u4ea4");
                        this.put("h.liTing", "\u8354\u633a\u51fa");
                        this.put("ts.zhan", "\u5360");
                        this.put("ts.hu", "\u6237");
                        this.put("ts.win", "\u7a97");
                        this.put("ts.fang", "\u623f");
                        this.put("ts.chuang", "\u5e8a");
                        this.put("ts.lu", "\u7089");
                        this.put("ts.zao", "\u7076");
                        this.put("ts.dui", "\u7893");
                        this.put("ts.mo", "\u78e8");
                        this.put("ts.xi", "\u6816");
                        this.put("ts.chu", "\u53a8");
                        this.put("ts.ce", "\u5395");
                        this.put("ts.cang", "\u4ed3");
                        this.put("ts.cangKu", "\u4ed3\u5e93");
                        this.put("ts.daMen", "\u5927\u95e8");
                        this.put("ts.men", "\u95e8");
                        this.put("ts.tang", "\u5802");
                        this.put("ly.xianSheng", "\u5148\u80dc");
                        this.put("ly.xianFu", "\u5148\u8d1f");
                        this.put("ly.youYin", "\u53cb\u5f15");
                        this.put("ly.foMie", "\u4f5b\u706d");
                        this.put("ly.daAn", "\u5927\u5b89");
                        this.put("ly.chiKou", "\u8d64\u53e3");
                        this.put("yj.jiSi", "\u796d\u7940");
                        this.put("yj.qiFu", "\u7948\u798f");
                        this.put("yj.qiuSi", "\u6c42\u55e3");
                        this.put("yj.kaiGuang", "\u5f00\u5149");
                        this.put("yj.suHui", "\u5851\u7ed8");
                        this.put("yj.qiJiao", "\u9f50\u91ae");
                        this.put("yj.zhaiJiao", "\u658b\u91ae");
                        this.put("yj.muYu", "\u6c90\u6d74");
                        this.put("yj.chouShen", "\u916c\u795e");
                        this.put("yj.zaoMiao", "\u9020\u5e99");
                        this.put("yj.siZhao", "\u7940\u7076");
                        this.put("yj.fenXiang", "\u711a\u9999");
                        this.put("yj.xieTu", "\u8c22\u571f");
                        this.put("yj.chuHuo", "\u51fa\u706b");
                        this.put("yj.diaoKe", "\u96d5\u523b");
                        this.put("yj.jiaQu", "\u5ac1\u5a36");
                        this.put("yj.DingHun", "\u8ba2\u5a5a");
                        this.put("yj.naCai", "\u7eb3\u91c7");
                        this.put("yj.wenMing", "\u95ee\u540d");
                        this.put("yj.naXu", "\u7eb3\u5a7f");
                        this.put("yj.guiNing", "\u5f52\u5b81");
                        this.put("yj.anChuang", "\u5b89\u5e8a");
                        this.put("yj.heZhang", "\u5408\u5e10");
                        this.put("yj.guanJi", "\u51a0\u7b04");
                        this.put("yj.dingMeng", "\u8ba2\u76df");
                        this.put("yj.jinRenKou", "\u8fdb\u4eba\u53e3");
                        this.put("yj.caiYi", "\u88c1\u8863");
                        this.put("yj.wanMian", "\u633d\u9762");
                        this.put("yj.kaiRong", "\u5f00\u5bb9");
                        this.put("yj.xiuFen", "\u4fee\u575f");
                        this.put("yj.qiZuan", "\u542f\u94bb");
                        this.put("yj.poTu", "\u7834\u571f");
                        this.put("yj.anZang", "\u5b89\u846c");
                        this.put("yj.liBei", "\u7acb\u7891");
                        this.put("yj.chengFu", "\u6210\u670d");
                        this.put("yj.chuFu", "\u9664\u670d");
                        this.put("yj.kaiShengFen", "\u5f00\u751f\u575f");
                        this.put("yj.heShouMu", "\u5408\u5bff\u6728");
                        this.put("yj.ruLian", "\u5165\u6b93");
                        this.put("yj.yiJiu", "\u79fb\u67e9");
                        this.put("yj.puDu", "\u666e\u6e21");
                        this.put("yj.ruZhai", "\u5165\u5b85");
                        this.put("yj.anXiang", "\u5b89\u9999");
                        this.put("yj.anMen", "\u5b89\u95e8");
                        this.put("yj.xiuZao", "\u4fee\u9020");
                        this.put("yj.qiJi", "\u8d77\u57fa");
                        this.put("yj.dongTu", "\u52a8\u571f");
                        this.put("yj.shangLiang", "\u4e0a\u6881");
                        this.put("yj.shuZhu", "\u7ad6\u67f1");
                        this.put("yj.kaiJing", "\u5f00\u4e95\u5f00\u6c60");
                        this.put("yj.zuoBei", "\u4f5c\u9642\u653e\u6c34");
                        this.put("yj.chaiXie", "\u62c6\u5378");
                        this.put("yj.poWu", "\u7834\u5c4b");
                        this.put("yj.huaiYuan", "\u574f\u57a3");
                        this.put("yj.buYuan", "\u8865\u57a3");
                        this.put("yj.faMuZuoLiang", "\u4f10\u6728\u505a\u6881");
                        this.put("yj.zuoZhao", "\u4f5c\u7076");
                        this.put("yj.jieChu", "\u89e3\u9664");
                        this.put("yj.kaiZhuYan", "\u5f00\u67f1\u773c");
                        this.put("yj.chuanPing", "\u7a7f\u5c4f\u6247\u67b6");
                        this.put("yj.gaiWuHeJi", "\u76d6\u5c4b\u5408\u810a");
                        this.put("yj.kaiCe", "\u5f00\u5395");
                        this.put("yj.zaoCang", "\u9020\u4ed3");
                        this.put("yj.saiXue", "\u585e\u7a74");
                        this.put("yj.pingZhi", "\u5e73\u6cbb\u9053\u6d82");
                        this.put("yj.zaoQiao", "\u9020\u6865");
                        this.put("yj.zuoCe", "\u4f5c\u5395");
                        this.put("yj.zhuDi", "\u7b51\u5824");
                        this.put("yj.kaiChi", "\u5f00\u6c60");
                        this.put("yj.faMu", "\u4f10\u6728");
                        this.put("yj.kaiQu", "\u5f00\u6e20");
                        this.put("yj.jueJing", "\u6398\u4e95");
                        this.put("yj.saoShe", "\u626b\u820d");
                        this.put("yj.fangShui", "\u653e\u6c34");
                        this.put("yj.zaoWu", "\u9020\u5c4b");
                        this.put("yj.heJi", "\u5408\u810a");
                        this.put("yj.zaoChuChou", "\u9020\u755c\u7a20");
                        this.put("yj.xiuMen", "\u4fee\u95e8");
                        this.put("yj.dingSang", "\u5b9a\u78c9");
                        this.put("yj.zuoLiang", "\u4f5c\u6881");
                        this.put("yj.xiuShi", "\u4fee\u9970\u57a3\u5899");
                        this.put("yj.jiaMa", "\u67b6\u9a6c");
                        this.put("yj.kaiShi", "\u5f00\u5e02");
                        this.put("yj.guaBian", "\u6302\u533e");
                        this.put("yj.naChai", "\u7eb3\u8d22");
                        this.put("yj.qiuCai", "\u6c42\u8d22");
                        this.put("yj.kaiCang", "\u5f00\u4ed3");
                        this.put("yj.maiChe", "\u4e70\u8f66");
                        this.put("yj.zhiChan", "\u7f6e\u4ea7");
                        this.put("yj.guYong", "\u96c7\u5eb8");
                        this.put("yj.chuHuoCai", "\u51fa\u8d27\u8d22");
                        this.put("yj.anJiXie", "\u5b89\u673a\u68b0");
                        this.put("yj.zaoCheQi", "\u9020\u8f66\u5668");
                        this.put("yj.jingLuo", "\u7ecf\u7edc");
                        this.put("yj.yunNiang", "\u915d\u917f");
                        this.put("yj.zuoRan", "\u4f5c\u67d3");
                        this.put("yj.guZhu", "\u9f13\u94f8");
                        this.put("yj.zaoChuan", "\u9020\u8239");
                        this.put("yj.geMi", "\u5272\u871c");
                        this.put("yj.zaiZhong", "\u683d\u79cd");
                        this.put("yj.quYu", "\u53d6\u6e14");
                        this.put("yj.jieWang", "\u7ed3\u7f51");
                        this.put("yj.muYang", "\u7267\u517b");
                        this.put("yj.anDuiWei", "\u5b89\u7893\u78d1");
                        this.put("yj.xiYi", "\u4e60\u827a");
                        this.put("yj.ruXue", "\u5165\u5b66");
                        this.put("yj.liFa", "\u7406\u53d1");
                        this.put("yj.tanBing", "\u63a2\u75c5");
                        this.put("yj.jianGui", "\u89c1\u8d35");
                        this.put("yj.chengChuan", "\u4e58\u8239");
                        this.put("yj.duShui", "\u6e21\u6c34");
                        this.put("yj.zhenJiu", "\u9488\u7078");
                        this.put("yj.chuXing", "\u51fa\u884c");
                        this.put("yj.yiXi", "\u79fb\u5f99");
                        this.put("yj.fenJu", "\u5206\u5c45");
                        this.put("yj.TiTou", "\u5243\u5934");
                        this.put("yj.zhengShou", "\u6574\u624b\u8db3\u7532");
                        this.put("yj.naChu", "\u7eb3\u755c");
                        this.put("yj.buZhuo", "\u6355\u6349");
                        this.put("yj.tianLie", "\u754b\u730e");
                        this.put("yj.jiaoNiuMa", "\u6559\u725b\u9a6c");
                        this.put("yj.huiQinYou", "\u4f1a\u4eb2\u53cb");
                        this.put("yj.fuRen", "\u8d74\u4efb");
                        this.put("yj.qiuYi", "\u6c42\u533b");
                        this.put("yj.zhiBing", "\u6cbb\u75c5");
                        this.put("yj.ciSong", "\u8bcd\u8bbc");
                        this.put("yj.qiJiDongTu", "\u8d77\u57fa\u52a8\u571f");
                        this.put("yj.poWuHuaiYuan", "\u7834\u5c4b\u574f\u57a3");
                        this.put("yj.gaiWu", "\u76d6\u5c4b");
                        this.put("yj.zaoCangKu", "\u9020\u4ed3\u5e93");
                        this.put("yj.liQuanJiaoYi", "\u7acb\u5238\u4ea4\u6613");
                        this.put("yj.jiaoYi", "\u4ea4\u6613");
                        this.put("yj.liQuan", "\u7acb\u5238");
                        this.put("yj.anJi", "\u5b89\u673a");
                        this.put("yj.huiYou", "\u4f1a\u53cb");
                        this.put("yj.qiuYiLiaoBing", "\u6c42\u533b\u7597\u75c5");
                        this.put("yj.zhuShi", "\u8bf8\u4e8b\u4e0d\u5b9c");
                        this.put("yj.yuShi", "\u9980\u4e8b\u52ff\u53d6");
                        this.put("yj.xingSang", "\u884c\u4e27");
                        this.put("yj.duanYi", "\u65ad\u8681");
                        this.put("yj.guiXiu", "\u5f52\u5cab");
                        this.put("xx.bi", "\u6bd5");
                        this.put("xx.yi", "\u7ffc");
                        this.put("xx.ji", "\u7b95");
                        this.put("xx.kui", "\u594e");
                        this.put("xx.gui", "\u9b3c");
                        this.put("xx.di", "\u6c10");
                        this.put("xx.xu", "\u865a");
                        this.put("xx.wei", "\u5371");
                        this.put("xx.zi", "\u89dc");
                        this.put("xx.zhen", "\u8f78");
                        this.put("xx.dou", "\u6597");
                        this.put("xx.lou", "\u5a04");
                        this.put("xx.liu", "\u67f3");
                        this.put("xx.fang", "\u623f");
                        this.put("xx.xin", "\u5fc3");
                        this.put("xx.shi", "\u5ba4");
                        this.put("xx.can", "\u53c2");
                        this.put("xx.jiao", "\u89d2");
                        this.put("xx.niu", "\u725b");
                        this.put("xx.vei", "\u80c3");
                        this.put("xx.xing", "\u661f");
                        this.put("xx.zhang", "\u5f20");
                        this.put("xx.tail", "\u5c3e");
                        this.put("xx.qiang", "\u58c1");
                        this.put("xx.jing", "\u4e95");
                        this.put("xx.kang", "\u4ea2");
                        this.put("xx.nv", "\u5973");
                        this.put("xx.mao", "\u6634");
                        this.put("sz.chun", "\u6625");
                        this.put("sz.xia", "\u590f");
                        this.put("sz.qiu", "\u79cb");
                        this.put("sz.dong", "\u51ac");
                        this.put("od.first", "\u5b5f");
                        this.put("od.second", "\u4ef2");
                        this.put("od.third", "\u5b63");
                        this.put("yx.shuo", "\u6714");
                        this.put("yx.jiShuo", "\u65e2\u6714");
                        this.put("yx.eMeiXin", "\u86fe\u7709\u65b0");
                        this.put("yx.eMei", "\u86fe\u7709");
                        this.put("yx.xi", "\u5915");
                        this.put("yx.shangXian", "\u4e0a\u5f26");
                        this.put("yx.jiuYe", "\u4e5d\u591c");
                        this.put("yx.night", "\u5bb5");
                        this.put("yx.jianYingTu", "\u6e10\u76c8\u51f8");
                        this.put("yx.xiaoWang", "\u5c0f\u671b");
                        this.put("yx.wang", "\u671b");
                        this.put("yx.jiWang", "\u65e2\u671b");
                        this.put("yx.liDai", "\u7acb\u5f85");
                        this.put("yx.juDai", "\u5c45\u5f85");
                        this.put("yx.qinDai", "\u5bdd\u5f85");
                        this.put("yx.gengDai", "\u66f4\u5f85");
                        this.put("yx.jianKuiTu", "\u6e10\u4e8f\u51f8");
                        this.put("yx.xiaXian", "\u4e0b\u5f26");
                        this.put("yx.youMing", "\u6709\u660e");
                        this.put("yx.eMeiCan", "\u86fe\u7709\u6b8b");
                        this.put("yx.can", "\u6b8b");
                        this.put("yx.xiao", "\u6653");
                        this.put("yx.hui", "\u6666");
                        this.put("ny.sangZhe", "\u6851\u67d8");
                        this.put("ny.baiLa", "\u767d\u8721");
                        this.put("ny.yangLiu", "\u6768\u67f3");
                        this.put("ny.jinBo", "\u91d1\u7b94");
                        this.put("ny.haiZhong", "\u6d77\u4e2d");
                        this.put("ny.daHai", "\u5927\u6d77");
                        this.put("ny.shaZhong", "\u6c99\u4e2d");
                        this.put("ny.luZhong", "\u7089\u4e2d");
                        this.put("ny.shanXia", "\u5c71\u4e0b");
                        this.put("ny.daLin", "\u5927\u6797");
                        this.put("ny.pingDi", "\u5e73\u5730");
                        this.put("ny.luPang", "\u8def\u65c1");
                        this.put("ny.biShang", "\u58c1\u4e0a");
                        this.put("ny.jianFeng", "\u5251\u950b");
                        this.put("ny.shanTou", "\u5c71\u5934");
                        this.put("ny.fuDeng", "\u8986\u706f");
                        this.put("ny.jianXia", "\u6da7\u4e0b");
                        this.put("ny.tianHe", "\u5929\u6cb3");
                        this.put("ny.chengTou", "\u57ce\u5934");
                        this.put("ny.daYi", "\u5927\u9a7f");
                        this.put("ny.chaiChuan", "\u9497\u948f");
                        this.put("ny.quanZhong", "\u6cc9\u4e2d");
                        this.put("ny.daXi", "\u5927\u6eaa");
                        this.put("ny.wuShang", "\u5c4b\u4e0a");
                        this.put("ny.piLi", "\u9739\u96f3");
                        this.put("ny.tianShang", "\u5929\u4e0a");
                        this.put("ny.songBo", "\u677e\u67cf");
                        this.put("ny.shiLiu", "\u77f3\u69b4");
                        this.put("ny.changLiu", "\u957f\u6d41");
                    }
                });
                this.put("en", new HashMap<String, String>(){
                    {
                        this.put("tg.jia", "Jia");
                        this.put("tg.yi", "Yi");
                        this.put("tg.bing", "Bing");
                        this.put("tg.ding", "Ding");
                        this.put("tg.wu", "Wu");
                        this.put("tg.ji", "Ji");
                        this.put("tg.geng", "Geng");
                        this.put("tg.xin", "Xin");
                        this.put("tg.ren", "Ren");
                        this.put("tg.gui", "Gui");
                        this.put("dz.zi", "Zi");
                        this.put("dz.chou", "Chou");
                        this.put("dz.yin", "Yin");
                        this.put("dz.mao", "Mao");
                        this.put("dz.chen", "Chen");
                        this.put("dz.si", "Si");
                        this.put("dz.wu", "Wu");
                        this.put("dz.wei", "Wei");
                        this.put("dz.shen", "Shen");
                        this.put("dz.you", "You");
                        this.put("dz.xu", "Xu");
                        this.put("dz.hai", "Hai");
                        this.put("zx.jian", "Build");
                        this.put("zx.chu", "Remove");
                        this.put("zx.man", "Full");
                        this.put("zx.ping", "Flat");
                        this.put("zx.ding", "Stable");
                        this.put("zx.zhi", "Hold");
                        this.put("zx.po", "Break");
                        this.put("zx.wei", "Danger");
                        this.put("zx.cheng", "Complete");
                        this.put("zx.shou", "Collect");
                        this.put("zx.kai", "Open");
                        this.put("zx.bi", "Close");
                        this.put("jz.jiaZi", "JiaZi");
                        this.put("jz.yiChou", "YiChou");
                        this.put("jz.bingYin", "BingYin");
                        this.put("jz.dingMao", "DingMao");
                        this.put("jz.wuChen", "WuChen");
                        this.put("jz.jiSi", "JiSi");
                        this.put("jz.gengWu", "GengWu");
                        this.put("jz.xinWei", "XinWei");
                        this.put("jz.renShen", "RenShen");
                        this.put("jz.guiYou", "GuiYou");
                        this.put("jz.jiaXu", "JiaXu");
                        this.put("jz.yiHai", "YiHai");
                        this.put("jz.bingZi", "BingZi");
                        this.put("jz.dingChou", "DingChou");
                        this.put("jz.wuYin", "WuYin");
                        this.put("jz.jiMao", "JiMao");
                        this.put("jz.gengChen", "GengChen");
                        this.put("jz.xinSi", "XinSi");
                        this.put("jz.renWu", "RenWu");
                        this.put("jz.guiWei", "GuiWei");
                        this.put("jz.jiaShen", "JiaShen");
                        this.put("jz.yiYou", "YiYou");
                        this.put("jz.bingXu", "BingXu");
                        this.put("jz.dingHai", "DingHai");
                        this.put("jz.wuZi", "WuZi");
                        this.put("jz.jiChou", "JiChou");
                        this.put("jz.gengYin", "GengYin");
                        this.put("jz.xinMao", "XinMao");
                        this.put("jz.renChen", "RenChen");
                        this.put("jz.guiSi", "GuiSi");
                        this.put("jz.jiaWu", "JiaWu");
                        this.put("jz.yiWei", "YiWei");
                        this.put("jz.bingShen", "BingShen");
                        this.put("jz.dingYou", "DingYou");
                        this.put("jz.wuXu", "WuXu");
                        this.put("jz.jiHai", "JiHai");
                        this.put("jz.gengZi", "GengZi");
                        this.put("jz.xinChou", "XinChou");
                        this.put("jz.renYin", "RenYin");
                        this.put("jz.guiMao", "GuiMao");
                        this.put("jz.jiaChen", "JiaChen");
                        this.put("jz.yiSi", "YiSi");
                        this.put("jz.bingWu", "BingWu");
                        this.put("jz.dingWei", "DingWei");
                        this.put("jz.wuShen", "WuShen");
                        this.put("jz.jiYou", "JiYou");
                        this.put("jz.gengXu", "GengXu");
                        this.put("jz.xinHai", "XinHai");
                        this.put("jz.renZi", "RenZi");
                        this.put("jz.guiChou", "GuiChou");
                        this.put("jz.jiaYin", "JiaYin");
                        this.put("jz.yiMao", "YiMao");
                        this.put("jz.bingChen", "BingChen");
                        this.put("jz.dingSi", "DingSi");
                        this.put("jz.wuWu", "WuWu");
                        this.put("jz.jiWei", "JiWei");
                        this.put("jz.gengShen", "GengShen");
                        this.put("jz.xinYou", "XinYou");
                        this.put("jz.renXu", "RenXu");
                        this.put("jz.guiHai", "GuiHai");
                        this.put("sx.rat", "Rat");
                        this.put("sx.ox", "Ox");
                        this.put("sx.tiger", "Tiger");
                        this.put("sx.rabbit", "Rabbit");
                        this.put("sx.dragon", "Dragon");
                        this.put("sx.snake", "Snake");
                        this.put("sx.horse", "Horse");
                        this.put("sx.goat", "Goat");
                        this.put("sx.monkey", "Monkey");
                        this.put("sx.rooster", "Rooster");
                        this.put("sx.dog", "Dog");
                        this.put("sx.pig", "Pig");
                        this.put("dw.long", "Dragon");
                        this.put("dw.niu", "Ox");
                        this.put("dw.gou", "Dog");
                        this.put("dw.yang", "Goat");
                        this.put("dw.tu", "Rabbit");
                        this.put("dw.shu", "Rat");
                        this.put("dw.ji", "Rooster");
                        this.put("dw.ma", "Horse");
                        this.put("dw.hu", "Tiger");
                        this.put("dw.zhu", "Pig");
                        this.put("dw.hou", "Monkey");
                        this.put("dw.she", "Snake");
                        this.put("dw.huLi", "Fox");
                        this.put("dw.yan", "Swallow");
                        this.put("dw.bao", "Leopard");
                        this.put("dw.yuan", "Ape");
                        this.put("dw.yin", "Earthworm");
                        this.put("dw.lu", "Deer");
                        this.put("dw.wu", "Crow");
                        this.put("dw.lang", "Wolf");
                        this.put("dw.fu", "Bat");
                        this.put("wx.jin", "Metal");
                        this.put("wx.mu", "Wood");
                        this.put("wx.shui", "Water");
                        this.put("wx.huo", "Fire");
                        this.put("wx.tu", "Earth");
                        this.put("wx.ri", "Sun");
                        this.put("wx.yue", "Moon");
                        this.put("n.zero", "0");
                        this.put("n.one", "1");
                        this.put("n.two", "2");
                        this.put("n.three", "3");
                        this.put("n.four", "4");
                        this.put("n.five", "5");
                        this.put("n.six", "6");
                        this.put("n.seven", "7");
                        this.put("n.eight", "8");
                        this.put("n.nine", "9");
                        this.put("n.ten", "10");
                        this.put("n.eleven", "11");
                        this.put("n.twelve", "12");
                        this.put("w.sun", "Sunday");
                        this.put("w.mon", "Monday");
                        this.put("w.tues", "Tuesday");
                        this.put("w.wed", "Wednesday");
                        this.put("w.thur", "Thursday");
                        this.put("w.fri", "Friday");
                        this.put("w.sat", "Saturday");
                        this.put("xz.aries", "Aries");
                        this.put("xz.taurus", "Taurus");
                        this.put("xz.gemini", "Gemini");
                        this.put("xz.cancer", "Cancer");
                        this.put("xz.leo", "Leo");
                        this.put("xz.virgo", "Virgo");
                        this.put("xz.libra", "Libra");
                        this.put("xz.scorpio", "Scorpio");
                        this.put("xz.sagittarius", "Sagittarius");
                        this.put("xz.capricornus", "Capricornus");
                        this.put("xz.aquarius", "Aquarius");
                        this.put("xz.pisces", "Pisces");
                        this.put("bg.qian", "Qian");
                        this.put("bg.kun", "Kun");
                        this.put("bg.zhen", "Zhen");
                        this.put("bg.xun", "Xun");
                        this.put("bg.kan", "Kan");
                        this.put("bg.li", "Li");
                        this.put("bg.gen", "Gen");
                        this.put("bg.dui", "Dui");
                        this.put("ps.center", "Center");
                        this.put("ps.dong", "East");
                        this.put("ps.nan", "South");
                        this.put("ps.xi", "West");
                        this.put("ps.bei", "North");
                        this.put("ps.zhong", "Center");
                        this.put("ps.zhengDong", "East");
                        this.put("ps.zhengNan", "South");
                        this.put("ps.zhengXi", "West");
                        this.put("ps.zhengBei", "North");
                        this.put("ps.dongBei", "Northeast");
                        this.put("ps.dongNan", "Southeast");
                        this.put("ps.xiBei", "Northwest");
                        this.put("ps.xiNan", "Southwest");
                        this.put("jq.dongZhi", "Winter Solstice");
                        this.put("jq.xiaoHan", "Lesser Cold");
                        this.put("jq.daHan", "Great Cold");
                        this.put("jq.liChun", "Spring Beginning");
                        this.put("jq.yuShui", "Rain Water");
                        this.put("jq.jingZhe", "Awakening from Hibernation");
                        this.put("jq.chunFen", "Spring Equinox");
                        this.put("jq.qingMing", "Fresh Green");
                        this.put("jq.guYu", "Grain Rain");
                        this.put("jq.liXia", "Beginning of Summer");
                        this.put("jq.xiaoMan", "Lesser Fullness");
                        this.put("jq.mangZhong", "Grain in Ear");
                        this.put("jq.xiaZhi", "Summer Solstice");
                        this.put("jq.xiaoShu", "Lesser Heat");
                        this.put("jq.daShu", "Greater Heat");
                        this.put("jq.liQiu", "Beginning of Autumn");
                        this.put("jq.chuShu", "End of Heat");
                        this.put("jq.baiLu", "White Dew");
                        this.put("jq.qiuFen", "Autumnal Equinox");
                        this.put("jq.hanLu", "Cold Dew");
                        this.put("jq.shuangJiang", "First Frost");
                        this.put("jq.liDong", "Beginning of Winter");
                        this.put("jq.xiaoXue", "Light Snow");
                        this.put("jq.daXue", "Heavy Snow");
                        this.put("sn.qingLong", "Azure Dragon");
                        this.put("sn.baiHu", "White Tiger");
                        this.put("sn.zhuQue", "Rosefinch");
                        this.put("sn.xuanWu", "Black Tortoise");
                        this.put("sn.tianEn", "Serene Grace");
                        this.put("sn.siShen", "Death");
                        this.put("sn.tianMa", "Pegasus");
                        this.put("sn.baLong", "Eight Dragon");
                        this.put("sn.jiuHu", "Nine Tiger");
                        this.put("sn.qiNiao", "Seven Bird");
                        this.put("sn.liuShe", "Six Snake");
                        this.put("s.none", "None");
                        this.put("s.goodLuck", "Good luck");
                        this.put("s.badLuck", "Bad luck");
                        this.put("s.yin", "Yin");
                        this.put("s.yang", "Yang");
                        this.put("s.white", "White");
                        this.put("s.black", "Black");
                        this.put("s.blue", "Blue");
                        this.put("s.green", "Green");
                        this.put("s.yellow", "Yellow");
                        this.put("s.red", "Red");
                        this.put("s.purple", "Purple");
                        this.put("jr.chuXi", "Chinese New Year's Eve");
                        this.put("jr.chunJie", "Luna New Year");
                        this.put("jr.yuanXiao", "Lantern Festival");
                        this.put("jr.duanWu", "Dragon Boat Festival");
                        this.put("jr.qiXi", "Begging Festival");
                        this.put("jr.zhongQiu", "Mid-Autumn Festival");
                        this.put("jr.laBa", "Laba Festival");
                        this.put("jr.yuanDan", "New Year's Day");
                        this.put("jr.qingRen", "Valentine's Day");
                        this.put("jr.fuNv", "Women's Day");
                        this.put("jr.xiaoFei", "Consumer Rights Day");
                        this.put("jr.zhiShu", "Arbor Day");
                        this.put("jr.wuYi", "International Worker's Day");
                        this.put("jr.erTong", "Children's Day");
                        this.put("jr.qingNian", "Youth Day");
                        this.put("jr.yuRen", "April Fools' Day");
                        this.put("jr.jianDang", "Party's Day");
                        this.put("jr.jianJun", "Army Day");
                        this.put("jr.jiaoShi", "Teachers' Day");
                        this.put("jr.guoQing", "National Day");
                        this.put("jr.wanShengYe", "All Saints' Eve");
                        this.put("jr.wanSheng", "All Saints' Day");
                        this.put("jr.pingAn", "Christmas Eve");
                        this.put("jr.shengDan", "Christmas Day");
                        this.put("ts.zhan", "At");
                        this.put("ts.hu", "Household");
                        this.put("ts.zao", "Cooker");
                        this.put("ts.dui", "Pestle");
                        this.put("ts.xi", "Habitat");
                        this.put("ts.win", "Window");
                        this.put("ts.fang", "Room");
                        this.put("ts.chuang", "Bed");
                        this.put("ts.lu", "Stove");
                        this.put("ts.mo", "Mill");
                        this.put("ts.chu", "Kitchen");
                        this.put("ts.ce", "Toilet");
                        this.put("ts.cang", "Depot");
                        this.put("ts.cangKu", "Depot");
                        this.put("ts.daMen", "Gate");
                        this.put("ts.men", "Door");
                        this.put("ts.tang", "Hall");
                        this.put("ly.xianSheng", "Win first");
                        this.put("ly.xianFu", "Lose first");
                        this.put("ly.youYin", "Friend's referral");
                        this.put("ly.foMie", "Buddhism's demise");
                        this.put("ly.daAn", "Great safety");
                        this.put("ly.chiKou", "Chikagoro");
                        this.put("yj.jiSi", "Sacrifice");
                        this.put("yj.qiFu", "Pray");
                        this.put("yj.qiuSi", "Seek heirs");
                        this.put("yj.kaiGuang", "Consecretion");
                        this.put("yj.suHui", "Paint sculptural");
                        this.put("yj.qiJiao", "Build altar");
                        this.put("yj.zhaiJiao", "Taoist rites");
                        this.put("yj.muYu", "Bathing");
                        this.put("yj.chouShen", "Reward gods");
                        this.put("yj.zaoMiao", "Build temple");
                        this.put("yj.siZhao", "Offer kitchen god");
                        this.put("yj.fenXiang", "Burn incense");
                        this.put("yj.xieTu", "Earth gratitude");
                        this.put("yj.chuHuo", "Expel the flame");
                        this.put("yj.diaoKe", "Carving");
                        this.put("yj.jiaQu", "Marriage");
                        this.put("yj.DingHun", "Engagement");
                        this.put("yj.naCai", "Proposing");
                        this.put("yj.wenMing", "Ask name");
                        this.put("yj.naXu", "Uxorilocal marriage");
                        this.put("yj.guiNing", "Visit parents");
                        this.put("yj.anChuang", "Bed placing");
                        this.put("yj.heZhang", "Make up accounts");
                        this.put("yj.guanJi", "Crowning adulthood");
                        this.put("yj.dingMeng", "Make alliance");
                        this.put("yj.jinRenKou", "Adopt");
                        this.put("yj.caiYi", "Dressmaking");
                        this.put("yj.wanMian", "Cosmeticsurgery");
                        this.put("yj.kaiRong", "Open face");
                        this.put("yj.xiuFen", "Grave repair");
                        this.put("yj.qiZuan", "Open coffin");
                        this.put("yj.poTu", "Break earth");
                        this.put("yj.anZang", "Burial");
                        this.put("yj.liBei", "Tombstone erecting");
                        this.put("yj.chengFu", "Formation of clothes");
                        this.put("yj.chuFu", "Mourning clothes removal");
                        this.put("yj.kaiShengFen", "Open grave");
                        this.put("yj.heShouMu", "Make coffin");
                        this.put("yj.ruLian", "Body placing");
                        this.put("yj.yiJiu", "Move coffin");
                        this.put("yj.puDu", "Save soul");
                        this.put("yj.ruZhai", "Enter house");
                        this.put("yj.anXiang", "Incenst placement");
                        this.put("yj.anMen", "Door placing");
                        this.put("yj.xiuZao", "Repair");
                        this.put("yj.qiJi", "Digging");
                        this.put("yj.dongTu", "Break ground");
                        this.put("yj.shangLiang", "Beam placing");
                        this.put("yj.shuZhu", "Erecting pillars");
                        this.put("yj.kaiJing", "Open pond and well");
                        this.put("yj.zuoBei", "Make pond and fill water");
                        this.put("yj.chaiXie", "Smash house");
                        this.put("yj.poWu", "Break house");
                        this.put("yj.huaiYuan", "Demolish");
                        this.put("yj.buYuan", "Mending");
                        this.put("yj.faMuZuoLiang", "Make beams");
                        this.put("yj.zuoZhao", "Make stove");
                        this.put("yj.jieChu", "Removal");
                        this.put("yj.kaiZhuYan", "Build beam");
                        this.put("yj.chuanPing", "Build door");
                        this.put("yj.gaiWuHeJi", "Cover house");
                        this.put("yj.kaiCe", "Open toilet");
                        this.put("yj.zaoCang", "Build depot");
                        this.put("yj.saiXue", "Block nest");
                        this.put("yj.pingZhi", "Repair roads");
                        this.put("yj.zaoQiao", "Build bridge");
                        this.put("yj.zuoCe", "Build toilet");
                        this.put("yj.zhuDi", "Fill");
                        this.put("yj.kaiChi", "Open pond");
                        this.put("yj.faMu", "Lumbering");
                        this.put("yj.kaiQu", "Canalization");
                        this.put("yj.jueJing", "Dig well");
                        this.put("yj.saoShe", "Sweep house");
                        this.put("yj.fangShui", "Drainage");
                        this.put("yj.zaoWu", "Build house");
                        this.put("yj.heJi", "Close ridge");
                        this.put("yj.zaoChuChou", "Livestock thickening");
                        this.put("yj.xiuMen", "Repair door");
                        this.put("yj.dingSang", "Fix stone");
                        this.put("yj.zuoLiang", "Beam construction");
                        this.put("yj.xiuShi", "Decorate wall");
                        this.put("yj.jiaMa", "Erect horse");
                        this.put("yj.kaiShi", "Opening");
                        this.put("yj.guaBian", "Hang plaque");
                        this.put("yj.naChai", "Accept wealth");
                        this.put("yj.qiuCai", "Seek wealth");
                        this.put("yj.kaiCang", "Open depot");
                        this.put("yj.maiChe", "Buy car");
                        this.put("yj.zhiChan", "Buy property");
                        this.put("yj.guYong", "Hire");
                        this.put("yj.chuHuoCai", "Delivery");
                        this.put("yj.anJiXie", "Build machine");
                        this.put("yj.zaoCheQi", "Build car");
                        this.put("yj.jingLuo", "Build loom");
                        this.put("yj.yunNiang", "Brew");
                        this.put("yj.zuoRan", "Dye");
                        this.put("yj.guZhu", "Cast");
                        this.put("yj.zaoChuan", "Build boat");
                        this.put("yj.geMi", "Harvest honey");
                        this.put("yj.zaiZhong", "Farming");
                        this.put("yj.quYu", "Fishing");
                        this.put("yj.jieWang", "Netting");
                        this.put("yj.muYang", "Graze");
                        this.put("yj.anDuiWei", "Build rub");
                        this.put("yj.xiYi", "Learn");
                        this.put("yj.ruXue", "Enter school");
                        this.put("yj.liFa", "Haircut");
                        this.put("yj.tanBing", "Visiting");
                        this.put("yj.jianGui", "Meet noble");
                        this.put("yj.chengChuan", "Ride boat");
                        this.put("yj.duShui", "Cross water");
                        this.put("yj.zhenJiu", "Acupuncture");
                        this.put("yj.chuXing", "Travel");
                        this.put("yj.yiXi", "Move");
                        this.put("yj.fenJu", "Live apart");
                        this.put("yj.TiTou", "Shave");
                        this.put("yj.zhengShou", "Manicure");
                        this.put("yj.naChu", "Feed livestock");
                        this.put("yj.buZhuo", "Catch");
                        this.put("yj.tianLie", "Hunt");
                        this.put("yj.jiaoNiuMa", "Train horse");
                        this.put("yj.huiQinYou", "Meet friends");
                        this.put("yj.fuRen", "Go post");
                        this.put("yj.qiuYi", "See doctor");
                        this.put("yj.zhiBing", "Treat");
                        this.put("yj.ciSong", "Litigation");
                        this.put("yj.qiJiDongTu", "Lay foundation");
                        this.put("yj.poWuHuaiYuan", "Demolish");
                        this.put("yj.gaiWu", "Build house");
                        this.put("yj.zaoCangKu", "Build depot");
                        this.put("yj.liQuanJiaoYi", "Covenant trade");
                        this.put("yj.jiaoYi", "Trade");
                        this.put("yj.liQuan", "Covenant");
                        this.put("yj.anJi", "Install machine");
                        this.put("yj.huiYou", "Meet friends");
                        this.put("yj.qiuYiLiaoBing", "Seek treatment");
                        this.put("yj.zhuShi", "Everything Sucks");
                        this.put("yj.yuShi", "Do nothing else");
                        this.put("yj.xingSang", "Funeral");
                        this.put("yj.duanYi", "Block ant hole");
                        this.put("yj.guiXiu", "Place beam");
                        this.put("xx.bi", "Finish");
                        this.put("xx.yi", "Wing");
                        this.put("xx.ji", "Sieve");
                        this.put("xx.kui", "Qui");
                        this.put("xx.gui", "Ghost");
                        this.put("xx.di", "Foundation");
                        this.put("xx.xu", "Virtual");
                        this.put("xx.wei", "Danger");
                        this.put("xx.zi", "Mouth");
                        this.put("xx.zhen", "Cross-bar");
                        this.put("xx.dou", "Fight");
                        this.put("xx.lou", "Weak");
                        this.put("xx.liu", "Willow");
                        this.put("xx.fang", "House");
                        this.put("xx.xin", "Heart");
                        this.put("xx.shi", "Room");
                        this.put("xx.can", "Join");
                        this.put("xx.jiao", "Horn");
                        this.put("xx.niu", "Ox");
                        this.put("xx.vei", "Stomach");
                        this.put("xx.xing", "Star");
                        this.put("xx.zhang", "Chang");
                        this.put("xx.tail", "Tail");
                        this.put("xx.qiang", "Wall");
                        this.put("xx.jing", "Well");
                        this.put("xx.kang", "Kang");
                        this.put("xx.nv", "Female");
                        this.put("xx.mao", "Mao");
                        this.put("sz.chun", "Spring");
                        this.put("sz.xia", "Summer");
                        this.put("sz.qiu", "Autumn");
                        this.put("sz.dong", "Winter");
                        this.put("yx.shuo", "New");
                        this.put("yx.eMeiXin", "New waxing");
                        this.put("yx.eMei", "Waxing");
                        this.put("yx.xi", "Evening");
                        this.put("yx.shangXian", "First quarter");
                        this.put("yx.jiuYe", "Nine night");
                        this.put("yx.night", "Night");
                        this.put("yx.jianYingTu", "Gibbous");
                        this.put("yx.xiaoWang", "Little full");
                        this.put("yx.wang", "Full");
                        this.put("yx.jianKuiTu", "Disseminating");
                        this.put("yx.xiaXian", "Third quarter");
                        this.put("yx.eMeiCan", "Waning waxing");
                        this.put("yx.can", "Waning");
                        this.put("yx.xiao", "Daybreak");
                        this.put("yx.hui", "Obscure");
                        this.put("ny.sangZhe", "Cudrania");
                        this.put("ny.baiLa", "Wax");
                        this.put("ny.yangLiu", "Willow");
                        this.put("ny.jinBo", "Foil");
                        this.put("ny.haiZhong", "Sea");
                        this.put("ny.daHai", "Ocean");
                        this.put("ny.shaZhong", "Sand");
                        this.put("ny.luZhong", "Stove");
                        this.put("ny.shanXia", "Piedmont");
                        this.put("ny.daLin", "Forest");
                        this.put("ny.pingDi", "Land");
                        this.put("ny.luPang", "Roadside");
                        this.put("ny.biShang", "Wall");
                        this.put("ny.jianFeng", "Blade");
                        this.put("ny.shanTou", "Hilltop");
                        this.put("ny.fuDeng", "Light");
                        this.put("ny.jianXia", "Valleyn");
                        this.put("ny.tianHe", "River");
                        this.put("ny.chengTou", "City");
                        this.put("ny.daYi", "Post");
                        this.put("ny.chaiChuan", "Ornaments");
                        this.put("ny.quanZhong", "Spring");
                        this.put("ny.daXi", "Stream");
                        this.put("ny.wuShang", "Roof");
                        this.put("ny.piLi", "Thunderbolt");
                        this.put("ny.tianShang", "Sky");
                        this.put("ny.songBo", "Coniferin");
                        this.put("ny.shiLiu", "Pomegranate");
                        this.put("ny.changLiu", "Flows");
                    }
                });
            }
        };
        DICT_STRING = new HashMap<String, Map<String, Map<String, String>>>(){
            {
                this.put("LunarUtil", new HashMap<String, Map<String, String>>(){
                    {
                        this.put("TIAN_SHEN_TYPE", new HashMap());
                        this.put("TIAN_SHEN_TYPE_LUCK", new HashMap());
                        this.put("XIU_LUCK", new HashMap());
                        this.put("LU", new HashMap());
                        this.put("XIU", new HashMap());
                        this.put("SHA", new HashMap());
                        this.put("POSITION_DESC", new HashMap());
                        this.put("NAYIN", new HashMap());
                        this.put("WU_XING_GAN", new HashMap());
                        this.put("WU_XING_ZHI", new HashMap());
                        this.put("SHOU", new HashMap());
                        this.put("GONG", new HashMap());
                        this.put("FESTIVAL", new HashMap());
                        this.put("ZHENG", new HashMap());
                        this.put("ANIMAL", new HashMap());
                        this.put("SHI_SHEN_GAN", new HashMap());
                        this.put("SHI_SHEN_ZHI", new HashMap());
                        this.put("XIU_SONG", new HashMap());
                    }
                });
                this.put("SolarUtil", new HashMap<String, Map<String, String>>(){
                    {
                        this.put("FESTIVAL", new HashMap());
                    }
                });
                this.put("TaoUtil", new HashMap<String, Map<String, String>>(){
                    {
                        this.put("BA_HUI", new HashMap());
                        this.put("BA_JIE", new HashMap());
                    }
                });
            }
        };
        DICT_NUMBER = new HashMap<String, Map<String, Map<String, Integer>>>(){
            {
                this.put("LunarUtil", new HashMap<String, Map<String, Integer>>(){
                    {
                        this.put("ZHI_TIAN_SHEN_OFFSET", new HashMap());
                        this.put("CHANG_SHENG_OFFSET", new HashMap());
                    }
                });
            }
        };
        DICT_ARRAY = new HashMap<String, Map<String, Map<String, List<String>>>>(){
            {
                this.put("LunarUtil", new HashMap<String, Map<String, List<String>>>(){
                    {
                        this.put("ZHI_HIDE_GAN", new HashMap());
                    }
                });
            }
        };
        ARRAYS = new HashMap<String, Map<String, String[]>>(){
            {
                this.put("LunarUtil", new HashMap<String, String[]>(){
                    {
                        this.put("GAN", null);
                        this.put("ZHI", null);
                        this.put("JIA_ZI", null);
                        this.put("ZHI_XING", null);
                        this.put("XUN", null);
                        this.put("XUN_KONG", null);
                        this.put("CHONG", null);
                        this.put("CHONG_GAN", null);
                        this.put("CHONG_GAN_TIE", null);
                        this.put("HE_GAN_5", null);
                        this.put("HE_ZHI_6", null);
                        this.put("SHENGXIAO", null);
                        this.put("NUMBER", null);
                        this.put("POSITION_XI", null);
                        this.put("POSITION_YANG_GUI", null);
                        this.put("POSITION_YIN_GUI", null);
                        this.put("POSITION_FU", null);
                        this.put("POSITION_FU_2", null);
                        this.put("POSITION_CAI", null);
                        this.put("POSITION_TAI_SUI_YEAR", null);
                        this.put("POSITION_GAN", null);
                        this.put("POSITION_ZHI", null);
                        this.put("JIE_QI", null);
                        this.put("JIE_QI_IN_USE", null);
                        this.put("TIAN_SHEN", null);
                        this.put("SHEN_SHA", null);
                        this.put("PENGZU_GAN", null);
                        this.put("PENGZU_ZHI", null);
                        this.put("MONTH_ZHI", null);
                        this.put("CHANG_SHENG", null);
                        this.put("HOU", null);
                        this.put("WU_HOU", null);
                        this.put("POSITION_TAI_DAY", null);
                        this.put("POSITION_TAI_MONTH", null);
                        this.put("YI_JI", null);
                        this.put("LIU_YAO", null);
                        this.put("MONTH", null);
                        this.put("SEASON", null);
                        this.put("DAY", null);
                        this.put("YUE_XIANG", null);
                    }
                });
                this.put("SolarUtil", new HashMap<String, String[]>(){
                    {
                        this.put("WEEK", null);
                        this.put("XINGZUO", null);
                    }
                });
                this.put("TaoUtil", new HashMap<String, String[]>(){
                    {
                        this.put("AN_WU", null);
                    }
                });
                this.put("FotoUtil", new HashMap<String, String[]>(){
                    {
                        this.put("XIU_27", null);
                    }
                });
                this.put("NineStarUtil", new HashMap<String, String[]>(){
                    {
                        this.put("NUMBER", null);
                        this.put("WU_XING", null);
                        this.put("POSITION", null);
                        this.put("LUCK_XUAN_KONG", null);
                        this.put("YIN_YANG_QI_MEN", null);
                        this.put("COLOR", null);
                    }
                });
            }
        };
        I18n.init();
    }
}

