/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Holiday;
import com.nlf.calendar.Lunar;
import com.nlf.calendar.SolarMonth;
import com.nlf.calendar.util.HolidayUtil;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solar {
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT+8");
    public static final double J2000 = 2451545.0;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;

    public Solar() {
        this(new Date());
    }

    public Solar(int year, int month, int day) {
        this(year, month, day, 0, 0, 0);
    }

    public Solar(int year, int month, int day, int hour, int minute, int second) {
        if (1582 == year && 10 == month && day > 4 && day < 15) {
            throw new IllegalArgumentException(String.format("wrong solar year %d month %d day %d", year, month, day));
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException(String.format("wrong month %d", month));
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException(String.format("wrong day %d", day));
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(String.format("wrong hour %d", hour));
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(String.format("wrong minute %d", minute));
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException(String.format("wrong second %d", second));
        }
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public Solar(Date date) {
        Calendar c = Calendar.getInstance(TIME_ZONE);
        c.setTime(date);
        c.set(14, 0);
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.day = c.get(5);
        this.hour = c.get(11);
        this.minute = c.get(12);
        this.second = c.get(13);
    }

    public Solar(Calendar calendar) {
        calendar.set(14, 0);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    public Solar(double julianDay) {
        int d = (int)(julianDay + 0.5);
        double f = julianDay + 0.5 - (double)d;
        if (d >= 2299161) {
            int c = (int)(((double)d - 1867216.25) / 36524.25);
            d += 1 + c - (int)((double)c * 1.0 / 4.0);
        }
        int year = (int)(((double)(d += 1524) - 122.1) / 365.25);
        int month = (int)((double)(d -= (int)(365.25 * (double)year)) * 1.0 / 30.601);
        int day = d -= (int)(30.601 * (double)month);
        if (month > 13) {
            month -= 13;
            year -= 4715;
        } else {
            --month;
            year -= 4716;
        }
        int hour = (int)(f *= 24.0);
        f -= (double)hour;
        int minute = (int)(f *= 60.0);
        f -= (double)minute;
        int second = (int)Math.round(f *= 60.0);
        if (second > 59) {
            second -= 60;
            ++minute;
        }
        if (minute > 59) {
            minute -= 60;
            ++hour;
        }
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public static Solar fromDate(Date date) {
        return new Solar(date);
    }

    public static Solar fromCalendar(Calendar calendar) {
        return new Solar(calendar);
    }

    public static Solar fromJulianDay(double julianDay) {
        return new Solar(julianDay);
    }

    public static Solar fromYmd(int year, int month, int day) {
        return new Solar(year, month, day);
    }

    public static Solar fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return new Solar(year, month, day, hour, minute, second);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi) {
        return Solar.fromBaZi(yearGanZhi, monthGanZhi, dayGanZhi, timeGanZhi, 2);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi, int sect) {
        return Solar.fromBaZi(yearGanZhi, monthGanZhi, dayGanZhi, timeGanZhi, sect, 1900);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi, int sect, int baseYear) {
        sect = 1 == sect ? 1 : 2;
        ArrayList<Solar> l = new ArrayList<Solar>();
        ArrayList<Integer> years = new ArrayList<Integer>();
        Solar today = Solar.fromDate(new Date());
        int offsetYear = LunarUtil.getJiaZiIndex(today.getLunar().getYearInGanZhiExact()) - LunarUtil.getJiaZiIndex(yearGanZhi);
        if (offsetYear < 0) {
            offsetYear += 60;
        }
        int minYear = baseYear - 2;
        for (int startYear = today.getYear() - offsetYear - 1; startYear >= minYear; startYear -= 60) {
            years.add(startYear);
        }
        ArrayList<Integer> hours = new ArrayList<Integer>(2);
        LunarUtil.IndexValue timeZhi = LunarUtil.find(timeGanZhi, LunarUtil.ZHI);
        if (null != timeZhi) {
            hours.add((timeZhi.getIndex() - 1) * 2);
            if (1 == timeZhi.getIndex()) {
                hours.add(23);
            }
        }
        Iterator iterator = hours.iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            block2: for (Integer y : years) {
                int maxYear = y + 3;
                int year = y;
                int month = 11;
                if (year < baseYear) {
                    year = baseYear;
                    month = 1;
                }
                Solar solar = Solar.fromYmdHms(year, month, 1, hour, 0, 0);
                while (solar.getYear() <= maxYear) {
                    String dgz;
                    Lunar lunar = solar.getLunar();
                    String string = dgz = 2 == sect ? lunar.getDayInGanZhiExact2() : lunar.getDayInGanZhiExact();
                    if (lunar.getYearInGanZhiExact().equals(yearGanZhi) && lunar.getMonthInGanZhiExact().equals(monthGanZhi) && dgz.equals(dayGanZhi) && lunar.getTimeInGanZhi().equals(timeGanZhi)) {
                        l.add(solar);
                        continue block2;
                    }
                    solar = solar.next(1);
                }
            }
        }
        return l;
    }

    public boolean isLeapYear() {
        return SolarUtil.isLeapYear(this.year);
    }

    public int getWeek() {
        Solar start = Solar.fromYmd(1582, 10, 15);
        int y = this.year;
        int m = this.month;
        int d = this.day;
        Solar current = Solar.fromYmd(y, m, d);
        if (m < 3) {
            m += 12;
            --y;
        }
        int c = y / 100;
        int x = (y -= c * 100) + y / 4 + c / 4 - 2 * c;
        int w = current.isBefore(start) ? (x + 13 * (m + 1) / 5 + d + 2) % 7 : (x + 26 * (m + 1) / 10 + d - 1) % 7;
        return (w + 7) % 7;
    }

    public String getWeekInChinese() {
        return SolarUtil.WEEK[this.getWeek()];
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = SolarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        int weeks = (int)Math.ceil((double)this.day / 7.0);
        int week = this.getWeek();
        f = SolarUtil.WEEK_FESTIVAL.get(this.month + "-" + weeks + "-" + week);
        if (null != f) {
            l.add(f);
        }
        if (this.day + 7 > SolarUtil.getDaysOfMonth(this.year, this.month) && null != (f = SolarUtil.WEEK_FESTIVAL.get(this.month + "-0-" + week))) {
            l.add(f);
        }
        return l;
    }

    public List<String> getOtherFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        List<String> fs = SolarUtil.OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            l.addAll(fs);
        }
        return l;
    }

    public String getXingzuo() {
        return this.getXingZuo();
    }

    public String getXingZuo() {
        int index = 11;
        int y = this.month * 100 + this.day;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 621) {
            index = 2;
        } else if (y >= 622 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1023) {
            index = 6;
        } else if (y >= 1024 && y <= 1122) {
            index = 7;
        } else if (y >= 1123 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return SolarUtil.XINGZUO[index];
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public Lunar getLunar() {
        return new Lunar(this);
    }

    public double getJulianDay() {
        boolean g;
        int y = this.year;
        int m = this.month;
        double d = (double)this.day + (((double)this.second * 1.0 / 60.0 + (double)this.minute) / 60.0 + (double)this.hour) / 24.0;
        int n = 0;
        boolean bl = g = y * 372 + m * 31 + (int)d >= 588829;
        if (m <= 2) {
            m += 12;
            --y;
        }
        if (g) {
            n = (int)((double)y * 1.0 / 100.0);
            n = 2 - n + (int)((double)n * 1.0 / 4.0);
        }
        return (double)((int)(365.25 * (double)(y + 4716)) + (int)(30.6001 * (double)(m + 1))) + d + (double)n - 1524.5;
    }

    public String toString() {
        return this.toYmd();
    }

    public String toYmd() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public String toYmdHms() {
        return this.toYmd() + " " + String.format("%02d:%02d:%02d", this.hour, this.minute, this.second);
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this.toYmdHms());
        if (this.isLeapYear()) {
            s.append(" ");
            s.append("\u95f0\u5e74");
        }
        s.append(" ");
        s.append("\u661f\u671f");
        s.append(this.getWeekInChinese());
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        for (String f : this.getOtherFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        s.append(" ");
        s.append(this.getXingZuo());
        s.append("\u5ea7");
        return s.toString();
    }

    public int subtract(Solar solar) {
        return SolarUtil.getDaysBetween(solar.getYear(), solar.getMonth(), solar.getDay(), this.year, this.month, this.day);
    }

    public int subtractMinute(Solar solar) {
        int days = this.subtract(solar);
        int cm = this.hour * 60 + this.minute;
        int sm = solar.getHour() * 60 + solar.getMinute();
        int m = cm - sm;
        if (m < 0) {
            m += 1440;
            --days;
        }
        return m += days * 1440;
    }

    public boolean isAfter(Solar solar) {
        if (this.year > solar.getYear()) {
            return true;
        }
        if (this.year < solar.getYear()) {
            return false;
        }
        if (this.month > solar.getMonth()) {
            return true;
        }
        if (this.month < solar.getMonth()) {
            return false;
        }
        if (this.day > solar.getDay()) {
            return true;
        }
        if (this.day < solar.getDay()) {
            return false;
        }
        if (this.hour > solar.getHour()) {
            return true;
        }
        if (this.hour < solar.getHour()) {
            return false;
        }
        if (this.minute > solar.getMinute()) {
            return true;
        }
        if (this.minute < solar.getMinute()) {
            return false;
        }
        return this.second > solar.getSecond();
    }

    public boolean isBefore(Solar solar) {
        if (this.year > solar.getYear()) {
            return false;
        }
        if (this.year < solar.getYear()) {
            return true;
        }
        if (this.month > solar.getMonth()) {
            return false;
        }
        if (this.month < solar.getMonth()) {
            return true;
        }
        if (this.day > solar.getDay()) {
            return false;
        }
        if (this.day < solar.getDay()) {
            return true;
        }
        if (this.hour > solar.getHour()) {
            return false;
        }
        if (this.hour < solar.getHour()) {
            return true;
        }
        if (this.minute > solar.getMinute()) {
            return false;
        }
        if (this.minute < solar.getMinute()) {
            return true;
        }
        return this.second < solar.getSecond();
    }

    public Solar nextYear(int years) {
        int y = this.year + years;
        int m = this.month;
        int d = this.day;
        if (2 == m && d > 28 && !SolarUtil.isLeapYear(y)) {
            d = 28;
        }
        if (1582 == y && 10 == m && d > 4 && d < 15) {
            d += 10;
        }
        return Solar.fromYmdHms(y, m, d, this.hour, this.minute, this.second);
    }

    public Solar nextMonth(int months) {
        SolarMonth month = SolarMonth.fromYm(this.year, this.month).next(months);
        int y = month.getYear();
        int m = month.getMonth();
        int d = this.day;
        if (2 == m && d > 28 && !SolarUtil.isLeapYear(y)) {
            d = 28;
        }
        if (1582 == y && 10 == m && d > 4 && d < 15) {
            d += 10;
        }
        return Solar.fromYmdHms(y, m, d, this.hour, this.minute, this.second);
    }

    public Solar next(int days) {
        int y = this.year;
        int m = this.month;
        int d = this.day;
        if (1582 == y && 10 == m && d > 4) {
            d -= 10;
        }
        if (days > 0) {
            d += days;
            int daysInMonth = SolarUtil.getDaysOfMonth(y, m);
            while (d > daysInMonth) {
                d -= daysInMonth;
                if (++m > 12) {
                    m = 1;
                    ++y;
                }
                daysInMonth = SolarUtil.getDaysOfMonth(y, m);
            }
        } else if (days < 0) {
            while (d + days <= 0) {
                if (--m < 1) {
                    m = 12;
                    --y;
                }
                d += SolarUtil.getDaysOfMonth(y, m);
            }
            d += days;
        }
        if (1582 == y && 10 == m && d > 4) {
            d += 10;
        }
        return Solar.fromYmdHms(y, m, d, this.hour, this.minute, this.second);
    }

    public Solar next(int days, boolean onlyWorkday) {
        if (!onlyWorkday) {
            return this.next(days);
        }
        Solar solar = Solar.fromYmdHms(this.year, this.month, this.day, this.hour, this.minute, this.second);
        if (days != 0) {
            int add;
            int rest = Math.abs(days);
            int n = add = days < 0 ? -1 : 1;
            while (rest > 0) {
                solar = solar.next(add);
                boolean work = true;
                Holiday holiday = HolidayUtil.getHoliday(solar.getYear(), solar.getMonth(), solar.getDay());
                if (null == holiday) {
                    int week = solar.getWeek();
                    if (0 == week || 6 == week) {
                        work = false;
                    }
                } else {
                    work = holiday.isWork();
                }
                if (!work) continue;
                --rest;
            }
        }
        return solar;
    }

    public Solar nextHour(int hours) {
        int h = this.hour + hours;
        int n = h < 0 ? -1 : 1;
        int hour = Math.abs(h);
        int days = hour / 24 * n;
        if ((hour = hour % 24 * n) < 0) {
            hour += 24;
            --days;
        }
        Solar solar = this.next(days);
        return Solar.fromYmdHms(solar.getYear(), solar.getMonth(), solar.getDay(), hour, solar.getMinute(), solar.getSecond());
    }
}

