/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Solar;
import com.nlf.calendar.SolarWeek;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarMonth {
    private final int year;
    private final int month;

    public SolarMonth() {
        this(new Date());
    }

    public SolarMonth(Date date) {
        Solar solar = Solar.fromDate(date);
        this.year = solar.getYear();
        this.month = solar.getMonth();
    }

    @Deprecated
    public SolarMonth(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
    }

    public SolarMonth(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public static SolarMonth fromDate(Date date) {
        return new SolarMonth(date);
    }

    @Deprecated
    public static SolarMonth fromCalendar(Calendar calendar) {
        return new SolarMonth(calendar);
    }

    public static SolarMonth fromYm(int year, int month) {
        return new SolarMonth(year, month);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public List<Solar> getDays() {
        ArrayList<Solar> l = new ArrayList<Solar>(31);
        Solar d = new Solar(this.year, this.month, 1);
        l.add(d);
        int days = SolarUtil.getDaysOfMonth(this.year, this.month);
        for (int i = 1; i < days; ++i) {
            l.add(d.next(i));
        }
        return l;
    }

    public List<SolarWeek> getWeeks(int start) {
        Solar firstDay;
        ArrayList<SolarWeek> l = new ArrayList<SolarWeek>();
        SolarWeek week = SolarWeek.fromYmd(this.year, this.month, 1, start);
        do {
            l.add(week);
        } while ((firstDay = (week = week.next(1, false)).getFirstDay()).getYear() <= this.year && firstDay.getMonth() <= this.month);
        return l;
    }

    public SolarMonth next(int months) {
        int n = months < 0 ? -1 : 1;
        int m = Math.abs(months);
        int y = this.year + m / 12 * n;
        if ((m = this.month + m % 12 * n) > 12) {
            m -= 12;
            ++y;
        } else if (m < 1) {
            m += 12;
            --y;
        }
        return new SolarMonth(y, m);
    }

    public String toString() {
        return this.year + "-" + this.month;
    }

    public String toFullString() {
        return this.year + "\u5e74" + this.month + "\u6708";
    }
}

