/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.eightchar;

import com.nlf.calendar.eightchar.LiuNian;
import com.nlf.calendar.util.LunarUtil;

public class LiuYue {
    private final int index;
    private final LiuNian liuNian;

    public LiuYue(LiuNian liuNian, int index) {
        this.liuNian = liuNian;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getMonthInChinese() {
        return LunarUtil.MONTH[this.index + 1];
    }

    public String getGanZhi() {
        int yearGanIndex = 0;
        LunarUtil.IndexValue iv = LunarUtil.find(this.liuNian.getGanZhi(), LunarUtil.GAN);
        if (null != iv) {
            yearGanIndex = iv.getIndex() - 1;
        }
        int offset = (new int[]{2, 4, 6, 8, 0})[yearGanIndex % 5];
        String gan = LunarUtil.GAN[(this.index + offset) % 10 + 1];
        String zhi = LunarUtil.ZHI[(this.index + 2) % 12 + 1];
        return gan + zhi;
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }
}

