/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.noSql.type.redis;

import com.nlf.extend.dao.noSql.type.redis.RedisSetting;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDriver {
    private static JedisPool jedisPool = null;

    private static void init() {
    }

    private static synchronized void initPool(RedisSetting setting) {
        if (null != jedisPool) {
            return;
        }
        JedisPoolConfig config = new JedisPoolConfig();
        if (-1 != setting.getMaxTotal()) {
            config.setMaxActive(setting.getMaxTotal());
        }
        if (-1 != setting.getMaxIdle()) {
            config.setMaxIdle(setting.getMaxIdle());
        }
        if (-1L != setting.getMaxWaitMillis()) {
            config.setMaxWait(setting.getMaxWaitMillis());
        }
        if (-1L != setting.getMinEvictableIdleTimeMillis()) {
            config.setMinEvictableIdleTimeMillis(setting.getMinEvictableIdleTimeMillis());
        }
        if (-1 != setting.getMinIdle()) {
            config.setMinIdle(setting.getMinIdle());
        }
        if (-1 != setting.getNumTestsPerEvictionRun()) {
            config.setNumTestsPerEvictionRun(setting.getNumTestsPerEvictionRun());
        }
        if (-1L != setting.getSoftMinEvictableIdleTimeMillis()) {
            config.setSoftMinEvictableIdleTimeMillis(setting.getSoftMinEvictableIdleTimeMillis());
        }
        if (-1L != setting.getTimeBetweenEvictionRunsMillis()) {
            config.setTimeBetweenEvictionRunsMillis(setting.getTimeBetweenEvictionRunsMillis());
        }
        config.setWhenExhaustedAction((byte)(setting.isBlockWhenExhausted() ? 1 : 0));
        config.setTestOnBorrow(setting.isTestOnBorrow());
        config.setTestOnReturn(setting.isTestOnReturn());
        config.setTestWhileIdle(setting.isTestWhileIdle());
        String password = setting.getPassword();
        jedisPool = null == password || password.length() < 1 ? new JedisPool((GenericObjectPool.Config)config, setting.getHost(), setting.getPort(), setting.getTimeOut()) : new JedisPool((GenericObjectPool.Config)config, setting.getHost(), setting.getPort(), setting.getTimeOut(), password);
    }

    public static Jedis getJedis(RedisSetting setting) {
        RedisDriver.initPool(setting);
        try {
            return (Jedis)jedisPool.getResource();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void closeQuietly(Jedis jedis) {
        if (null == jedisPool) {
            return;
        }
        if (null == jedis) {
            return;
        }
        try {
            jedisPool.returnResource((Object)jedis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        RedisDriver.init();
    }
}

