/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import cn.afterturn.easypoi.cache.ImageCache;
import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelCollection;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.excel.annotation.ExcelIgnore;
import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import cn.afterturn.easypoi.word.entity.params.ExcelListEntity;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoiPublicUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiPublicUtil.class);

    private PoiPublicUtil() {
    }

    public static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static Object createObject(Class<?> clazz, String targetId) {
        Object obj = null;
        try {
            Field[] fields;
            if (clazz.equals(Map.class)) {
                return new LinkedHashMap();
            }
            obj = clazz.newInstance();
            for (Field field : fields = PoiPublicUtil.getClassFields(clazz)) {
                if (PoiPublicUtil.isNotUserExcelUserThis(null, field, targetId)) continue;
                if (PoiPublicUtil.isCollection(field.getType())) {
                    ExcelCollection collection = field.getAnnotation(ExcelCollection.class);
                    PoiReflectorUtil.fromCache(clazz).setValue(obj, field.getName(), collection.type().newInstance());
                    continue;
                }
                if (PoiPublicUtil.isJavaClass(field) || field.getType().isEnum()) continue;
                PoiReflectorUtil.fromCache(clazz).setValue(obj, field.getName(), PoiPublicUtil.createObject(field.getType(), targetId));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38");
        }
        return obj;
    }

    public static Field[] getClassFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                list.add(fields[i]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return list.toArray(fields);
    }

    public static String getFileExtendName(byte[] photoByte) {
        String strFileExtendName = "JPG";
        if (photoByte[0] == 71 && photoByte[1] == 73 && photoByte[2] == 70 && photoByte[3] == 56 && (photoByte[4] == 55 || photoByte[4] == 57) && photoByte[5] == 97) {
            strFileExtendName = "GIF";
        } else if (photoByte[6] == 74 && photoByte[7] == 70 && photoByte[8] == 73 && photoByte[9] == 70) {
            strFileExtendName = "JPG";
        } else if (photoByte[0] == 66 && photoByte[1] == 77) {
            strFileExtendName = "BMP";
        } else if (photoByte[1] == 80 && photoByte[2] == 78 && photoByte[3] == 71) {
            strFileExtendName = "PNG";
        }
        return strFileExtendName;
    }

    public static boolean hasBom(InputStream in) throws IOException {
        byte[] head = new byte[3];
        in.read(head);
        return head[0] == -17 && head[1] == -69 && head[2] == -65;
    }

    public static Map<String, PictureData> getSheetPictrues03(HSSFSheet sheet, HSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (!pictures.isEmpty()) {
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                if (!(shape instanceof HSSFPicture)) continue;
                HSSFPicture pic = (HSSFPicture)shape;
                int pictureIndex = pic.getPictureIndex() - 1;
                HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
                String picIndex = String.valueOf(anchor.getRow1()) + "_" + String.valueOf(anchor.getCol1());
                sheetIndexPicMap.put(picIndex, (PictureData)picData);
            }
            return sheetIndexPicMap;
        }
        return sheetIndexPicMap;
    }

    public static Map<String, PictureData> getSheetPictrues07(XSSFSheet sheet, XSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                String picIndex = ctMarker.getRow() + "_" + ctMarker.getCol();
                sheetIndexPicMap.put(picIndex, (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isJavaClass(Field field) {
        Class<?> fieldType = field.getType();
        boolean isBaseClass = false;
        if (fieldType.isArray()) {
            isBaseClass = false;
        } else if (fieldType.isPrimitive() || fieldType.getPackage() == null || "java.lang".equals(fieldType.getPackage().getName()) || "java.math".equals(fieldType.getPackage().getName()) || "java.sql".equals(fieldType.getPackage().getName()) || "java.time".equals(fieldType.getPackage().getName()) || "java.util".equals(fieldType.getPackage().getName())) {
            isBaseClass = true;
        }
        return isBaseClass;
    }

    public static boolean isNotUserExcelUserThis(List<String> exclusionsList, Field field, String targetId) {
        boolean boo = true;
        if (field.getAnnotation(ExcelIgnore.class) != null) {
            boo = true;
        } else if (boo && field.getAnnotation(ExcelCollection.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelCollection.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelCollection.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(Excel.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(Excel.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(Excel.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(ExcelEntity.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelEntity.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelEntity.class).name()))) {
            boo = false;
        }
        return boo;
    }

    private static boolean isUseInThis(String exportName, String targetId) {
        return targetId == null || "".equals(exportName) || exportName.indexOf("_") < 0 || exportName.indexOf(targetId) != -1;
    }

    private static Integer getImageType(String type) {
        if ("JPG".equalsIgnoreCase(type) || "JPEG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("GIF".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("BMP".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        return 5;
    }

    public static Object[] getIsAndType(ImageEntity entity) throws Exception {
        String type;
        Object[] result = new Object[2];
        if (entity.getType().equals(ImageEntity.URL)) {
            result[0] = ImageCache.getImage(entity.getUrl());
            type = entity.getUrl().split("/.")[entity.getUrl().split("/.").length - 1];
        } else {
            result[0] = entity.getData();
            type = PoiPublicUtil.getFileExtendName(entity.getData());
        }
        result[1] = PoiPublicUtil.getImageType(type);
        return result;
    }

    public static Object getParamsValue(String params, Object object) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return PoiPublicUtil.getValueDoWhile(object, paramsArr, 0);
        }
        if (object instanceof Map) {
            return ((Map)object).get(params);
        }
        return PoiReflectorUtil.fromCache(object.getClass()).getValue(object, params);
    }

    public static Object getRealValue(String currentText, Map<String, Object> map) throws Exception {
        String params = "";
        while (currentText.indexOf("{{") != -1) {
            params = currentText.substring(currentText.indexOf("{{") + 2, currentText.indexOf("}}"));
            Object obj = PoiElUtil.eval(params.trim(), map);
            if (obj instanceof ImageEntity || obj instanceof List || obj instanceof ExcelListEntity) {
                return obj;
            }
            if (obj != null) {
                currentText = currentText.replace("{{" + params + "}}", obj.toString());
                continue;
            }
            currentText = currentText.replace("{{" + params + "}}", "");
        }
        return currentText;
    }

    public static Object getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        if (object == null) {
            return "";
        }
        if (object instanceof ImageEntity) {
            return object;
        }
        if ((object = object instanceof Map ? ((Map)object).get(paramsArr[index]) : PoiReflectorUtil.fromCache(object.getClass()).getValue(object, paramsArr[index])) instanceof Collection) {
            return object;
        }
        return index == paramsArr.length - 1 ? (object == null ? "" : object) : PoiPublicUtil.getValueDoWhile(object, paramsArr, ++index);
    }

    public static String doubleToString(Double value) {
        String temp = value.toString();
        if (temp.contains("E")) {
            BigDecimal bigDecimal = new BigDecimal(temp);
            temp = bigDecimal.toPlainString();
        }
        return temp;
    }

    public static String getValueByTargetId(String key, String targetId, String defalut) {
        String[] arr;
        if (StringUtils.isEmpty((CharSequence)targetId) || key.indexOf("_") < 0) {
            return key;
        }
        for (String str : arr = key.split(",")) {
            String[] tempArr = str.split("_");
            if (tempArr == null || tempArr.length < 2) {
                return defalut;
            }
            if (!targetId.equals(tempArr[1])) continue;
            return tempArr[0];
        }
        return defalut;
    }

    public static void setWordText(XWPFRun currentRun, String currentText) {
        if (StringUtils.isNotEmpty((CharSequence)currentText)) {
            String[] tempArr = currentText.split("\r\n");
            int le = tempArr.length - 1;
            for (int i = 0; i < le; ++i) {
                currentRun.setText(tempArr[i], i);
                currentRun.addBreak();
            }
            currentRun.setText(tempArr[tempArr.length - 1], tempArr.length - 1);
        } else {
            currentRun.setText("", 0);
        }
    }

    public static int getNumDigits(int num) {
        int count = 0;
        while (num > 0) {
            num /= 10;
            ++count;
        }
        return count;
    }

    public static String getLastFieldName(String name) {
        String[] paramsArr = name.split("\\.");
        return paramsArr[paramsArr.length - 1];
    }

    public static String getElStr(String str, String key) {
        int keyIndex = str.indexOf(key);
        int startIndex = str.substring(0, keyIndex).lastIndexOf("{{");
        int endIndex = str.indexOf("}}", keyIndex) + 2;
        return str.substring(startIndex, endIndex);
    }
}

