/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiCssUtils {
    private static final Logger log = LoggerFactory.getLogger(PoiCssUtils.class);
    private static final String COLOR_PATTERN_VALUE_SHORT = "^(#(?:[a-f]|\\d){3})$";
    private static final String COLOR_PATTERN_VALUE_LONG = "^(#(?:[a-f]|\\d{2}){3})$";
    private static final String COLOR_PATTERN_RGB = "^(rgb\\s*\\(\\s*(.+)\\s*,\\s*(.+)\\s*,\\s*(.+)\\s*\\))$";
    private static final Pattern COLOR_PATTERN_VALUE_SHORT_PATTERN = Pattern.compile("([a-f]|\\d)");
    private static final Pattern INT_PATTERN = Pattern.compile("^(\\d+)(?:\\w+|%)?$");
    private static final Pattern INT_AND_PER_PATTERN = Pattern.compile("^(\\d*\\.?\\d+)\\s*(%)?$");

    private static String colorName(Class<? extends HSSFColor> color) {
        return color.getSimpleName().replace("_", "").toLowerCase();
    }

    public static int getInt(String strValue) {
        Matcher m;
        int value = 0;
        if (StringUtils.isNotBlank((CharSequence)strValue) && (m = INT_PATTERN.matcher(strValue)).find()) {
            value = Integer.parseInt(m.group(1));
        }
        return value;
    }

    public static boolean isNum(String strValue) {
        return StringUtils.isNotBlank((CharSequence)strValue) && strValue.matches("^\\d+(\\w+|%)?$");
    }

    public static String processColor(String color) {
        log.info("Process Color [{}].", (Object)color);
        String colorRtn = null;
        if (StringUtils.isNotBlank((CharSequence)color)) {
            HSSFColor poiColor = null;
            if (color.matches(COLOR_PATTERN_VALUE_SHORT)) {
                log.debug("Short Hex Color [{}] Found.", (Object)color);
                StringBuffer sbColor = new StringBuffer();
                Matcher m = COLOR_PATTERN_VALUE_SHORT_PATTERN.matcher(color);
                while (m.find()) {
                    m.appendReplacement(sbColor, "$1$1");
                }
                colorRtn = sbColor.toString();
                log.debug("Translate Short Hex Color [{}] To [{}].", (Object)color, (Object)colorRtn);
            } else if (color.matches(COLOR_PATTERN_VALUE_LONG)) {
                colorRtn = color;
                log.debug("Hex Color [{}] Found, Return.", (Object)color);
            } else if (color.matches(COLOR_PATTERN_RGB)) {
                Matcher m = Pattern.compile(COLOR_PATTERN_RGB).matcher(color);
                if (m.matches()) {
                    log.debug("RGB Color [{}] Found.", (Object)color);
                    colorRtn = PoiCssUtils.convertColor(PoiCssUtils.calcColorValue(m.group(2)), PoiCssUtils.calcColorValue(m.group(3)), PoiCssUtils.calcColorValue(m.group(4)));
                    log.debug("Translate RGB Color [{}] To Hex [{}].", (Object)color, (Object)colorRtn);
                }
            } else {
                poiColor = PoiCssUtils.getHssfColor(color);
                if (poiColor != null) {
                    log.debug("Color Name [{}] Found.", (Object)color);
                    short[] t = poiColor.getTriplet();
                    colorRtn = PoiCssUtils.convertColor(t[0], t[1], t[2]);
                    log.debug("Translate Color Name [{}] To Hex [{}].", (Object)color, (Object)colorRtn);
                }
            }
        }
        return colorRtn;
    }

    private static HSSFColor getHssfColor(String color) {
        String tmpColor;
        switch (tmpColor = color.replace("_", "").toUpperCase()) {
            case "BLACK": {
                return HSSFColor.HSSFColorPredefined.BLACK.getColor();
            }
            case "BROWN": {
                return HSSFColor.HSSFColorPredefined.BROWN.getColor();
            }
            case "OLIVEGREEN": {
                return HSSFColor.HSSFColorPredefined.OLIVE_GREEN.getColor();
            }
            case "DARKGREEN": {
                return HSSFColor.HSSFColorPredefined.DARK_GREEN.getColor();
            }
            case "DARKTEAL": {
                return HSSFColor.HSSFColorPredefined.DARK_TEAL.getColor();
            }
            case "DARKBLUE": {
                return HSSFColor.HSSFColorPredefined.DARK_BLUE.getColor();
            }
            case "INDIGO": {
                return HSSFColor.HSSFColorPredefined.INDIGO.getColor();
            }
            case "GREY80PERCENT": {
                return HSSFColor.HSSFColorPredefined.GREY_80_PERCENT.getColor();
            }
            case "ORANGE": {
                return HSSFColor.HSSFColorPredefined.ORANGE.getColor();
            }
            case "DARKYELLOW": {
                return HSSFColor.HSSFColorPredefined.DARK_YELLOW.getColor();
            }
            case "GREEN": {
                return HSSFColor.HSSFColorPredefined.GREEN.getColor();
            }
            case "TEAL": {
                return HSSFColor.HSSFColorPredefined.TEAL.getColor();
            }
            case "BLUE": {
                return HSSFColor.HSSFColorPredefined.BLUE.getColor();
            }
            case "BLUEGREY": {
                return HSSFColor.HSSFColorPredefined.BLUE_GREY.getColor();
            }
            case "GREY50PERCENT": {
                return HSSFColor.HSSFColorPredefined.GREY_50_PERCENT.getColor();
            }
            case "RED": {
                return HSSFColor.HSSFColorPredefined.RED.getColor();
            }
            case "LIGHTORANGE": {
                return HSSFColor.HSSFColorPredefined.LIGHT_ORANGE.getColor();
            }
            case "LIME": {
                return HSSFColor.HSSFColorPredefined.LIME.getColor();
            }
            case "SEAGREEN": {
                return HSSFColor.HSSFColorPredefined.SEA_GREEN.getColor();
            }
            case "AQUA": {
                return HSSFColor.HSSFColorPredefined.AQUA.getColor();
            }
            case "LIGHTBLUE": {
                return HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getColor();
            }
            case "VIOLET": {
                return HSSFColor.HSSFColorPredefined.VIOLET.getColor();
            }
            case "GREY40PERCENT": {
                return HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getColor();
            }
            case "GOLD": {
                return HSSFColor.HSSFColorPredefined.GOLD.getColor();
            }
            case "YELLOW": {
                return HSSFColor.HSSFColorPredefined.YELLOW.getColor();
            }
            case "BRIGHTGREEN": {
                return HSSFColor.HSSFColorPredefined.BRIGHT_GREEN.getColor();
            }
            case "TURQUOISE": {
                return HSSFColor.HSSFColorPredefined.TURQUOISE.getColor();
            }
            case "DARKRED": {
                return HSSFColor.HSSFColorPredefined.DARK_RED.getColor();
            }
            case "SKYBLUE": {
                return HSSFColor.HSSFColorPredefined.SKY_BLUE.getColor();
            }
            case "PLUM": {
                return HSSFColor.HSSFColorPredefined.PLUM.getColor();
            }
            case "GREY25PERCENT": {
                return HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getColor();
            }
            case "ROSE": {
                return HSSFColor.HSSFColorPredefined.ROSE.getColor();
            }
            case "LIGHTYELLOW": {
                return HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getColor();
            }
            case "LIGHTGREEN": {
                return HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getColor();
            }
            case "LIGHTTURQUOISE": {
                return HSSFColor.HSSFColorPredefined.LIGHT_TURQUOISE.getColor();
            }
            case "PALEBLUE": {
                return HSSFColor.HSSFColorPredefined.PALE_BLUE.getColor();
            }
            case "LAVENDER": {
                return HSSFColor.HSSFColorPredefined.LAVENDER.getColor();
            }
            case "WHITE": {
                return HSSFColor.HSSFColorPredefined.WHITE.getColor();
            }
            case "CORNFLOWERBLUE": {
                return HSSFColor.HSSFColorPredefined.CORNFLOWER_BLUE.getColor();
            }
            case "LEMONCHIFFON": {
                return HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getColor();
            }
            case "MAROON": {
                return HSSFColor.HSSFColorPredefined.MAROON.getColor();
            }
            case "ORCHID": {
                return HSSFColor.HSSFColorPredefined.ORANGE.getColor();
            }
            case "CORAL": {
                return HSSFColor.HSSFColorPredefined.CORAL.getColor();
            }
            case "ROYALBLUE": {
                return HSSFColor.HSSFColorPredefined.ROYAL_BLUE.getColor();
            }
            case "LIGHTCORNFLOWERBLUE": {
                return HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getColor();
            }
            case "TAN": {
                return HSSFColor.HSSFColorPredefined.TAN.getColor();
            }
        }
        return null;
    }

    public static HSSFColor parseColor(HSSFWorkbook workBook, String color) {
        Color awtColor;
        HSSFColor poiColor = null;
        if (StringUtils.isNotBlank((CharSequence)color) && (awtColor = PoiCssUtils.getAwtColor(color)) != null) {
            int r = awtColor.getRed();
            int g = awtColor.getGreen();
            int b = awtColor.getBlue();
            HSSFPalette palette = workBook.getCustomPalette();
            poiColor = palette.findColor((byte)r, (byte)g, (byte)b);
            if (poiColor == null) {
                poiColor = palette.findSimilarColor(r, g, b);
            }
        }
        return poiColor;
    }

    private static Color getAwtColor(String color) {
        String tmpColor;
        HSSFColor hssfColor = PoiCssUtils.getHssfColor(color);
        if (hssfColor != null) {
            short[] t = hssfColor.getTriplet();
            return new Color(t[0], t[1], t[2]);
        }
        switch (tmpColor = color.replace("_", "").toLowerCase()) {
            case "lightgray": {
                return Color.LIGHT_GRAY;
            }
            case "gray": {
                return Color.GRAY;
            }
            case "darkgray": {
                return Color.DARK_GRAY;
            }
            case "pink": {
                return Color.PINK;
            }
            case "magenta": {
                return Color.MAGENTA;
            }
            case "cyan": {
                return Color.CYAN;
            }
        }
        return Color.decode(color);
    }

    public static XSSFColor parseColor(String color) {
        Color awtColor;
        XSSFColor poiColor = null;
        if (StringUtils.isNotBlank((CharSequence)color) && (awtColor = PoiCssUtils.getAwtColor(color)) != null) {
            poiColor = new XSSFColor(awtColor, null);
        }
        return poiColor;
    }

    private static String convertColor(int r, int g, int b) {
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static int calcColorValue(String color) {
        int rtn = 0;
        Matcher m = INT_AND_PER_PATTERN.matcher(color);
        if (m.matches()) {
            rtn = m.group(2) == null ? Math.round(Float.parseFloat(m.group(1))) % 256 : Math.round(Float.parseFloat(m.group(1)) * 255.0f / 100.0f) % 256;
        }
        return rtn;
    }
}

