/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.Iterator;
import java.util.List;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IBreeder;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.event.GeneticEvent;

public abstract class BreederBase
implements IBreeder {
    private static final String CVS_REVISION = "$Revision: 1.10 $";

    protected Population applyNaturalSelectors(Configuration a_config, Population a_pop, boolean a_processBeforeGeneticOperators) {
        boolean monitorActive = a_config.getMonitor() != null;
        try {
            int selectorSize = a_config.getNaturalSelectorsSize(a_processBeforeGeneticOperators);
            if (selectorSize > 0) {
                int population_size = a_config.getPopulationSize();
                population_size = (int)Math.round((double)population_size * a_config.getSelectFromPrevGen());
                Population new_population = new Population(a_config, population_size);
                for (int i = 0; i < selectorSize; ++i) {
                    NaturalSelector selector = a_config.getNaturalSelector(a_processBeforeGeneticOperators, i);
                    int single_selection_size = i == selectorSize - 1 && i > 0 ? population_size - new_population.size() : population_size / selectorSize;
                    if (monitorActive) {
                        a_config.getMonitor().event("before_select", a_config.getGenerationNr(), new Object[]{selector, a_pop, single_selection_size, a_processBeforeGeneticOperators});
                    }
                    selector.select(single_selection_size, a_pop, new_population);
                    if (monitorActive) {
                        a_config.getMonitor().event("after_select", a_config.getGenerationNr(), new Object[]{selector, a_pop, new_population, single_selection_size, a_processBeforeGeneticOperators});
                    }
                    selector.empty();
                }
                return new_population;
            }
            return a_pop;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex);
        }
    }

    protected void applyGeneticOperators(Configuration a_config, Population a_pop) {
        boolean monitorActive;
        List geneticOperators = a_config.getGeneticOperators();
        Iterator operatorIterator = geneticOperators.iterator();
        boolean bl = monitorActive = a_config.getMonitor() != null;
        while (operatorIterator.hasNext()) {
            GeneticOperator operator = (GeneticOperator)operatorIterator.next();
            a_config.getEventManager().fireGeneticEvent(new GeneticEvent("before_genetic_operator", new Object[]{this, operator}));
            if (monitorActive) {
                a_config.getMonitor().event("before_operate", a_config.getGenerationNr(), new Object[]{operator, a_pop, a_pop.getChromosomes()});
            }
            operator.operate(a_pop, a_pop.getChromosomes());
            if (monitorActive) {
                a_config.getMonitor().event("after_operate", a_config.getGenerationNr(), new Object[]{operator, a_pop, a_pop.getChromosomes()});
            }
            a_config.getEventManager().fireGeneticEvent(new GeneticEvent("after_genetic_operator", new Object[]{this, operator}));
        }
    }

    @Override
    public abstract Object clone();

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        return this.getClass().getName().compareTo(a_other.getClass().getName());
    }
}

