/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgap.audit.KeyedValues;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class KeyedValues2D
implements ICloneable,
Serializable {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private List m_rowKeys = Collections.synchronizedList(new ArrayList());
    private List m_columnKeys = Collections.synchronizedList(new ArrayList());
    private List m_rows = Collections.synchronizedList(new ArrayList());
    private boolean m_sortRowKeys;

    public KeyedValues2D() {
        this(false);
    }

    public KeyedValues2D(boolean a_sortRowKeys) {
        this.m_sortRowKeys = a_sortRowKeys;
    }

    public int getRowCount() {
        return this.m_rowKeys.size();
    }

    public int getColumnCount() {
        return this.m_columnKeys.size();
    }

    public Number getValue(int a_row, int a_column) {
        Number result = null;
        KeyedValues rowData = (KeyedValues)this.m_rows.get(a_row);
        Comparable columnKey = (Comparable)this.m_columnKeys.get(a_column);
        if (columnKey != null) {
            result = rowData.getValue(columnKey);
        }
        return result;
    }

    public Comparable getRowKey(int a_row) {
        return (Comparable)this.m_rowKeys.get(a_row);
    }

    public int getRowIndex(Comparable a_key) {
        if (this.m_sortRowKeys) {
            return Collections.binarySearch(this.m_rowKeys, a_key);
        }
        return this.m_rowKeys.indexOf(a_key);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.m_rowKeys);
    }

    public Comparable getColumnKey(int a_column) {
        return (Comparable)this.m_columnKeys.get(a_column);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.m_columnKeys);
    }

    public Number getValue(Comparable a_rowKey, Comparable a_columnKey) {
        Number result;
        int row = this.getRowIndex(a_rowKey);
        if (row >= 0) {
            KeyedValues rowData = (KeyedValues)this.m_rows.get(row);
            result = rowData.getValue(a_columnKey);
        } else {
            result = null;
        }
        return result;
    }

    public void setValue(Number a_value, Comparable a_rowKey, Comparable a_columnKey) {
        KeyedValues row;
        int rowIndex = this.getRowIndex(a_rowKey);
        if (rowIndex >= 0) {
            row = (KeyedValues)this.m_rows.get(rowIndex);
        } else {
            row = new KeyedValues();
            if (this.m_sortRowKeys) {
                rowIndex = -rowIndex - 1;
                this.m_rowKeys.add(rowIndex, a_rowKey);
                this.m_rows.add(rowIndex, row);
            } else {
                this.m_rowKeys.add(a_rowKey);
                this.m_rows.add(row);
            }
        }
        row.setValue(a_columnKey, a_value);
        int columnIndex = this.m_columnKeys.indexOf(a_columnKey);
        if (columnIndex < 0) {
            this.m_columnKeys.add(a_columnKey);
        }
    }

    public boolean equals(Object a_object) {
        if (a_object == null) {
            return false;
        }
        if (a_object == this) {
            return true;
        }
        if (!(a_object instanceof KeyedValues2D)) {
            return false;
        }
        KeyedValues2D kv2D = (KeyedValues2D)a_object;
        if (!this.getRowKeys().equals(kv2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(kv2D.getColumnKeys())) {
            return false;
        }
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                Number v1 = this.getValue(r, c);
                Number v2 = kv2D.getValue(r, c);
                if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.m_rowKeys.hashCode();
        result = 29 * result + this.m_columnKeys.hashCode();
        result = 31 * result + this.m_rows.hashCode();
        return result;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cex) {
            throw new CloneException(cex);
        }
    }
}

