/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr;

import org.jgap.Genotype;
import org.jgap.distr.IPopulationMerger;
import org.jgap.distr.MeanBuffer;

public abstract class Breeder
implements Runnable {
    private static final String CVS_REVISION = "$Revision: 1.13 $";
    private Breeder m_master;
    private Breeder[] m_workers;
    private Genotype m_genotype;
    private IPopulationMerger m_populationMerger;
    private transient boolean m_running;
    private transient boolean m_stopped = true;
    private transient MeanBuffer m_meanBuffer = new MeanBuffer(40);

    public Breeder(IPopulationMerger a_populationMerger) {
        this.m_populationMerger = a_populationMerger;
    }

    @Override
    public void run() {
        try {
            this.m_stopped = false;
            while (this.m_running) {
                this.evalOneGeneration();
                int sleepTime = this.m_meanBuffer.mean() / 100;
                if (sleepTime <= 0) {
                    this.pause(1);
                    continue;
                }
                this.pause(sleepTime);
            }
            this.m_stopped = true;
        }
        catch (Throwable t) {
            this.m_stopped = true;
            this.m_running = false;
        }
    }

    private void evalOneGeneration() throws Exception {
        long begin = System.currentTimeMillis();
        this.m_genotype.evolve(1);
        this.informParent();
        this.m_meanBuffer.add((int)(System.currentTimeMillis() - begin));
    }

    protected void informParent() {
    }

    private synchronized void pause(int a_milliSec) {
        try {
            this.wait(a_milliSec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        if (!this.m_running) {
            this.m_running = true;
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if (this.m_running) {
            this.m_running = false;
            if (this.m_genotype != null) {
                // empty if block
            }
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public boolean canBeStarted() {
        return !this.m_running;
    }

    public boolean canBeStopped() {
        return this.m_running;
    }
}

