/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.jgap.distr.grid.gp.JGAPGPXStream;
import org.jgap.distr.grid.request.Status;
import org.jgap.distr.grid.request.VersionInfo;
import org.jgap.gp.IGPProgram;
import org.jgap.util.FileKit;

public class GridKit {
    private static final String CVS_REVISION = "$Revision: 1.5 $";

    public static String ensureDirectory(String a_currentDir, String a_subDir, String a_descr) throws IOException {
        if (a_currentDir == null || a_currentDir.length() < 1) {
            String currentDir = FileKit.getCurrentDir();
            String workDir = FileKit.addSubDir(currentDir, a_subDir, true);
            File f = new File(workDir);
            if (!f.exists() && !f.mkdirs()) {
                throw new RuntimeException("Creation of " + a_descr + " " + workDir + " failed!");
            }
            return workDir;
        }
        return null;
    }

    public static URLConnection getConnection(String a_url) throws Exception {
        URL url1 = new URL(a_url);
        URL url = new URL(url1.toExternalForm());
        URLConnection con = url.openConnection();
        con.setUseCaches(false);
        con.setDoInput(true);
        con.setDoOutput(true);
        return con;
    }

    public static VersionInfo isUpdateAvailable(String BASE_URL, String a_moduleName, String currentVersion) throws Exception {
        String url = String.valueOf(BASE_URL) + "getVersion=" + a_moduleName;
        GridKit.addURLParameter(url, "version", currentVersion);
        URLConnection con = GridKit.getConnection(url);
        ObjectInputStream ois = new ObjectInputStream(con.getInputStream());
        VersionInfo result = (VersionInfo)ois.readObject();
        return result;
    }

    public static String addURLParameter(String a_requestURL, String a_key, long a_value) {
        String result = String.valueOf(a_requestURL) + "&" + a_key + "=" + a_value;
        return result;
    }

    public static String addURLParameter(String a_requestURL, String a_key, String a_value) {
        String result = String.valueOf(a_requestURL) + "&" + a_key + "=" + a_value;
        return result;
    }

    public static String retrieveModule(String BASE_URL, VersionInfo a_versionInfo, String a_destDir) throws Exception {
        String filename = a_versionInfo.filenameOfLib;
        if (!GridKit.getFile(BASE_URL, filename, a_destDir)) {
            return null;
        }
        return filename;
    }

    public static void updateModule(String a_filename, String a_workDir, String a_libDir) throws Exception {
        String libDir = a_libDir;
        String sourceFileName = String.valueOf(a_workDir) + a_filename;
        FileKit.copyFile(sourceFileName, libDir);
        FileKit.deleteFile(sourceFileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getFile(String BASE_URL, String a_sourceFilename, String a_targetDir) throws Exception {
        String filename = FileKit.getFilename(a_sourceFilename);
        String destFilename = String.valueOf(a_targetDir) + filename;
        File f = new File(destFilename);
        long offset = f.exists() ? f.length() : 0L;
        String a_url = String.valueOf(BASE_URL) + "download=";
        String requestURL = String.valueOf(a_url) + a_sourceFilename;
        requestURL = GridKit.addURLParameter(requestURL, "offset", offset);
        URL url1 = new URL(requestURL);
        URL url = new URL(url1.toExternalForm());
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setUseCaches(false);
        con.setDoOutput(true);
        boolean append = offset != 0L;
        InputStream in = con.getInputStream();
        ObjectInputStream sis = new ObjectInputStream(new BufferedInputStream(in, 5120));
        FileOutputStream fos = new FileOutputStream(destFilename, append);
        long currentOffset = 0L;
        try {
            Status s;
            int loopIndex = 0;
            do {
                s = (Status)sis.readObject();
                if (s.code == 0) {
                    if (loopIndex == 0 && (s.buffer == null || s.buffer.length < 1)) {
                        System.out.println("File already exists");
                        return true;
                    }
                } else if (s.code < 0) {
                    throw new IOException(s.description);
                }
                ++loopIndex;
                fos.write(s.buffer);
                currentOffset += (long)s.buffer.length;
            } while (s.code != 0);
        }
        catch (SocketException sex) {
            System.err.println("Connection to server lost - file transfer interrupted (resum possible)");
            sex.printStackTrace();
            fos.close();
            return false;
        }
        fos.close();
        System.out.println("File received: " + destFilename);
        return true;
    }

    public static void updateModuleLibrary(String BASE_URL, String a_moduleName, String a_libDir, String a_workDir) throws Exception {
        String currentVersion;
        boolean isCoreModule;
        String filename;
        if (a_moduleName.equalsIgnoreCase("evolutionDistributed")) {
            filename = "evdistr.jar";
            isCoreModule = false;
        } else if (a_moduleName.equalsIgnoreCase("jgap")) {
            filename = "jgap.jar";
            isCoreModule = true;
        } else if (a_moduleName.equalsIgnoreCase("rjgrid")) {
            filename = "rjgrid.zip";
            isCoreModule = true;
        } else {
            throw new IllegalArgumentException("Unknown module " + a_moduleName);
        }
        filename = String.valueOf(a_libDir) + filename;
        if (!FileKit.existsFile(filename)) {
            currentVersion = "none";
            System.out.println(" File not found: " + filename);
        } else if (isCoreModule) {
            currentVersion = FileKit.getVersionOfJGAP(filename);
        } else {
            currentVersion = FileKit.getVersionOfModule(filename);
            String string = FileKit.getVersionOfJGAP(filename);
        }
        VersionInfo versionInfo = GridKit.isUpdateAvailable(BASE_URL, a_moduleName, currentVersion);
        if (versionInfo.currentVersion == null) {
            System.out.println("Module " + a_moduleName + " is unknown");
            return;
        }
        if (!currentVersion.equals(versionInfo.currentVersion)) {
            System.out.println("Newer module " + a_moduleName + " with version " + versionInfo.currentVersion + " available");
            String workDir = a_workDir;
            filename = GridKit.retrieveModule(BASE_URL, versionInfo, workDir);
            if (filename != null) {
                GridKit.updateModule(filename, workDir, a_libDir);
            }
        } else {
            System.out.println("Module " + a_moduleName + " with version " + currentVersion + " is up-to-date");
        }
    }

    public static void updateJGAPLibrary(String BASE_URL, String a_libDir, String a_workDir) throws Exception {
        GridKit.updateModuleLibrary(BASE_URL, "jgap", a_libDir, a_workDir);
    }

    public static void main(String[] args) throws Exception {
        JGAPGPXStream xstream = new JGAPGPXStream();
        String dir = "D:\\JavaProjekte\\JGAP_CVS\\work\\storage\\ntb\\";
        String filename = "ntb_fitness_20080719180208812_12418.45";
        File f = new File(dir, filename);
        FileInputStream fis = new FileInputStream(f);
        IGPProgram result = (IGPProgram)xstream.fromXML(fis);
        String line = result.toStringNorm(0);
        Vector<String> v = new Vector<String>();
        v.add(line);
        GridKit.writeTextFile(v, String.valueOf(dir) + filename + ".gp");
        fis.close();
    }

    public static void writeTextFile(Vector zeilen, String dateiname) throws Exception {
        FileWriter fi = new FileWriter(dateiname, false);
        PrintWriter os = new PrintWriter(fi);
        int i = 0;
        while (i < zeilen.size()) {
            String s = (String)zeilen.elementAt(i);
            os.println(s);
            ++i;
        }
        os.close();
        if (os.checkError()) {
            throw new IOException("Fehler beim Schreiben der Textdatei " + dateiname);
        }
    }
}

