/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;

public class ADF
extends CommandGene {
    private static final String CVS_REVISION = "$Revision: 1.19 $";
    private int m_chromosomeNum;

    public ADF(GPConfiguration a_conf, int a_chromosomeNum, int a_arity) throws InvalidConfigurationException {
        super(a_conf, a_arity, null);
        this.m_chromosomeNum = a_chromosomeNum;
    }

    public int getChromosomeNum() {
        return this.m_chromosomeNum;
    }

    @Override
    public String toString() {
        String res = "ADF" + this.m_chromosomeNum + "(";
        int size = this.size();
        for (int i = 1; i <= size; ++i) {
            res = res + "&" + i;
            if (i >= size) continue;
            res = res + ",";
        }
        res = res + ")";
        return res;
    }

    @Override
    public int getArity(IGPProgram a_individual) {
        if (a_individual == null || a_individual.size() <= this.m_chromosomeNum) {
            return 0;
        }
        return a_individual.getChromosome(this.m_chromosomeNum).getArity();
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int numargs = c.getIndividual().getChromosome(this.m_chromosomeNum).getArity();
        Object[] vals = new Object[numargs];
        for (int i = 0; i < numargs; ++i) {
            vals[i] = new Integer(c.execute_int(n, i, args));
        }
        return c.getIndividual().execute_int(this.m_chromosomeNum, vals);
    }

    @Override
    public boolean execute_boolean(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int numargs = c.getIndividual().getChromosome(this.m_chromosomeNum).getArity();
        Object[] vals = new Object[numargs];
        for (int i = 0; i < numargs; ++i) {
            vals[i] = new Boolean(c.execute_boolean(n, i, args));
        }
        return c.getIndividual().execute_boolean(this.m_chromosomeNum, vals);
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int numargs = c.getIndividual().getChromosome(this.m_chromosomeNum).getArity();
        Object[] vals = new Object[numargs];
        for (int i = 0; i < numargs; ++i) {
            vals[i] = new Float(c.execute_float(n, i, args));
        }
        return c.getIndividual().execute_float(this.m_chromosomeNum, vals);
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int numargs = c.getIndividual().getChromosome(this.m_chromosomeNum).getArity();
        Object[] vals = new Object[numargs];
        for (int i = 0; i < numargs; ++i) {
            vals[i] = new Double(c.execute_double(n, i, args));
        }
        return c.getIndividual().execute_double(this.m_chromosomeNum, vals);
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int numargs = c.getIndividual().getChromosome(this.m_chromosomeNum).getArity();
        Object[] vals = new Object[numargs];
        for (int i = 0; i < numargs; ++i) {
            vals[i] = c.execute(n, i, args);
        }
        return c.getIndividual().execute_object(this.m_chromosomeNum, vals);
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int i) {
        return a_ind.getChromosome(this.m_chromosomeNum).getArgTypes()[i];
    }

    @Override
    public boolean isValid(ProgramChromosome a_chrom) {
        StackTraceElement[] stack = new Exception().getStackTrace();
        return stack.length <= 60;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ADF other = (ADF)a_other;
        return new CompareToBuilder().append(this.m_chromosomeNum, other.m_chromosomeNum).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            ADF other = (ADF)a_other;
            return super.equals(a_other) && new EqualsBuilder().append(this.m_chromosomeNum, other.m_chromosomeNum).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }
}

