/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Cosine
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.8 $";

    public Cosine(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 1, a_returnType);
    }

    @Override
    public String toString() {
        return "cosine &1";
    }

    @Override
    public String getName() {
        return "Cosine";
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        float f = c.execute_float(n, 0, args);
        return (float)Math.cos(Math.max(-10000.0f, Math.min(f, 10000.0f)));
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double d = c.execute_double(n, 0, args);
        return Math.cos(Math.max(-10000.0, Math.min(d, 10000.0)));
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        return ((Compatible)c.execute_object(n, 0, args)).execute_cosine();
    }

    @Override
    public Object clone() {
        try {
            Cosine result = new Cosine(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_cosine();
    }
}

