/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class If
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.9 $";
    private Class m_childType;

    public If(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType);
        this.m_childType = a_returnType;
    }

    public If(GPConfiguration a_conf, Class a_childType, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType);
        this.m_childType = a_childType;
    }

    @Override
    public Class getChildType(IGPProgram prog, int index) {
        if (index < 1) {
            return this.m_childType;
        }
        return this.getReturnType();
    }

    @Override
    public String toString() {
        return "if(&1) then (&2)";
    }

    @Override
    public boolean execute_boolean(ProgramChromosome c, int n, Object[] args) {
        boolean x = c.execute_boolean(n, 0, args);
        boolean value = false;
        if (x) {
            value = c.execute_boolean(n, 1, args);
        }
        return value;
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        boolean condition;
        if (this.m_childType == CommandGene.IntegerClass) {
            condition = c.execute_int(n, 0, args) > 0;
        } else if (this.m_childType == CommandGene.BooleanClass) {
            condition = c.execute_boolean(n, 0, args);
        } else if (this.m_childType == CommandGene.LongClass) {
            condition = c.execute_long(n, 0, args) > 0L;
        } else if (this.m_childType == CommandGene.DoubleClass) {
            condition = c.execute_double(n, 0, args) > 0.0;
        } else if (this.m_childType == CommandGene.FloatClass) {
            condition = c.execute_float(n, 0, args) > 0.0f;
        } else {
            throw new IllegalStateException("If: cannot process type " + this.m_childType);
        }
        int value = 0;
        if (condition) {
            value = c.execute_int(n, 1, args);
        }
        return value;
    }

    @Override
    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        long x = c.execute_long(n, 0, args);
        long value = 0L;
        if (x >= 0L) {
            value = c.execute_long(n, 1, args);
        }
        return value;
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        float x = c.execute_float(n, 0, args);
        float value = 0.0f;
        if (x >= 0.0f) {
            value = c.execute_float(n, 1, args);
        }
        return value;
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double x = c.execute_double(n, 0, args);
        double value = 0.0;
        if (x >= 0.0) {
            value = c.execute_double(n, 1, args);
        }
        return value;
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        int x = c.execute_int(n, 0, args);
        if (x >= 0) {
            c.execute_void(n, 1, args);
        }
    }

    @Override
    public Object clone() {
        try {
            If result = new If(this.getGPConfiguration(), this.getChildType(null, 0), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

