/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class IncrementMemory
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.6 $";
    private int m_increment;
    private String m_memoryName;
    private int m_initialValue;

    public IncrementMemory(GPConfiguration a_conf, Class a_returnType, String a_memoryName, int a_initialValue) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_memoryName, a_initialValue, 1);
    }

    public IncrementMemory(GPConfiguration a_conf, Class a_returnType, String a_memoryName, int a_initialValue, int a_increment) throws InvalidConfigurationException {
        super(a_conf, 0, a_returnType);
        this.m_increment = a_increment;
        this.m_memoryName = a_memoryName;
        this.m_initialValue = a_initialValue;
    }

    @Override
    public String toString() {
        if (this.m_increment == 1) {
            return "INCMEM(" + this.m_memoryName + ")";
        }
        return "INCMEM(" + this.m_memoryName + ", " + this.m_increment + ")";
    }

    @Override
    public String getName() {
        return "INCMEM(" + this.m_memoryName + ")";
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        Integer value = (Integer)this.getGPConfiguration().readFromMemoryIfExists(this.m_memoryName);
        int valueI = value == null ? this.m_initialValue : value + 1;
        this.getGPConfiguration().storeInMemory(this.m_memoryName, new Integer(valueI));
        return valueI;
    }

    @Override
    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        IncrementMemory other = (IncrementMemory)a_other;
        return new CompareToBuilder().append(this.m_increment, other.m_increment).append((Object)this.m_memoryName, (Object)other.m_memoryName).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        if (a_other == null) {
            return false;
        }
        try {
            IncrementMemory other = (IncrementMemory)a_other;
            return new EqualsBuilder().append(this.m_increment, other.m_increment).append((Object)this.m_memoryName, (Object)other.m_memoryName).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            IncrementMemory result = new IncrementMemory(this.getGPConfiguration(), this.getReturnType(), this.m_memoryName, this.m_initialValue, this.m_increment);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

