/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ReadFromMatrix
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private String m_matrixName;

    public ReadFromMatrix(GPConfiguration a_conf, String a_matrixName) throws InvalidConfigurationException {
        this(a_conf, a_matrixName, 0);
    }

    public ReadFromMatrix(GPConfiguration a_conf, String a_matrixName, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 2, CommandGene.CharacterClass, 0, new int[]{a_subChildType});
        if (a_matrixName == null || a_matrixName.length() < 1) {
            throw new IllegalArgumentException("Matrix name must not be empty!");
        }
        this.m_matrixName = a_matrixName;
    }

    @Override
    public String toString() {
        return "readFromMatrix(" + this.m_matrixName + ", &1, &2)";
    }

    @Override
    public String getName() {
        return "ReadFromMatrix(" + this.m_matrixName + ")";
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        int col = c.execute_int(n, 0, args);
        int row = c.execute_int(n, 1, args);
        return Character.valueOf(this.getGPConfiguration().readMatrix(this.m_matrixName, col, row));
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return CommandGene.IntegerClass;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ReadFromMatrix other = (ReadFromMatrix)a_other;
        return new CompareToBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append(this.getSubChildTypes(), other.getSubChildTypes()).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            ReadFromMatrix other = (ReadFromMatrix)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append(this.getSubChildTypes(), other.getSubChildTypes()).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            ReadFromMatrix result = new ReadFromMatrix(this.getGPConfiguration(), this.m_matrixName, this.getSubChildType(0));
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

