/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ReplaceInMatrix
extends CommandGene
implements ICloneable,
IMutateable {
    private static final String CVS_REVISION = "$Revision: 1.6 $";
    private String m_matrixName;
    private String m_targetCharacters;
    private char m_replacement;
    private ReplacementMode m_mode;

    public ReplaceInMatrix(GPConfiguration a_conf, String a_matrixName, ReplacementMode a_mode, String a_targetCharacters, char a_replacement) throws InvalidConfigurationException {
        this(a_conf, a_matrixName, a_mode, a_targetCharacters, a_replacement, 0);
    }

    public ReplaceInMatrix(GPConfiguration a_conf, String a_matrixName, ReplacementMode a_mode, String a_targetCharacters, char a_replacement, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.IntegerClass, 0, new int[]{a_subChildType});
        if (a_matrixName == null || a_matrixName.length() < 1) {
            throw new IllegalArgumentException("Matrix name must not be empty!");
        }
        this.m_matrixName = a_matrixName;
        this.m_mode = a_mode;
        this.m_targetCharacters = a_targetCharacters;
        this.m_replacement = a_replacement;
    }

    @Override
    public String toString() {
        return "replaceInMatrix(" + this.m_matrixName + ", '" + this.m_targetCharacters + "', '" + this.m_replacement + "')";
    }

    @Override
    public String getName() {
        return "ReplaceInMatrix(" + this.m_matrixName + ")";
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return CommandGene.IntegerClass;
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        int index = this.m_mode != ReplacementMode.MATRIX ? c.execute_int(n, 0, args) : 0;
        char[][] matrix = this.getGPConfiguration().getMatrix(this.m_matrixName);
        int count = 0;
        if (matrix != null) {
            int cols = matrix.length;
            if (index >= cols) {
                index = cols - 1;
            } else if (index < 0) {
                index = 0;
            }
            int rows = matrix[index].length;
            switch (this.m_mode) {
                case ROW: {
                    for (int col = 0; col < cols; ++col) {
                        this.replace(matrix[col][index]);
                    }
                    break;
                }
                case COLUMN: {
                    for (int row = 0; row < rows; ++row) {
                        this.replace(matrix[index][row]);
                    }
                    break;
                }
                case MATRIX: {
                    for (int col = 0; col < cols; ++col) {
                        for (int row = 0; row < rows; ++row) {
                            this.replace(matrix[col][row]);
                        }
                    }
                    break;
                }
                case DIAGONAL: {
                    if (cols != rows) {
                        throw new IllegalArgumentException("Cannot count diagonal of the matrix, as the matrix is not square");
                    }
                    if (index < cols / 2) {
                        for (int cell = 0; cell < cols; ++cell) {
                            this.replace(matrix[cell][cell]);
                        }
                    } else {
                        for (int cell = cols - 1; cell > 0; --cell) {
                            this.replace(matrix[cell][cell]);
                        }
                    }
                    break;
                }
            }
        }
        return count;
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.execute_int(c, n, args);
    }

    private char replace(char a_char) {
        if (this.m_targetCharacters.indexOf(a_char) >= 0) {
            return this.m_replacement;
        }
        return a_char;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ReplaceInMatrix other = (ReplaceInMatrix)a_other;
        return new CompareToBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append((Object)this.m_mode, (Object)other.m_mode).append((Object)this.m_targetCharacters, (Object)other.m_targetCharacters).append(this.m_replacement, other.m_replacement).append(this.getSubChildTypes(), other.getSubChildTypes()).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            ReplaceInMatrix other = (ReplaceInMatrix)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append((Object)this.m_mode, (Object)other.m_mode).append((Object)this.m_targetCharacters, (Object)other.m_targetCharacters).append(this.m_replacement, other.m_replacement).append(this.getSubChildTypes(), other.getSubChildTypes()).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            ReplaceInMatrix result = new ReplaceInMatrix(this.getGPConfiguration(), this.m_matrixName, this.m_mode, this.m_targetCharacters, this.m_replacement, this.getSubChildType(0));
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    @Override
    public CommandGene applyMutation(int index, double a_percentage) throws InvalidConfigurationException {
        int mode = this.getGPConfiguration().getRandomGenerator().nextInt(ReplacementMode.values().length);
        ReplaceInMatrix mutant = new ReplaceInMatrix(this.getGPConfiguration(), this.m_matrixName, ReplacementMode.values()[mode], this.m_targetCharacters, this.m_replacement, this.getSubChildType(0));
        return mutant;
    }

    public static enum ReplacementMode {
        COLUMN(1),
        ROW(2),
        DIAGONAL(3),
        MATRIX(4);

        private int m_value;

        public int intValue() {
            return this.m_value;
        }

        private ReplacementMode(int a_value) {
            this.m_value = a_value;
        }
    }
}

