/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class TransferMemory
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private String m_sourceStorageName;
    private String m_targetStorageName;

    public TransferMemory(GPConfiguration a_conf, String a_sourceStorageName, String a_targetStorageName) throws InvalidConfigurationException {
        super(a_conf, 0, CommandGene.VoidClass);
        if (a_sourceStorageName == null || a_sourceStorageName.length() < 1) {
            throw new IllegalArgumentException("Source memory name must not be empty!");
        }
        if (a_targetStorageName == null || a_targetStorageName.length() < 1) {
            throw new IllegalArgumentException("Target memory name must not be empty!");
        }
        if (a_sourceStorageName.equals(a_targetStorageName)) {
            throw new IllegalArgumentException("Source and target memory name must be different!");
        }
        this.m_sourceStorageName = a_sourceStorageName;
        this.m_targetStorageName = a_targetStorageName;
    }

    @Override
    public String toString() {
        return "transfer(" + this.m_sourceStorageName + " -> " + this.m_targetStorageName + ")";
    }

    @Override
    public String getName() {
        return "Transfer Memory";
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            Object value = this.getGPConfiguration().readFromMemory(this.m_sourceStorageName);
            this.getGPConfiguration().storeInMemory(this.m_targetStorageName, value);
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("TransferMemory without preceeding StoreTerminal");
        }
    }

    @Override
    public boolean isAffectGlobalState() {
        return true;
    }

    @Override
    public boolean isValid(ProgramChromosome a_program) {
        return true;
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return null;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        TransferMemory other = (TransferMemory)a_other;
        return new CompareToBuilder().append((Object)this.m_sourceStorageName, (Object)other.m_sourceStorageName).append((Object)this.m_targetStorageName, (Object)other.m_targetStorageName).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            TransferMemory other = (TransferMemory)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_sourceStorageName, (Object)other.m_sourceStorageName).append((Object)this.m_targetStorageName, (Object)other.m_targetStorageName).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            TransferMemory result = new TransferMemory(this.getGPConfiguration(), this.m_sourceStorageName, this.m_targetStorageName);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

