/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class WriteToMatrix
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.3 $";
    private String m_matrixName;

    public WriteToMatrix(GPConfiguration a_conf, String a_matrixName) throws InvalidConfigurationException {
        this(a_conf, a_matrixName, 0);
    }

    public WriteToMatrix(GPConfiguration a_conf, String a_matrixName, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 3, CommandGene.VoidClass, 0, new int[]{a_subChildType, a_subChildType, 0});
        if (a_matrixName == null || a_matrixName.length() < 1) {
            throw new IllegalArgumentException("Matrix name must not be empty!");
        }
        this.m_matrixName = a_matrixName;
    }

    public WriteToMatrix(GPConfiguration a_conf, String a_matrixName, int a_subChildType1, int a_subChildType2, int a_subChildType3) throws InvalidConfigurationException {
        super(a_conf, 3, CommandGene.VoidClass, 0, new int[]{a_subChildType1, a_subChildType2, a_subChildType3});
        if (a_matrixName == null || a_matrixName.length() < 1) {
            throw new IllegalArgumentException("Matrix name must not be empty!");
        }
        this.m_matrixName = a_matrixName;
    }

    @Override
    public String toString() {
        return "writeToMatrix(" + this.m_matrixName + ", &1, &2, &3)";
    }

    @Override
    public String getName() {
        return "WriteToMatrix(" + this.m_matrixName + ")";
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int row = c.execute_int(n, 1, args);
        int maxlen = this.getGPConfiguration().getMatrix(this.m_matrixName).length;
        if (row >= maxlen) {
            throw new IllegalStateException("Not valid: Row > " + (maxlen - 1));
        }
        int col = c.execute_int(n, 0, args);
        if (col >= (maxlen = this.getGPConfiguration().getMatrix(this.m_matrixName)[0].length)) {
            throw new IllegalStateException("Not valid: Col > " + (maxlen - 1));
        }
        int value = c.execute_int(n, 2, args);
        this.getGPConfiguration().setMatrix(this.m_matrixName, col, row, value);
    }

    @Override
    public boolean isAffectGlobalState() {
        return true;
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0 || a_chromNum == 1) {
            return CommandGene.IntegerClass;
        }
        return CommandGene.IntegerClass;
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        WriteToMatrix other = (WriteToMatrix)a_other;
        return new CompareToBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append(this.getSubChildTypes(), other.getSubChildTypes()).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            WriteToMatrix other = (WriteToMatrix)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_matrixName, (Object)other.m_matrixName).append(this.getSubChildTypes(), other.getSubChildTypes()).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            int[] subChilds = this.getSubChildTypes();
            WriteToMatrix result = new WriteToMatrix(this.getGPConfiguration(), this.m_matrixName, subChilds[0], subChilds[1], subChilds[2]);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

