/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function.statistics;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandDynamicArity;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Kurtosis
extends CommandDynamicArity
implements ICloneable {
    public Kurtosis(GPConfiguration a_conf, int a_arityInitial, int a_arityMin, int a_arityMax, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, a_arityInitial, a_arityMin, a_arityMax, a_returnType);
    }

    @Override
    public String toString() {
        String s = "Kurtosis(";
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                s = s + ";";
            }
            s = s + "&" + (i + 1);
        }
        return s + ")";
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        int size = this.size();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < size; ++i) {
            stats.addValue(c.execute_double(n, i, args));
        }
        return stats.getKurtosis();
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        int size = this.size();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < size; ++i) {
            stats.addValue((double)c.execute_float(n, i, args));
        }
        return (float)stats.getKurtosis();
    }

    @Override
    public String getName() {
        return "Kurtosis";
    }

    @Override
    public Object clone() {
        try {
            Kurtosis result = new Kurtosis(this.getGPConfiguration(), this.getArity(null), this.getArityMin(), this.getArityMax(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

