/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jgap.ICloneHandler;
import org.jgap.IInitializer;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.distr.grid.gp.IGPPopulationInitializer;
import org.jgap.event.GeneticEvent;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPFitnessEvaluator;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IPopulationCreator;
import org.jgap.gp.impl.DefaultPopulationCreator;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.gp.terminal.Variable;
import org.jgap.util.DateKit;
import org.jgap.util.NumberKit;
import org.jgap.util.SystemKit;

public class GPGenotype
implements Runnable,
Serializable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.60 $";
    private static transient Logger LOGGER = Logger.getLogger(GPGenotype.class);
    private GPPopulation m_population;
    private GPConfiguration m_configuration;
    private static transient GPConfiguration m_staticConfiguration;
    private double m_bestFitness;
    private double m_totalFitness;
    private IGPProgram m_allTimeBest;
    private double m_allTimeBestFitness;
    private boolean[] m_fullModeAllowed;
    private Class[] m_types;
    private Class[][] m_argTypes;
    private CommandGene[][] m_nodeSets;
    private int[] m_minDepths;
    private int[] m_maxDepths;
    private int m_maxNodes;
    private boolean m_verbose;
    private Map m_variables;
    private IGPProgram m_fittestToAdd;
    private boolean m_cloneWarningGPProgramShown;

    public GPGenotype() throws InvalidConfigurationException {
        this.init();
    }

    public GPGenotype(GPConfiguration a_configuration, GPPopulation a_population, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes) throws InvalidConfigurationException {
        this(a_configuration, a_population, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, null);
    }

    public GPGenotype(GPConfiguration a_configuration, GPPopulation a_population, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, IGPPopulationInitializer a_popCreator) throws InvalidConfigurationException {
        if (a_configuration == null) {
            throw new IllegalArgumentException("The configuration instance must not be null.");
        }
        this.setGPConfiguration(a_configuration);
        if (a_population == null) {
            throw new IllegalArgumentException("The population must not be null.");
        }
        this.setGPPopulation(a_population);
        if (a_popCreator != null) {
            GPGenotype gen = a_popCreator.execute();
            GPPopulation newPopulation = gen.getGPPopulation();
            if (a_configuration.getPopulationSize() >= a_population.size()) {
                IGPProgram[] programs = new IGPProgram[a_configuration.getPopulationSize()];
                System.arraycopy(newPopulation.getGPPrograms(), 0, programs, 0, newPopulation.getGPPrograms().length);
                a_population.setGPPrograms(programs);
            }
        }
        for (int i = 0; i < a_population.size(); ++i) {
            if (a_population.getGPProgram(i) != null) continue;
            throw new IllegalArgumentException("The GPProgram instance at index " + i + " in population" + " is null, which is forbidden in general.");
        }
        this.init();
        this.m_types = a_types;
        this.m_argTypes = a_argTypes;
        this.m_nodeSets = a_nodeSets;
        this.m_maxDepths = a_maxDepths;
        this.m_minDepths = a_minDepths;
        this.m_maxNodes = a_maxNodes;
        this.m_variables = new Hashtable();
        this.m_allTimeBestFitness = -1.0;
        this.getGPConfiguration().lockSettings();
    }

    protected void init() {
    }

    public static GPGenotype randomInitialGenotype(GPConfiguration a_conf, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int a_maxNodes, boolean a_verboseOutput) throws InvalidConfigurationException {
        int[] minDepths = null;
        int[] maxDepths = null;
        return GPGenotype.randomInitialGenotype(a_conf, a_types, a_argTypes, a_nodeSets, minDepths, maxDepths, a_maxNodes, a_verboseOutput);
    }

    public static GPGenotype randomInitialGenotype(GPConfiguration a_conf, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, boolean a_verboseOutput) throws InvalidConfigurationException {
        boolean[] fullModeAllowed = new boolean[a_types.length];
        for (int i = 0; i < a_types.length; ++i) {
            fullModeAllowed[i] = true;
        }
        return GPGenotype.randomInitialGenotype(a_conf, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, fullModeAllowed, a_verboseOutput);
    }

    public static GPGenotype randomInitialGenotype(GPConfiguration a_conf, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, boolean[] a_fullModeAllowed, boolean a_verboseOutput) throws InvalidConfigurationException {
        return GPGenotype.randomInitialGenotype(a_conf, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, a_fullModeAllowed, a_verboseOutput, new DefaultPopulationCreator());
    }

    public static GPGenotype randomInitialGenotype(GPConfiguration a_conf, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, boolean[] a_fullModeAllowed, boolean a_verboseOutput, IPopulationCreator a_popCreator) throws InvalidConfigurationException {
        if (a_argTypes.length != a_fullModeAllowed.length || a_minDepths != null && a_argTypes.length != a_minDepths.length || a_maxDepths != null && a_argTypes.length != a_maxDepths.length || a_argTypes.length != a_types.length) {
            throw new IllegalArgumentException("a_argTypes must have same length as a_types, a_minDepths, a_maxDepths and a_fullModeAllowed");
        }
        if (a_conf.getPopulationSize() < 1) {
            throw new IllegalArgumentException("Set the population size in the configuration!");
        }
        System.gc();
        if (a_verboseOutput) {
            LOGGER.info((Object)"Creating initial population");
            LOGGER.info((Object)("Mem free: " + SystemKit.niceMemory(SystemKit.getTotalMemoryMB()) + " MB"));
        }
        GPPopulation pop = new GPPopulation(a_conf, a_conf.getPopulationSize());
        try {
            a_popCreator.initialize(pop, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, a_fullModeAllowed);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException(ex);
        }
        System.gc();
        if (a_verboseOutput) {
            LOGGER.info((Object)("Mem free after creating population: " + SystemKit.niceMemory(SystemKit.getTotalMemoryMB()) + " MB"));
        }
        GPGenotype.checkErroneousPop(pop, " after creating population/2");
        Map<String, CommandGene> invalidNodes = GPGenotype.verifyChildNodes(a_conf, a_types, a_nodeSets);
        GPGenotype.outputWarning(invalidNodes);
        Map<CommandGene, int[]> invalidDepthNodes = GPGenotype.verifyDepthsForNodes(pop, a_conf, a_types, a_minDepths, a_maxDepths, a_maxNodes, a_nodeSets);
        GPGenotype.outputDepthInfo(invalidDepthNodes);
        GPGenotype gp = new GPGenotype(a_conf, pop, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes);
        gp.m_fullModeAllowed = a_fullModeAllowed;
        for (String varName : gp.m_variables.keySet()) {
            Variable var = (Variable)gp.m_variables.get(varName);
            a_conf.putVariable(var);
        }
        GPGenotype.checkErroneousPop(gp.getGPPopulation(), " after creating population/2");
        return gp;
    }

    public GPConfiguration getGPConfiguration() {
        return this.m_configuration;
    }

    public static GPConfiguration getStaticGPConfiguration() {
        return m_staticConfiguration;
    }

    public static void setStaticGPConfiguration(GPConfiguration a_configuration) {
        m_staticConfiguration = a_configuration;
    }

    public void evolve(int a_evolutions) {
        int offset = this.getGPConfiguration().getGenerationNr();
        int evolutions = a_evolutions < 0 ? Integer.MAX_VALUE : a_evolutions;
        for (int i = 0; i < evolutions; ++i) {
            if (this.m_verbose && i % 25 == 0) {
                String freeMB = SystemKit.niceMemory(SystemKit.getFreeMemoryMB());
                LOGGER.info((Object)("Evolving generation " + (i + offset) + ", memory free: " + freeMB + " MB"));
            }
            this.evolve();
            this.calcFitness();
        }
    }

    public void calcFitness() {
        double totalFitness = 0.0;
        GPPopulation pop = this.getGPPopulation();
        IGPProgram best = null;
        IGPFitnessEvaluator evaluator = this.getGPConfiguration().getGPFitnessEvaluator();
        this.m_bestFitness = -1.0;
        boolean bestPreserved = false;
        for (int i = 0; i < pop.size() && pop.getGPProgram(i) != null; ++i) {
            double fitness;
            IGPProgram program = pop.getGPProgram(i);
            try {
                fitness = program.getFitnessValue();
            }
            catch (IllegalStateException iex) {
                fitness = Double.NaN;
            }
            if (Double.isInfinite(fitness) || Double.isNaN(fitness)) continue;
            if (best == null || evaluator.isFitter(fitness, this.m_bestFitness)) {
                best = program;
                this.m_bestFitness = fitness;
                if (this.m_allTimeBest != null && !bestPreserved && best.toStringNorm(0).equals(this.m_allTimeBest.toStringNorm(0))) {
                    bestPreserved = true;
                }
            }
            totalFitness += fitness;
        }
        this.m_totalFitness = totalFitness;
        best = pop.determineFittestProgram();
        if (best != null) {
            this.m_bestFitness = best.getFitnessValue();
            if (this.m_allTimeBest == null || evaluator.isFitter(this.m_bestFitness, this.m_allTimeBestFitness)) {
                pop.setChanged(true);
                try {
                    ICloneHandler cloner = this.getGPConfiguration().getJGAPFactory().getCloneHandlerFor(best, null);
                    if (cloner == null) {
                        this.m_allTimeBest = best;
                        if (!this.m_cloneWarningGPProgramShown) {
                            LOGGER.info((Object)("Warning: cannot clone instance of " + best.getClass()));
                            this.m_cloneWarningGPProgramShown = true;
                        }
                    } else {
                        this.m_allTimeBest = (IGPProgram)cloner.perform(best, null, null);
                    }
                }
                catch (Exception ex) {
                    this.m_allTimeBest = best;
                    ex.printStackTrace();
                }
                this.m_allTimeBestFitness = this.m_bestFitness;
                try {
                    this.getGPConfiguration().getEventManager().fireGeneticEvent(new GeneticEvent("gpgenotype_best_solution", this));
                }
                catch (IllegalArgumentException iex) {
                    iex.printStackTrace();
                }
                if (this.m_verbose) {
                    this.outputSolution(this.m_allTimeBest);
                }
            }
        }
        if (!bestPreserved && this.m_allTimeBest != null) {
            this.addFittestProgram(this.m_allTimeBest);
        }
    }

    public IGPProgram getAllTimeBest() {
        return this.m_allTimeBest;
    }

    public void outputSolution(IGPProgram a_best) {
        if (a_best == null) {
            LOGGER.debug((Object)"No best solution (null)");
            return;
        }
        double bestValue = a_best.getFitnessValue();
        if (Double.isInfinite(bestValue)) {
            LOGGER.debug((Object)"No best solution (infinite)");
            return;
        }
        LOGGER.info((Object)("Best solution fitness: " + NumberKit.niceDecimalNumber(bestValue, 2)));
        LOGGER.info((Object)("Best solution: " + a_best.toStringNorm(0)));
        String depths = "";
        int size = a_best.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                depths = depths + " / ";
            }
            depths = depths + a_best.getChromosome(i).getDepth(0);
        }
        if (size == 1) {
            LOGGER.info((Object)("Depth of chrom: " + depths));
        } else {
            LOGGER.info((Object)("Depths of chroms: " + depths));
        }
    }

    public void evolve() {
        try {
            IGPProgram program;
            int i;
            int popSize = this.getGPConfiguration().getPopulationSize();
            GPPopulation oldPop = this.getGPPopulation();
            GPPopulation newPopulation = new GPPopulation(oldPop, false);
            if (this.m_fittestToAdd != null) {
                newPopulation.addFittestProgram(this.m_fittestToAdd);
                this.m_fittestToAdd = null;
            }
            RandomGenerator random = this.getGPConfiguration().getRandomGenerator();
            GPConfiguration conf = this.getGPConfiguration();
            int popSize1 = (int)Math.round((double)popSize * (1.0 - conf.getNewChromsPercent()));
            double crossProb = conf.getCrossoverProb() / (conf.getCrossoverProb() + conf.getReproductionProb());
            int crossover = 0;
            int reproduction = 0;
            int creation = 0;
            GPGenotype.checkErroneousPop(this.getGPPopulation(), " (before evolution)", true);
            int maxTries = this.getGPConfiguration().getProgramCreationMaxtries();
            block10: for (i = 0; i < popSize1; ++i) {
                this.getGPConfiguration().clearStack();
                float val = random.nextFloat();
                if (i < popSize - 1 && (double)val < crossProb) {
                    ++crossover;
                    IGPProgram i1 = conf.getSelectionMethod().select(this);
                    IGPProgram i2 = conf.getSelectionMethod().select(this);
                    int tries = 0;
                    while (true) {
                        try {
                            GPGenotype.checkErroneousProg(i1, " at start of evolution (index " + i + "/01)", false);
                            if (i1 != i2) {
                                GPGenotype.checkErroneousProg(i2, " at start of evolution (index " + i + "/02)", false);
                                IGPProgram[] newIndividuals = conf.getCrossMethod().operate(i1, i2);
                                newPopulation.setGPProgram(i, newIndividuals[0]);
                                newPopulation.setGPProgram(i + 1, newIndividuals[1]);
                                try {
                                    GPGenotype.checkErroneousProg(newIndividuals[0], " at start of evolution (index " + i + "/11)", false);
                                }
                                catch (RuntimeException t) {
                                    this.writeToFile(i1, i2, newIndividuals[0], "Error in first X-over program");
                                    throw t;
                                }
                                try {
                                    GPGenotype.checkErroneousProg(newIndividuals[1], " at start of evolution (index " + i + "/12)", false);
                                }
                                catch (RuntimeException t) {
                                    this.writeToFile(i1, i2, newIndividuals[1], "Error in second X-over program");
                                    throw t;
                                }
                            }
                            newPopulation.setGPProgram(i, i1);
                            newPopulation.setGPProgram(i + 1, i2);
                            ++i;
                            continue block10;
                        }
                        catch (IllegalStateException iex) {
                            if ((maxTries <= 0 || ++tries < maxTries) && tries <= 40) continue;
                            if (!this.getGPConfiguration().isMaxNodeWarningPrinted()) {
                                LOGGER.error((Object)"Warning: Maximum number of nodes allowed may be too small");
                                this.getGPConfiguration().flagMaxNodeWarningPrinted();
                            }
                            if ((program = this.cloneProgram(this.getGPConfiguration().getPrototypeProgram())) != null) {
                                newPopulation.setGPProgram(i++, program);
                                program = this.cloneProgram(this.getGPConfiguration().getPrototypeProgram());
                                newPopulation.setGPProgram(i, program);
                                continue block10;
                            }
                            throw new IllegalStateException(iex.getMessage());
                        }
                        break;
                    }
                }
                ++reproduction;
                newPopulation.setGPProgram(i, conf.getSelectionMethod().select(this));
            }
            block12: for (i = popSize1; i < popSize; ++i) {
                ++creation;
                int depth = conf.getMinInitDepth() + random.nextInt(conf.getMaxInitDepth() - conf.getMinInitDepth() + 1);
                int tries = 0;
                int nogc = 0;
                while (true) {
                    try {
                        boolean grow = i % 2 == 0 || random.nextInt(8) > 6;
                        program = newPopulation.create(i, this.m_types, this.m_argTypes, this.m_nodeSets, this.m_minDepths, this.m_maxDepths, depth, grow, this.m_maxNodes, this.m_fullModeAllowed, tries);
                        newPopulation.setGPProgram(i, program);
                        GPGenotype.checkErroneousProg(program, " when adding a program, evolution (index " + i + ")", true);
                        LOGGER.debug((Object)("Added new GP program (depth parameter: " + depth + ", " + tries + " tries)"));
                        continue block12;
                    }
                    catch (IllegalStateException iex) {
                        ++nogc;
                        if (maxTries > 0 && ++tries > maxTries || tries > 40) {
                            LOGGER.debug((Object)("Creating random GP program failed (depth " + depth + ", " + tries + " tries), will use prototype"));
                            program = this.cloneProgram(this.getGPConfiguration().getPrototypeProgram());
                            if (program != null) {
                                newPopulation.setGPProgram(i, program);
                                continue block12;
                            }
                            if (this.getGPConfiguration().getPrototypeProgram() == null) {
                                throw new IllegalStateException("Cloning: Prototype program was null");
                            }
                            throw new IllegalStateException("Cloning of prototype program failed, " + iex.getMessage());
                        }
                        if (nogc <= 5) continue;
                        nogc = 0;
                        System.gc();
                        continue;
                    }
                    break;
                }
            }
            LOGGER.debug((Object)("Did " + crossover + " x-overs, " + reproduction + " reproductions, " + creation + " creations"));
            this.setGPPopulation(newPopulation);
            conf.incrementGenerationNr();
            conf.getEventManager().fireGeneticEvent(new GeneticEvent("gpgenotype_evolved_event", this));
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public GPPopulation getGPPopulation() {
        return this.m_population;
    }

    public double getTotalFitness() {
        return this.m_totalFitness;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.currentThread();
                if (!Thread.interrupted()) {
                    this.evolve();
                    this.calcFitness();
                    System.gc();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized IGPProgram getFittestProgram() {
        IGPProgram fittestPop = this.getGPPopulation().determineFittestProgram();
        if (fittestPop == null) {
            return this.m_allTimeBest;
        }
        double fittest = this.m_allTimeBest != null ? this.m_allTimeBest.getFitnessValue() : -1.0;
        if (this.m_allTimeBest != null && this.getGPConfiguration().getGPFitnessEvaluator().isFitter(fittest, fittestPop.getFitnessValue())) {
            return this.m_allTimeBest;
        }
        this.m_allTimeBest = null;
        return fittestPop;
    }

    public synchronized IGPProgram getFittestProgramComputed() {
        return this.getGPPopulation().determineFittestProgramComputed();
    }

    protected void setGPPopulation(GPPopulation a_pop) {
        this.m_population = a_pop;
    }

    public void setGPConfiguration(GPConfiguration a_configuration) {
        this.m_configuration = a_configuration;
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int compareTo(Object a_other) {
        try {
            int size2;
            if (a_other == null) {
                return 1;
            }
            GPGenotype otherGenotype = (GPGenotype)a_other;
            int size1 = this.getGPPopulation().size();
            if (size1 != (size2 = otherGenotype.getGPPopulation().size())) {
                if (size1 > size2) {
                    return 1;
                }
                return -1;
            }
            Arrays.sort(this.getGPPopulation().getGPPrograms());
            Arrays.sort(otherGenotype.getGPPopulation().getGPPrograms());
            for (int i = 0; i < this.getGPPopulation().size(); ++i) {
                int result = this.getGPPopulation().getGPProgram(i).compareTo(otherGenotype.getGPPopulation().getGPProgram(i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    public int hashCode() {
        int size = this.getGPPopulation().size();
        int twopower = 1;
        int localHashCode = -573;
        int i = 0;
        while (i < size) {
            IGPProgram prog = this.getGPPopulation().getGPProgram(i);
            localHashCode = 31 * localHashCode + prog.hashCode();
            ++i;
            twopower = 2 * twopower;
        }
        return localHashCode;
    }

    public void setVerboseOutput(boolean a_verbose) {
        this.m_verbose = a_verbose;
    }

    private IGPProgram cloneProgram(IGPProgram a_original) {
        IGPProgram validProgram = a_original;
        ICloneHandler cloner = this.getGPConfiguration().getJGAPFactory().getCloneHandlerFor(validProgram, null);
        if (cloner != null) {
            try {
                IGPProgram program = (IGPProgram)cloner.perform(validProgram, null, null);
                return program;
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public void putVariable(Variable a_var) {
        this.m_variables.put(a_var.getName(), a_var);
    }

    public Variable getVariable(String a_varName) {
        return (Variable)this.m_variables.get(a_varName);
    }

    public void addFittestProgram(IGPProgram a_toAdd) {
        if (a_toAdd != null) {
            this.m_fittestToAdd = a_toAdd;
        }
    }

    public void fillPopulation(int a_num) throws InvalidConfigurationException {
        IGPProgram sampleProg = this.getGPConfiguration().getPrototypeProgram();
        if (sampleProg == null) {
            // empty if block
        }
        Class<?> sampleClass = sampleProg.getClass();
        IInitializer chromIniter = this.getGPConfiguration().getJGAPFactory().getInitializerFor(sampleProg, sampleClass);
        if (chromIniter == null) {
            throw new InvalidConfigurationException("No initializer found for class " + sampleClass);
        }
        try {
            for (int i = 0; i < a_num; ++i) {
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void checkErroneousPop(GPPopulation pop, String s) {
        GPGenotype.checkErroneousPop(pop, s, false);
    }

    public static void checkErroneousPop(GPPopulation a_pop, String a_s, boolean a_clearFitness) {
        if (a_pop == null) {
            return;
        }
        GPGenotype.checkErroneousPop(a_pop, a_s, a_clearFitness, a_pop.getGPConfiguration().isVerifyPrograms());
    }

    public static void checkErroneousPop(GPPopulation a_pop, String a_s, boolean a_clearFitness, boolean a_active) {
        if (a_pop == null) {
            return;
        }
        if (!a_active) {
            return;
        }
        int popSize1 = a_pop.size();
        for (int i = 0; i < popSize1; ++i) {
            IGPProgram a_prog = a_pop.getGPProgram(i);
            GPGenotype.checkErroneousProg(a_prog, a_s, a_clearFitness, a_active);
        }
    }

    public static void checkErroneousProg(IGPProgram prog, String s) {
        GPGenotype.checkErroneousProg(prog, s, false);
    }

    public static void checkErroneousProg(IGPProgram a_prog, String a_s, boolean a_clearFitness) {
        if (a_prog == null) {
            return;
        }
        GPGenotype.checkErroneousProg(a_prog, a_s, a_clearFitness, a_prog.getGPConfiguration().isVerifyPrograms());
    }

    public static void checkErroneousProg(IGPProgram a_prog, String s, boolean a_clearFitness, boolean a_active) {
        if (a_prog == null) {
            return;
        }
        if (!a_active) {
            return;
        }
        if (a_clearFitness) {
            a_prog.setFitnessValue(-1.0);
        }
        try {
            a_prog.getFitnessValue();
        }
        catch (Throwable ex) {
            String msg = "Invalid program detected" + s + "!";
            LOGGER.fatal((Object)msg);
            throw new RuntimeException(msg, ex);
        }
    }

    private void writeToFile(IGPProgram i1, IGPProgram i2, IGPProgram inew, String header) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(header);
            sb.append("First Program to cross over\n");
            sb.append(this.getProgramString(i1));
            sb.append("\nSecond Program to cross over\n");
            sb.append(this.getProgramString(i2));
            sb.append("\nResulting Program after cross over\n");
            sb.append(this.getProgramString(inew));
            String filename = DateKit.getNowAsString();
            File f = new File(filename);
            FileWriter fw = new FileWriter(f);
            fw.write(sb.toString());
            fw.close();
        }
        catch (IOException iex) {
            System.out.println(sb.toString());
            iex.printStackTrace();
        }
    }

    private StringBuffer getProgramString(IGPProgram i1) {
        int size = i1.size();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            ProgramChromosome chrom = i1.getChromosome(i);
            result.append("Chromosome " + i + ", class " + chrom.getClass() + "\n");
            int size2 = chrom.size();
            for (int j = 0; j < size2; ++j) {
                CommandGene gene = chrom.getGene(j);
                result.append("Gene " + j + ", class " + gene.getClass() + ", toString: " + gene.toString() + " \n");
            }
        }
        return result;
    }

    public static Map<String, CommandGene> verifyChildNodes(GPConfiguration a_conf, Class[] a_types, CommandGene[][] a_nodeSets) {
        Hashtable<String, CommandGene> invalidNodes = new Hashtable<String, CommandGene>();
        for (int i = 0; i < a_nodeSets.length; ++i) {
            Vector<CommandGene> triedNodes = new Vector<CommandGene>();
            block1: for (int j = 0; j < a_nodeSets[i].length; ++j) {
                int[] subChildTypes;
                Class[] childTypes;
                CommandGene node = a_nodeSets[i][j];
                if (triedNodes.contains(node)) continue;
                triedNodes.add(node);
                int arity = node.getArity(null);
                if (arity > 0) {
                    int k;
                    childTypes = new Class[arity];
                    for (k = 0; k < arity; ++k) {
                        childTypes[k] = node.getChildType(null, k);
                    }
                    if (node.getSubChildTypes() != null) {
                        subChildTypes = new int[arity];
                        for (k = 0; k < arity; ++k) {
                            subChildTypes[k] = node.getSubChildType(k);
                        }
                    } else {
                        subChildTypes = new int[arity];
                    }
                } else {
                    childTypes = null;
                    subChildTypes = null;
                }
                if (arity <= 0) continue;
                for (int l = 0; l < arity; ++l) {
                    if (GPGenotype.nodeExists(a_nodeSets[i], childTypes[l], subChildTypes[l])) continue;
                    String s = i + "," + j;
                    invalidNodes.put(s, node);
                    continue block1;
                }
            }
        }
        return invalidNodes;
    }

    protected static boolean nodeExists(CommandGene[] a_functionSet, Class a_returnType, int a_subReturnType) {
        for (int i = 0; i < a_functionSet.length; ++i) {
            if (a_functionSet[i].getReturnType() != a_returnType || a_subReturnType != 0 && a_subReturnType != a_functionSet[i].getSubReturnType()) continue;
            return true;
        }
        return false;
    }

    protected static void outputWarning(Map<String, CommandGene> invalidNodes) {
        if (invalidNodes != null && invalidNodes.size() > 0) {
            LOGGER.warn((Object)"Your configuration contains commands that are not used:");
            for (CommandGene node : invalidNodes.values()) {
                LOGGER.warn((Object)(" " + node.getClass().getName()));
            }
        } else {
            LOGGER.info((Object)"Your configuration does not contain unused commands, this is good");
        }
    }

    protected static void outputDepthInfo(Map<CommandGene, int[]> a_invalidDepths) {
        if (a_invalidDepths != null && a_invalidDepths.size() > 0) {
            LOGGER.info((Object)"Your configuration contains commands that are not possiblefor certain depths: ");
            for (CommandGene node : a_invalidDepths.keySet()) {
                LOGGER.info((Object)(" " + node.getClass().getName()));
                int[] depths = a_invalidDepths.get(node);
                String s = "";
                for (int i = 0; i < depths.length; ++i) {
                    if (i > 0) {
                        s = s + ", ";
                    }
                    s = s + depths[i];
                }
                LOGGER.info((Object)("   Impossible depths: " + s));
            }
        }
    }

    public static Map<CommandGene, int[]> verifyDepthsForNodes(GPPopulation a_pop, GPConfiguration a_conf, Class[] a_types, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, CommandGene[][] a_nodeSets) {
        Hashtable<CommandGene, int[]> impossibleDepths = new Hashtable<CommandGene, int[]>();
        for (int i = 0; i < a_nodeSets.length; ++i) {
            for (int j = 0; j < a_nodeSets[i].length; ++j) {
                CommandGene nodeToCheck = a_nodeSets[i][j];
                Vector<CommandGene> triedNodes = new Vector<CommandGene>();
                Vector<CommandGene> possibleNodes = new Vector<CommandGene>();
                for (int k = 0; k < a_nodeSets[i].length; ++k) {
                    CommandGene nodeInQuestion = a_nodeSets[i][k];
                    if (triedNodes.contains(nodeInQuestion)) continue;
                    boolean valid = false;
                    for (int l = 0; l < nodeToCheck.size(); ++l) {
                        IGPProgram ind = a_pop.getGPProgram(0);
                        if (nodeInQuestion.getReturnType() != nodeToCheck.getChildType(ind, l) || nodeInQuestion.getSubReturnType() != 0 && nodeInQuestion.getSubReturnType() != nodeToCheck.getSubChildType(l)) continue;
                        valid = true;
                        break;
                    }
                    if (valid) {
                        possibleNodes.add(nodeInQuestion);
                    }
                    triedNodes.add(nodeInQuestion);
                }
            }
        }
        return impossibleDepths;
    }

    static class GPFitnessComparator
    implements Comparator {
        GPFitnessComparator() {
        }

        public int compare(Object o1, Object o2) {
            double f2;
            if (!(o1 instanceof IGPProgram) || !(o2 instanceof IGPProgram)) {
                throw new ClassCastException("FitnessComparator must operate on IGPProgram instances");
            }
            double f1 = ((IGPProgram)o1).getFitnessValue();
            if (f1 > (f2 = ((IGPProgram)o2).getFitnessValue())) {
                return 1;
            }
            if (Math.abs(f1 - f2) < 1.0E-6) {
                return 0;
            }
            return -1;
        }
    }
}

