/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.jgap.gp.impl.ProgramChromosome;

public class JGAPTreeNode
implements TreeNode {
    private static final String CVS_REVISION = "$Revision: 1.3 $";
    private ProgramChromosome m_chrom;
    private int m_index;

    public JGAPTreeNode(ProgramChromosome a_chrom, int a_index) {
        this.m_chrom = a_chrom;
        this.m_chrom.redepth();
        this.m_index = a_index;
    }

    public String getName() {
        return this.m_chrom.getFunctions()[this.m_index].getClass().getName();
    }

    @Override
    public TreeNode getChildAt(int a_childIndex) {
        int child = this.m_chrom.getChild(this.m_index, a_childIndex);
        return new JGAPTreeNode(this.m_chrom, child);
    }

    @Override
    public int getChildCount() {
        int count = 0;
        try {
            while (true) {
                if (this.m_chrom.getChild(this.m_index, count) < 0) {
                    return count;
                }
                ++count;
            }
        }
        catch (RuntimeException rex) {
            return count;
        }
    }

    @Override
    public TreeNode getParent() {
        return new JGAPTreeNode(this.m_chrom, this.m_chrom.getParentNode(this.m_index));
    }

    @Override
    public int getIndex(TreeNode a_node) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChildAt(i).equals(a_node)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.getChildCount() > 0;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        Vector<TreeNode> l = new Vector<TreeNode>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            l.add(this.getChildAt(i));
        }
        return l.elements();
    }
}

