/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gui;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jgap.data.config.ConfigData;
import org.jgap.data.config.ConfigProperty;
import org.jgap.data.config.ConfigWriter;
import org.jgap.data.config.Configurable;
import org.jgap.data.config.IConfigInfo;
import org.jgap.data.config.MetaConfig;
import org.jgap.data.config.MetaConfigException;
import org.jgap.gui.GUIManager;

public class ConfigFrame
extends JFrame
implements IConfigInfo {
    private static final String CVS_REVISION = "$Revision: 1.19 $";
    private Object m_conHandler;
    private boolean m_isRoot;
    private List m_panels = Collections.synchronizedList(new ArrayList());
    private List m_listProps;
    private List m_textProps = Collections.synchronizedList(new ArrayList());
    private List m_listGroups;
    private List m_textGroups;
    private JPanel m_listPanel;
    private JPanel m_textPanel;
    private JPanel m_configPanel;
    private JButton m_configButton;
    private ConfigButtonListener m_cbl;
    private JTextField m_fileName;
    private JButton m_configureButton;
    private JTextField m_configItem;
    private Configurable m_conObj;
    private ConfigFrame m_parent;
    private static final String m_defaultConfigFile = "jgap.con";

    ConfigFrame(ConfigFrame a_parent, String a_title, boolean a_isRoot) {
        super(a_title);
        this.m_listProps = Collections.synchronizedList(new ArrayList());
        this.m_listGroups = Collections.synchronizedList(new ArrayList());
        this.m_textGroups = Collections.synchronizedList(new ArrayList());
        this.m_cbl = new ConfigButtonListener(this);
        this.m_isRoot = a_isRoot;
        this.m_parent = a_parent;
    }

    public void createAndShowGUI(Object a_conHandler) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.m_conHandler = a_conHandler;
        this.pack();
        this.setVisible(true);
        this.setBounds(100, 100, 300, 300);
        this.setSize(500, 300);
        try {
            MetaConfig mt = MetaConfig.getInstance();
        }
        catch (MetaConfigException mcEx) {
            JOptionPane.showMessageDialog(null, "Exception while parsing JGAP Meta Config file " + mcEx.getMessage(), "Meta Config Exception", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Exception while parsing JGAP Meta Config file " + ex.getMessage(), "Meta Config Exception", 0);
        }
        this.setup();
        this.show();
        if (this.m_isRoot) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    @Override
    public ConfigData getConfigData() {
        ConfigData cd = new ConfigData();
        cd.setNS(this.m_conHandler.getClass().getName());
        try {
            for (ListGroup lg : this.m_listGroups) {
                List<String> values = Collections.synchronizedList(new ArrayList());
                Enumeration e = lg.getOutListModel().elements();
                while (e.hasMoreElements()) {
                    String val = (String)e.nextElement();
                    values.add(val);
                }
                cd.addListData(lg.getProp().getName(), values);
            }
            for (TextGroup tg : this.m_textGroups) {
                cd.addTextData(tg.getProp().getName(), tg.getTextField().getText());
            }
        }
        catch (ClassCastException cex) {
            JOptionPane.showMessageDialog(null, cex.getMessage(), "ConfigFrame.getConfigData():Configuration Error", 1);
        }
        return cd;
    }

    @Override
    public String getFileName() {
        if (this.m_isRoot) {
            String fName = this.m_fileName.getText();
            if (fName.equals("")) {
                fName = m_defaultConfigFile;
            }
            return fName;
        }
        return this.m_parent.getFileName();
    }

    private void setup() {
        int numLists = 0;
        int numTexts = 0;
        List props = null;
        try {
            props = MetaConfig.getInstance().getConfigProperty(this.m_conHandler.getClass().getName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Configuration Error: Could not get properties for class " + this.m_conHandler.getClass().getName(), 1);
        }
        if (props == null) {
            JOptionPane.showMessageDialog(null, "setup():No Configurable Properties in this Configuration", "Configuration Message", 1);
            return;
        }
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            try {
                ConfigProperty prop = (ConfigProperty)iter.next();
                if (prop.getWidget().equals("JList")) {
                    ++numLists;
                    this.m_listProps.add(prop);
                    continue;
                }
                if (prop.getWidget().equals("JTextField")) {
                    ++numTexts;
                    this.m_textProps.add(prop);
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Unknown Widget " + prop.getWidget(), "Configuration Error", 1);
            }
            catch (ClassCastException cex) {
                JOptionPane.showMessageDialog(null, cex.getMessage(), "ConfigError.setup():Configuration Error: Invalid cast", 1);
            }
        }
        if (numLists == 0 && numTexts == 0) {
            JOptionPane.showMessageDialog(null, "No Configurable Properties in this Configuration", "Configuration Information", 1);
            return;
        }
        int numPanels = 2;
        if (numLists > 0 && numTexts > 0) {
            numPanels = 3;
        }
        this.addWidgets(numPanels, numLists, numTexts);
    }

    private void addWidgets(int a_numPanels, int a_numLists, int a_numTexts) {
        try {
            double[][] panelSize;
            int numCols;
            a_numPanels = 3;
            double[][] tableArray = new double[2][a_numPanels];
            double perPanel = 1.0 / (double)a_numPanels;
            int i = 0;
            for (i = 0; i < a_numPanels - 1; ++i) {
                tableArray[1][i] = perPanel;
            }
            tableArray[1][i] = -1.0;
            tableArray[0][0] = -1.0;
            this.getContentPane().setLayout((LayoutManager)new TableLayout(tableArray));
            int panelsAdded = 0;
            if (a_numLists > 0) {
                numCols = 3 * a_numLists;
                panelSize = new double[2][numCols];
                double space = 1.0 / (double)a_numLists;
                double listSpace = space * 0.4;
                double buttonSpace = space * 0.2;
                for (int itr = 0; itr < a_numLists; ++itr) {
                    panelSize[0][3 * itr] = listSpace;
                    panelSize[0][3 * itr + 1] = buttonSpace;
                    panelSize[0][3 * itr + 2] = listSpace;
                }
                panelSize[1][0] = -1.0;
                this.m_listPanel = new JPanel();
                this.m_panels.add(this.m_listPanel);
                this.m_listPanel.setLayout((LayoutManager)new TableLayout(panelSize));
                this.getContentPane().add((Component)this.m_listPanel, new TableLayoutConstraints(0, panelsAdded, 0, panelsAdded, 2, 2));
                ++panelsAdded;
                Iterator iter = this.m_listProps.iterator();
                for (int itr1 = 0; itr1 < a_numLists && iter.hasNext(); ++itr1) {
                    ListGroup lg = new ListGroup(this);
                    this.m_listGroups.add(lg);
                    ConfigProperty prop = (ConfigProperty)iter.next();
                    lg.setProp(prop);
                    this.m_listPanel.add((Component)lg.getListScroller(), new TableLayoutConstraints(3 * itr1, 0, 3 * itr1, 0, 1, 1));
                    this.m_listPanel.add((Component)lg.getLButton(), new TableLayoutConstraints(3 * itr1 + 1, 0, 3 * itr1 + 1, 0, 1, 0));
                    this.m_listPanel.add((Component)lg.getRButton(), new TableLayoutConstraints(3 * itr1 + 1, 0, 3 * itr1 + 1, 0, 1, 3));
                    Iterator valIter = prop.getValuesIter();
                    while (valIter.hasNext()) {
                        lg.getListModel().addElement(valIter.next());
                    }
                    this.m_listPanel.add((Component)lg.getOutListScroller(), new TableLayoutConstraints(3 * itr1 + 2, 0, 3 * itr1 + 2, 0, 1, 1));
                }
            }
            if (a_numTexts > 0) {
                numCols = a_numTexts * 2;
                panelSize = new double[2][numCols];
                double perText = 1.0 / (double)numCols;
                int itr = 0;
                for (itr = 0; itr < numCols - 1; ++itr) {
                    panelSize[0][itr] = perText;
                }
                panelSize[0][itr] = -1.0;
                panelSize[1][0] = -1.0;
                this.m_textPanel = new JPanel();
                this.m_panels.add(this.m_textPanel);
                this.m_textPanel.setLayout((LayoutManager)new TableLayout(panelSize));
                this.getContentPane().add((Component)this.m_textPanel, new TableLayoutConstraints(0, panelsAdded, 0, panelsAdded, 2, 2));
                ++panelsAdded;
                Iterator iter = this.m_textProps.iterator();
                for (int itr1 = 0; itr1 < a_numTexts && iter.hasNext(); ++itr1) {
                    TextGroup tg = new TextGroup();
                    this.m_textGroups.add(tg);
                    ConfigProperty prop = (ConfigProperty)iter.next();
                    tg.setProp(prop);
                    JLabel label = tg.getLabel();
                    label.setText(prop.getName());
                    this.m_textPanel.add((Component)label, new TableLayoutConstraints(itr1, 0, itr1, 0, 3, 1));
                    this.m_textPanel.add((Component)tg.getTextField(), new TableLayoutConstraints(itr1 + 1, 0, itr1 + 1, 0, 0, 1));
                }
            }
            panelSize = new double[2][4];
            panelSize[0][0] = 0.25;
            panelSize[0][1] = 0.25;
            panelSize[0][2] = 0.25;
            panelSize[0][3] = 0.25;
            panelSize[1][0] = -1.0;
            this.m_configPanel = new JPanel();
            this.m_panels.add(this.m_configPanel);
            this.m_configPanel.setLayout((LayoutManager)new TableLayout(panelSize));
            this.getContentPane().add((Component)this.m_configPanel, new TableLayoutConstraints(0, panelsAdded, 0, panelsAdded, 2, 2));
            this.m_configItem = new JTextField(50);
            this.m_configPanel.add((Component)this.m_configItem, new TableLayoutConstraints(0, 0, 0, 0, 3, 1));
            this.m_configureButton = new JButton("Configure");
            this.m_configureButton.addActionListener(this.m_cbl);
            this.m_configPanel.add((Component)this.m_configureButton, new TableLayoutConstraints(1, 0, 1, 0, 0, 1));
            if (this.m_isRoot) {
                this.m_fileName = new JTextField(m_defaultConfigFile);
                this.m_configPanel.add((Component)this.m_fileName, new TableLayoutConstraints(2, 0, 2, 0, 3, 1));
                this.m_configButton = new JButton("Generate");
                this.m_configButton.addActionListener(this.m_cbl);
                this.m_configPanel.add((Component)this.m_configButton, new TableLayoutConstraints(3, 0, 3, 0, 0, 1));
            } else {
                this.m_configButton = new JButton("Save Configuration");
                this.m_configButton.addActionListener(this.m_cbl);
                this.m_configPanel.add((Component)this.m_configButton, new TableLayoutConstraints(3, 0, 3, 0, 0, 1));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Exception" + ex.toString(), "This is the title", 1);
        }
    }

    private void notifySelection(String a_value) {
        this.m_configItem.setText(a_value);
    }

    public class ConfigListSelectionListener
    implements ListSelectionListener {
        private JList m_list;
        private ConfigFrame m_frame;

        public ConfigListSelectionListener(ConfigFrame a_frame, JList a_list) {
            this.m_list = a_list;
            this.m_frame = a_frame;
        }

        @Override
        public void valueChanged(ListSelectionEvent a_e) {
            Object[] values = this.m_list.getSelectedValues();
            if (values.length > 0) {
                String value = (String)values[0];
                ConfigFrame.this.notifySelection(value);
            }
        }
    }

    public class ListButtonListener
    implements ActionListener {
        private ListGroup m_lg;

        ListButtonListener(ListGroup a_lg) {
            this.m_lg = a_lg;
        }

        @Override
        public void actionPerformed(ActionEvent a_e) {
            if (a_e.getActionCommand().equals("<-")) {
                this.m_lg.leftButtonPressed();
            } else {
                this.m_lg.rightButtonPressed();
            }
        }
    }

    class ConfigButtonListener
    implements ActionListener {
        private ConfigFrame m_frame;

        ConfigButtonListener(ConfigFrame a_frame) {
            this.m_frame = a_frame;
        }

        @Override
        public void actionPerformed(ActionEvent a_e) {
            if (a_e.getActionCommand().equals("Configure")) {
                String conStr = ConfigFrame.this.m_configItem.getText();
                if (conStr.equals("")) {
                    JOptionPane.showMessageDialog(null, "Configurable name is empty, cannot configure.", "Configuration Error", 1);
                } else {
                    try {
                        Class<?> conClass;
                        ConfigFrame.this.m_conObj = null;
                        try {
                            conClass = Class.forName(conStr);
                        }
                        catch (ClassNotFoundException cnfEx) {
                            JOptionPane.showMessageDialog(null, cnfEx.getMessage(), "Configuration Error: Class not found", 1);
                            return;
                        }
                        try {
                            ConfigFrame.this.m_conObj = (Configurable)conClass.newInstance();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "Configuration Error:Could not create object", 1);
                            return;
                        }
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GUIManager.getInstance().showFrame(ConfigButtonListener.this.m_frame, ConfigFrame.this.m_conObj);
                                    }
                                    catch (Exception ex) {
                                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Configuration Error:Could not create new Frame", 0);
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "Configuration Error:Could not create new frame", 0);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Configuration Error", 1);
                    }
                }
            } else {
                ConfigWriter.getInstance().write(this.m_frame);
            }
        }
    }

    class TextGroup {
        private JTextField m_textField = new JTextField(20);
        private JLabel m_label = new JLabel();
        private ConfigProperty m_prop;

        TextGroup() {
        }

        public ConfigProperty getProp() {
            return this.m_prop;
        }

        public void setProp(ConfigProperty a_prop) {
            this.m_prop = a_prop;
        }

        public JTextField getTextField() {
            return this.m_textField;
        }

        public JLabel getLabel() {
            return this.m_label;
        }
    }

    public class ListGroup {
        private JList m_list;
        private DefaultListModel m_listModel;
        private JScrollPane m_listScroller;
        private JList m_outList;
        private DefaultListModel m_outListModel;
        private JScrollPane m_outListScroller;
        private ConfigListSelectionListener m_outListListener;
        private JButton m_lButton;
        private JButton m_rButton;
        private ConfigProperty m_prop;
        private ListButtonListener m_listBL;
        private ConfigFrame m_frame;

        ListGroup(ConfigFrame a_frame) {
            this.m_frame = a_frame;
            this.m_listModel = new DefaultListModel();
            this.m_list = new JList(this.m_listModel);
            this.m_list.setSelectionMode(1);
            this.m_list.setLayoutOrientation(2);
            this.m_list.setVisibleRowCount(-1);
            this.m_listScroller = new JScrollPane(this.m_list);
            this.m_listScroller.setPreferredSize(new Dimension(250, 80));
            this.m_outListModel = new DefaultListModel();
            this.m_outList = new JList(this.m_outListModel);
            this.m_outList.setSelectionMode(0);
            this.m_outList.setLayoutOrientation(2);
            this.m_outList.setVisibleRowCount(-1);
            this.m_outListScroller = new JScrollPane(this.m_outList);
            this.m_outListListener = new ConfigListSelectionListener(this.m_frame, this.m_outList);
            this.m_outList.getSelectionModel().addListSelectionListener(this.m_outListListener);
            this.m_outListScroller.setPreferredSize(new Dimension(250, 80));
            this.m_listBL = new ListButtonListener(this);
            this.m_lButton = new JButton("<-");
            this.m_lButton.addActionListener(this.m_listBL);
            this.m_rButton = new JButton("->");
            this.m_rButton.addActionListener(this.m_listBL);
        }

        public ConfigProperty getProp() {
            return this.m_prop;
        }

        public void setProp(ConfigProperty a_prop) {
            this.m_prop = a_prop;
        }

        public JList getList() {
            return this.m_list;
        }

        public DefaultListModel getListModel() {
            return this.m_listModel;
        }

        public JScrollPane getListScroller() {
            return this.m_listScroller;
        }

        public JList getOutList() {
            return this.m_outList;
        }

        public DefaultListModel getOutListModel() {
            return this.m_outListModel;
        }

        public JScrollPane getOutListScroller() {
            return this.m_outListScroller;
        }

        public JButton getLButton() {
            return this.m_lButton;
        }

        public JButton getRButton() {
            return this.m_rButton;
        }

        public void leftButtonPressed() {
            int[] indices = this.m_outList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                String removed = (String)this.m_outListModel.remove(indices[0]);
                this.m_listModel.addElement(removed);
            }
        }

        public void rightButtonPressed() {
            int[] indices = this.m_list.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                String removed = (String)this.m_listModel.remove(indices[0]);
                this.m_outListModel.addElement(removed);
            }
        }
    }
}

