/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.ICloneHandler;
import org.jgap.INaturalSelector;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ChainOfSelectors
implements Serializable,
ICloneable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.19 $";
    private List m_selectors = new Vector();
    private Configuration m_conf;

    public ChainOfSelectors() {
        this(Genotype.getStaticConfiguration());
    }

    public ChainOfSelectors(Configuration a_conf) {
        this.m_conf = a_conf;
    }

    public void addNaturalSelector(NaturalSelector a_selector) throws InvalidConfigurationException {
        if (a_selector == null) {
            throw new InvalidConfigurationException("This Configuration object is locked. Settings may not be altered.");
        }
        this.m_selectors.add(a_selector);
    }

    public void addAll(Collection a_c) throws InvalidConfigurationException {
        for (NaturalSelector selector : a_c) {
            this.addNaturalSelector(selector);
        }
    }

    public int size() {
        return this.m_selectors.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        return this.m_selectors.hashCode();
    }

    public boolean equals(Object a_obj) {
        try {
            ChainOfSelectors c2 = (ChainOfSelectors)a_obj;
            if (c2 == null) {
                return false;
            }
            return this.m_selectors.equals(c2.m_selectors);
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public NaturalSelector get(int a_index) {
        return (NaturalSelector)this.m_selectors.get(a_index);
    }

    public void clear() {
        this.m_selectors.clear();
    }

    public Iterator iterator() {
        return this.m_selectors.iterator();
    }

    @Override
    public Object clone() {
        try {
            ChainOfSelectors result = new ChainOfSelectors(this.m_conf);
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < this.m_selectors.size(); ++i) {
                INaturalSelector o = (INaturalSelector)this.m_selectors.get(i);
                ICloneHandler handler = this.m_conf.getJGAPFactory().getCloneHandlerFor(o, null);
                if (handler == null) {
                    throw new IllegalStateException("No clone handler found for class " + o.getClass().getName());
                }
                Object clone = handler.perform(o, null, null);
                v.add(clone);
            }
            result.m_selectors = v;
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        ChainOfSelectors other = (ChainOfSelectors)a_other;
        int size = this.m_selectors.size();
        if (other.m_selectors.size() < size) {
            return 1;
        }
        if (other.m_selectors.size() > this.m_selectors.size()) {
            return -1;
        }
        for (int i = 0; i < size; ++i) {
            String nameOther;
            String name = this.m_selectors.get(i).getClass().getName();
            int result = name.compareTo(nameOther = other.m_selectors.get(i).getClass().getName());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

