/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IBusinessKey;
import org.jgap.ICompositeGene;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class CompositeGene
extends BaseGene
implements ICompositeGene,
IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.60 $";
    public static final String GENE_DELIMITER = "#";
    public static final String GENE_DELIMITER_HEADING = "<";
    public static final String GENE_DELIMITER_CLOSING = ">";
    private Gene m_geneTypeAllowed;
    private List<Gene> m_genes = new Vector<Gene>();

    public CompositeGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public CompositeGene(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, null);
    }

    public CompositeGene(Configuration a_config, Gene a_geneTypeAllowed) throws InvalidConfigurationException {
        super(a_config);
        if (a_geneTypeAllowed != null) {
            this.m_geneTypeAllowed = a_geneTypeAllowed;
        }
    }

    @Override
    public void addGene(Gene a_gene) {
        this.addGene(a_gene, false);
    }

    public Gene getGeneTypeAllowed() {
        return this.m_geneTypeAllowed;
    }

    public void addGene(Gene a_gene, boolean a_strict) {
        if (a_gene == null) {
            throw new IllegalArgumentException("Gene instance must not be null!");
        }
        if (this.m_geneTypeAllowed != null && !a_gene.getClass().getName().equals(this.m_geneTypeAllowed.getClass().getName())) {
            throw new IllegalArgumentException("Adding a " + a_gene.getClass().getName() + " has been forbidden!");
        }
        boolean containsGene = !a_strict ? this.containsGeneByIdentity(a_gene) : this.m_genes.contains(a_gene);
        if (containsGene) {
            throw new IllegalArgumentException("The gene is already contained in the CompositeGene!");
        }
        this.m_genes.add(a_gene);
    }

    public boolean removeGeneByIdentity(Gene a_gene) {
        int size = this.size();
        if (size < 1) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.geneAt(i) != a_gene) continue;
            this.m_genes.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeGene(Gene a_gene) {
        return this.m_genes.remove(a_gene);
    }

    @Override
    public void cleanup() {
        int size = this.m_genes.size();
        for (int i = 0; i < size; ++i) {
            Gene gene = this.m_genes.get(i);
            gene.cleanup();
        }
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        if (a_numberGenerator == null) {
            throw new IllegalArgumentException("Random generatoe must not be null!");
        }
        int size = this.m_genes.size();
        for (int i = 0; i < size; ++i) {
            Gene gene = this.m_genes.get(i);
            gene.setToRandomValue(a_numberGenerator);
        }
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            try {
                this.m_genes.clear();
                List r = CompositeGene.split(a_representation);
                Iterator iter = r.iterator();
                while (iter.hasNext()) {
                    String g = this.decode((String)iter.next());
                    StringTokenizer st = new StringTokenizer(g, GENE_DELIMITER);
                    if (st.countTokens() != 2) {
                        throw new UnsupportedRepresentationException("In " + g + ", " + "expecting two tokens, separated by " + GENE_DELIMITER);
                    }
                    String clas = st.nextToken();
                    String representation = st.nextToken();
                    Gene gene = this.createGene(clas, representation);
                    this.addGene(gene);
                }
            }
            catch (Exception ex) {
                throw new UnsupportedRepresentationException(ex.toString());
            }
        }
    }

    protected Gene createGene(String a_geneClassName, String a_persistentRepresentation) throws Exception {
        Class<?> geneClass = Class.forName(a_geneClassName);
        Constructor<?> constr = geneClass.getConstructor(Configuration.class);
        Gene gene = (Gene)constr.newInstance(this.getConfiguration());
        gene.setValueFromPersistentRepresentation(a_persistentRepresentation);
        return gene;
    }

    @Override
    public String getPersistentRepresentation() throws UnsupportedOperationException {
        StringBuffer b = new StringBuffer();
        for (Gene gene : this.m_genes) {
            b.append(GENE_DELIMITER_HEADING);
            b.append(this.encode(gene.getClass().getName() + GENE_DELIMITER + gene.getPersistentRepresentation()));
            b.append(GENE_DELIMITER_CLOSING);
        }
        return b.toString();
    }

    @Override
    public Object getAllele() {
        Vector<Object> alleles = new Vector<Object>();
        int size = this.m_genes.size();
        for (int i = 0; i < size; ++i) {
            Gene gene = this.m_genes.get(i);
            alleles.add(gene.getAllele());
        }
        return alleles;
    }

    @Override
    public void setAllele(Object a_newValue) {
        if (!(a_newValue instanceof List)) {
            throw new IllegalArgumentException("The expected type of the allele is a List descendent.");
        }
        if (this.getConstraintChecker() != null && !this.getConstraintChecker().verify(this, a_newValue, null, -1)) {
            return;
        }
        List alleles = (List)a_newValue;
        for (int i = 0; i < alleles.size(); ++i) {
            Gene gene = this.m_genes.get(i);
            gene.setAllele(alleles.get(i));
        }
    }

    @Override
    protected Gene newGeneInternal() {
        try {
            CompositeGene compositeGene = new CompositeGene(this.getConfiguration());
            compositeGene.setConstraintChecker(this.getConstraintChecker());
            int geneSize = this.m_genes.size();
            for (int i = 0; i < geneSize; ++i) {
                Gene gene = this.m_genes.get(i);
                compositeGene.addGene(gene.newGene(), false);
            }
            return compositeGene;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        if (!(a_other instanceof CompositeGene)) {
            return this.getClass().getName().compareTo(a_other.getClass().getName());
        }
        CompositeGene otherCompositeGene = (CompositeGene)a_other;
        if (otherCompositeGene.isEmpty()) {
            if (this.isEmpty()) {
                return 0;
            }
            return 1;
        }
        int numberGenes = Math.min(this.size(), otherCompositeGene.size());
        for (int i = 0; i < numberGenes; ++i) {
            Gene gene2;
            Gene gene1 = this.geneAt(i);
            int result = gene1.compareTo(gene2 = otherCompositeGene.geneAt(i));
            if (result == 0) continue;
            return result;
        }
        if (this.size() == otherCompositeGene.size()) {
            if (this.isCompareApplicationData()) {
                return this.compareApplicationData(this.getApplicationData(), otherCompositeGene.getApplicationData());
            }
            return 0;
        }
        if (this.size() > otherCompositeGene.size()) {
            return 1;
        }
        return -1;
    }

    @Override
    public String toString() {
        if (this.m_genes.isEmpty()) {
            return "CompositeGene=null";
        }
        String result = "CompositeGene=(";
        for (int i = 0; i < this.m_genes.size(); ++i) {
            Gene gene = this.m_genes.get(i);
            result = result + gene;
            if (i >= this.m_genes.size() - 1) continue;
            result = result + GENE_DELIMITER;
        }
        return result + ")";
    }

    public boolean isEmpty() {
        return this.m_genes.isEmpty();
    }

    @Override
    public Gene geneAt(int a_index) {
        return this.m_genes.get(a_index);
    }

    public List<Gene> getGenes() {
        return this.m_genes;
    }

    @Override
    public int size() {
        return this.m_genes.size();
    }

    public boolean containsGeneByIdentity(Gene gene) {
        boolean result;
        int size = this.size();
        if (size < 1) {
            result = false;
        } else {
            result = false;
            for (int i = 0; i < size; ++i) {
                if (this.geneAt(i) != gene) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public void applyMutation(int a_index, double a_percentage) {
        throw new RuntimeException("applyMutation may not be called for a CompositeGene. Call this method for each gene contained in the CompositeGene.");
    }

    protected static final List split(String a_string) throws UnsupportedRepresentationException {
        List<String> a = Collections.synchronizedList(new ArrayList());
        StringTokenizer st = new StringTokenizer(a_string, "<>", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(GENE_DELIMITER_HEADING)) {
                throw new UnsupportedRepresentationException(a_string + " no opening tag");
            }
            String n = st.nextToken();
            if (n.equals(GENE_DELIMITER_CLOSING)) {
                a.add("");
                continue;
            }
            a.add(n);
            if (st.nextToken().equals(GENE_DELIMITER_CLOSING)) continue;
            throw new UnsupportedRepresentationException(a_string + " no closing tag");
        }
        return a;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size(); ++i) {
            int geneHashcode = this.geneAt(i).hashCode();
            hashCode = 31 * hashCode + geneHashcode;
        }
        return hashCode;
    }

    @Override
    protected Object getInternalValue() {
        return null;
    }

    @Override
    public String getBusinessKey() {
        Iterator<Gene> iter = this.m_genes.iterator();
        StringBuffer b = new StringBuffer();
        while (iter.hasNext()) {
            Gene gene = iter.next();
            b.append(GENE_DELIMITER_HEADING);
            if (IBusinessKey.class.isAssignableFrom(gene.getClass())) {
                b.append(((IBusinessKey)((Object)gene)).getBusinessKey());
            } else {
                b.append(gene.getPersistentRepresentation());
            }
            b.append(GENE_DELIMITER_CLOSING);
        }
        return b.toString();
    }
}

