/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import gnu.trove.THashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class MapGene
extends BaseGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.26 $";
    private THashMap m_geneMap = new THashMap();
    private Object m_value;
    static final String ALLELEMAP_BEGIN_DELIMITER = "[";
    static final String ALLELEMAP_END_DELIMITER = "]";

    public MapGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public MapGene(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
    }

    public MapGene(Configuration a_config, Map a_alleles) throws InvalidConfigurationException {
        super(a_config);
        this.addAlleles(a_alleles);
    }

    @Override
    protected Gene newGeneInternal() {
        try {
            MapGene result = new MapGene(this.getConfiguration(), (Map)this.m_geneMap);
            Object value = this.getAllele();
            result.setAllele(value);
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public void addAllele(Object a_key, Object a_value) {
        this.m_geneMap.put(a_key, a_value);
    }

    public void addAllele(Object a_value) {
        this.m_geneMap.put(a_value, a_value);
    }

    public void addAllele(int a_value) {
        this.m_geneMap.put((Object)new Integer(a_value), (Object)new Integer(a_value));
    }

    public void addAlleles(Map a_alleles) {
        if (a_alleles == null) {
            throw new IllegalArgumentException("List of alleles must not be null!");
        }
        this.m_geneMap.putAll(a_alleles);
    }

    public void removeAlleles(Object a_key) {
        this.m_geneMap.remove(a_key);
    }

    public Map getAlleles() {
        return this.m_geneMap;
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.m_value = this.m_geneMap.isEmpty() ? new Integer(a_numberGenerator.nextInt()) : this.m_geneMap.get(this.m_geneMap.keySet().toArray()[a_numberGenerator.nextInt(this.m_geneMap.size())]);
    }

    @Override
    public void applyMutation(int a_index, double a_percentage) {
        RandomGenerator rn = this.getConfiguration().getRandomGenerator();
        this.setToRandomValue(rn);
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 2) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it must contain two tokens.");
            }
            String valueRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.m_value = null;
            } else {
                try {
                    this.m_value = new Integer(Integer.parseInt(valueRepresentation));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            String s = tokenizer.nextToken();
            tokenizer = new StringTokenizer(s, ",");
            int lastWasOpening = 0;
            String key = null;
            String keyClass = null;
            String valueClass = null;
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken(",");
                if (lastWasOpening == 1) {
                    key = element.substring(0);
                    lastWasOpening = 2;
                    continue;
                }
                if (lastWasOpening == 2) {
                    valueClass = element.substring(0);
                    lastWasOpening = 3;
                    continue;
                }
                if (lastWasOpening == 3) {
                    if (element.endsWith(")")) {
                        element = element.substring(0, element.length() - 1);
                        try {
                            Class<?> keyType = Class.forName(keyClass);
                            Constructor<?> keyC = keyType.getConstructor(String.class);
                            Object keyObject = keyC.newInstance(key);
                            Class<?> valueType = Class.forName(valueClass);
                            Constructor<?> valueC = valueType.getConstructor(String.class);
                            Object valueObject = valueC.newInstance(element);
                            this.addAllele(keyObject, valueObject);
                            lastWasOpening = 0;
                            continue;
                        }
                        catch (Exception cex) {
                            throw new UnsupportedRepresentationException("Invalid class: " + keyClass);
                        }
                    }
                    throw new IllegalStateException("Closing bracket missing");
                }
                if (element.startsWith("(")) {
                    keyClass = element.substring(1);
                    lastWasOpening = 1;
                    continue;
                }
                throw new IllegalStateException("Opening bracket missing");
            }
            if (lastWasOpening != 0) {
                throw new IllegalStateException("Elements missing");
            }
        }
    }

    @Override
    public String getPersistentRepresentation() throws UnsupportedOperationException {
        Iterator it = this.m_geneMap.keySet().iterator();
        StringBuffer strbf = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                strbf.append(",");
            }
            Object key = it.next();
            Object value = this.m_geneMap.get(key);
            strbf.append("(" + key.getClass().getName() + "," + key.toString() + "," + value.getClass().getName() + "," + value.toString() + ")");
            first = false;
        }
        return this.m_value.toString() + ":" + strbf.toString();
    }

    @Override
    public void setAllele(Object a_newValue) {
        if (a_newValue == null) {
            return;
        }
        if (this.m_geneMap.values().isEmpty()) {
            this.m_value = a_newValue;
        } else if (this.m_geneMap.values().contains(a_newValue)) {
            this.m_value = a_newValue;
        } else {
            throw new IllegalArgumentException("Allele value being set (" + a_newValue + ") is not an element of the set of" + " permitted values.");
        }
    }

    public int compareTo(Object a_other) {
        MapGene otherGene = (MapGene)a_other;
        if (otherGene == null) {
            return 1;
        }
        if (otherGene.m_value == null && this.m_value != null) {
            return 1;
        }
        try {
            int size1 = this.m_geneMap.size();
            int size2 = otherGene.m_geneMap.size();
            if (size1 != size2) {
                if (size1 < size2) {
                    return -1;
                }
                return 1;
            }
            for (Object key1 : this.m_geneMap.keySet()) {
                if (!otherGene.m_geneMap.keySet().contains(key1)) {
                    Object key2 = otherGene.m_geneMap.keySet().iterator().next();
                    if (Comparable.class.isAssignableFrom(key1.getClass()) && Comparable.class.isAssignableFrom(key2.getClass())) {
                        return ((Comparable)key1).compareTo(key2);
                    }
                    return -1;
                }
                Object value1 = this.m_geneMap.get(key1);
                Object value2 = otherGene.m_geneMap.get(key1);
                if (value1 == null && value2 != null) {
                    return -1;
                }
                if (value1 == null && value2 != null) {
                    return -1;
                }
                if (value1.equals(value2)) continue;
                if (value2 == null) {
                    return 1;
                }
                if (Comparable.class.isAssignableFrom(value1.getClass()) && Comparable.class.isAssignableFrom(value2.getClass())) {
                    return ((Comparable)value1).compareTo(value2);
                }
                return -1;
            }
            if (this.m_value == null) {
                if (otherGene.m_value != null) {
                    return 1;
                }
                return 0;
            }
            Method method = this.m_value.getClass().getMethod("compareTo", otherGene.m_value.getClass());
            Integer i = (Integer)method.invoke(this.m_value, otherGene.m_value);
            return i;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("CompareTo method of the Gene value object cannot be invoked.");
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("The value object of the Gene does not have a compareTo method.  It cannot be compared.");
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("The compareTo method of the Gene value object cannot be accessed ");
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("The compareTo method of the Gene value object cannot be accessed.  Insufficient permission levels.");
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("The value object of the Gene does not have a compareTo method.  It cannot be compared.");
        }
    }

    @Override
    protected Object getInternalValue() {
        return this.m_value;
    }

    @Override
    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -71;
        }
        return super.hashCode();
    }

    @Override
    public String toString() {
        String result = ALLELEMAP_BEGIN_DELIMITER;
        if (this.m_geneMap.size() < 1) {
            result = result + "null";
        } else {
            Set keys = this.m_geneMap.keySet();
            Iterator keyIterator = keys.iterator();
            boolean firstTime = true;
            while (keyIterator.hasNext()) {
                if (!firstTime) {
                    result = result + ",";
                } else {
                    firstTime = false;
                }
                Object key = keyIterator.next();
                String keyString = key == null ? "null" : key.toString();
                result = result + "(" + keyString + ",";
                Object value = this.m_geneMap.get(key);
                String valueString = value == null ? "null" : value.toString();
                result = result + valueString + ")";
            }
        }
        result = result + ALLELEMAP_END_DELIMITER;
        return result;
    }
}

